/*
 * Decompiled with CFR 0.152.
 */
package com.thimbleware.jmemcached.storage.bytebuffer;

import com.thimbleware.jmemcached.Key;
import com.thimbleware.jmemcached.LocalCacheElement;
import com.thimbleware.jmemcached.storage.CacheStorage;
import com.thimbleware.jmemcached.storage.bytebuffer.BlockStoreFactory;
import com.thimbleware.jmemcached.storage.bytebuffer.ByteBufferBlockStore;
import com.thimbleware.jmemcached.storage.bytebuffer.Region;
import com.thimbleware.jmemcached.storage.hash.ConcurrentLinkedHashMap;
import com.thimbleware.jmemcached.storage.hash.SizedItem;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BlockStorageCacheStorage
implements CacheStorage<Key, LocalCacheElement> {
    ByteBufferBlockStore[] blockStorage;
    ReentrantReadWriteLock[] storageLock;
    final AtomicInteger ceilingBytes;
    final AtomicInteger maximumItems;
    final ConcurrentMap<Key, StoredValue> index;
    final long maximumSizeBytes;

    public BlockStorageCacheStorage(int blockStoreBuckets, int ceilingBytesParam, int blockSizeBytes, long maximumSizeBytes, int maximumItemsVal, BlockStoreFactory factory) {
        this.blockStorage = new ByteBufferBlockStore[blockStoreBuckets];
        this.storageLock = new ReentrantReadWriteLock[blockStoreBuckets];
        long bucketSizeBytes = maximumSizeBytes / (long)blockStoreBuckets;
        for (int i = 0; i < blockStoreBuckets; ++i) {
            this.blockStorage[i] = factory.manufacture(bucketSizeBytes, blockSizeBytes);
            this.storageLock[i] = new ReentrantReadWriteLock();
        }
        this.ceilingBytes = new AtomicInteger(ceilingBytesParam);
        this.maximumItems = new AtomicInteger(maximumItemsVal);
        this.maximumSizeBytes = maximumSizeBytes;
        this.index = ConcurrentLinkedHashMap.create(ConcurrentLinkedHashMap.EvictionPolicy.LRU, maximumItemsVal, maximumSizeBytes, new ConcurrentLinkedHashMap.EvictionListener<Key, StoredValue>(){

            @Override
            public void onEviction(Key key, StoredValue value) {
                value.free();
            }
        });
    }

    private int pickBucket(Key key, int partitionNum) {
        return new Random().nextInt(this.blockStorage.length);
    }

    @Override
    public final long getMemoryCapacity() {
        long capacity = 0L;
        for (ByteBufferBlockStore byteBufferBlockStore : this.blockStorage) {
            capacity += byteBufferBlockStore.getStoreSizeBytes();
        }
        return capacity;
    }

    @Override
    public final long getMemoryUsed() {
        long memUsed = 0L;
        for (ByteBufferBlockStore byteBufferBlockStore : this.blockStorage) {
            memUsed += byteBufferBlockStore.getStoreSizeBytes() - byteBufferBlockStore.getFreeBytes();
        }
        return memUsed;
    }

    @Override
    public final int capacity() {
        return this.maximumItems.get();
    }

    @Override
    public final void close() throws IOException {
        this.clear();
        for (ByteBufferBlockStore byteBufferBlockStore : this.blockStorage) {
            byteBufferBlockStore.close();
        }
        this.blockStorage = null;
        this.storageLock = null;
    }

    @Override
    public final LocalCacheElement putIfAbsent(Key key, LocalCacheElement item) {
        StoredValue val = (StoredValue)this.index.get(key);
        if (val != null) {
            return val.toElement(key);
        }
        this.put(key, item);
        return null;
    }

    @Override
    public final boolean remove(Object key, Object value) {
        if (!(key instanceof Key) || !(value instanceof LocalCacheElement)) {
            return false;
        }
        StoredValue val = (StoredValue)this.index.get(key);
        LocalCacheElement el = val.toElement((Key)key);
        if (!el.equals(value)) {
            return false;
        }
        this.index.remove(key);
        val.free();
        return true;
    }

    @Override
    public final boolean replace(Key key, LocalCacheElement original, LocalCacheElement replace) {
        StoredValue val = (StoredValue)this.index.get(key);
        LocalCacheElement el = val.toElement(key);
        if (!el.equals(original)) {
            return false;
        }
        this.remove(key);
        this.put(key, replace);
        return true;
    }

    @Override
    public final LocalCacheElement replace(Key key, LocalCacheElement replace) {
        StoredValue val = (StoredValue)this.index.get(key);
        if (!this.index.containsKey(key)) {
            return null;
        }
        this.remove(key);
        this.put(key, replace);
        return replace;
    }

    @Override
    public final int size() {
        return this.index.size();
    }

    @Override
    public final boolean isEmpty() {
        return this.index.isEmpty();
    }

    @Override
    public final boolean containsKey(Object o) {
        return this.index.containsKey(o);
    }

    @Override
    public final boolean containsValue(Object o) {
        throw new RuntimeException("operation not supporteded");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final LocalCacheElement get(Object key) {
        if (!(key instanceof Key)) {
            return null;
        }
        StoredValue val = (StoredValue)this.index.get(key);
        if (val == null) {
            return null;
        }
        try {
            this.lockRead(val);
            LocalCacheElement localCacheElement = val.toElement((Key)key);
            return localCacheElement;
        }
        finally {
            this.unlockRead(val);
        }
    }

    public static int numBuckets(int size, int bucketSize) {
        int mod = size % bucketSize;
        int div = size / bucketSize;
        return mod == 0 ? div : div + 1;
    }

    @Override
    public final LocalCacheElement put(Key key, LocalCacheElement item) {
        int bucket;
        int i;
        int numBuckets = BlockStorageCacheStorage.numBuckets(item.size(), (int)(this.maximumSizeBytes / (long)this.blockStorage.length));
        ChannelBuffer readBuffer = item.getData();
        Region[] regions = new Region[numBuckets];
        int[] buckets = new int[numBuckets];
        for (i = 0; i < numBuckets; ++i) {
            buckets[i] = bucket = this.pickBucket(key, i);
            this.storageLock[bucket].writeLock().lock();
        }
        for (i = 0; i < numBuckets; ++i) {
            bucket = buckets[i];
            int fragmentSize = i < numBuckets - 1 ? item.size() / numBuckets : readBuffer.readableBytes();
            regions[i] = this.blockStorage[bucket].alloc(fragmentSize, readBuffer);
        }
        for (int bucket2 : buckets) {
            this.storageLock[bucket2].writeLock().unlock();
        }
        StoredValue old = this.index.put(key, new StoredValue(item.getFlags(), item.getExpire(), item.getCasUnique(), buckets, regions));
        if (old != null) {
            old.free();
        }
        return null;
    }

    @Override
    public final LocalCacheElement remove(Object key) {
        if (!(key instanceof Key)) {
            return null;
        }
        StoredValue val = (StoredValue)this.index.get(key);
        if (val != null) {
            LocalCacheElement el = val.toElement((Key)key);
            this.lockWrite(val);
            val.free();
            this.unlockWrite(val);
            el.setData(val.getData());
            this.index.remove(key);
            return el;
        }
        return null;
    }

    @Override
    public final void putAll(Map<? extends Key, ? extends LocalCacheElement> map) {
        for (Map.Entry<? extends Key, ? extends LocalCacheElement> entry : map.entrySet()) {
            Key key = entry.getKey();
            LocalCacheElement item = entry.getValue();
            this.put(key, item);
        }
    }

    @Override
    public final void clear() {
        this.lockWriteAll();
        this.index.clear();
        for (ByteBufferBlockStore aBlockStorage : this.blockStorage) {
            aBlockStorage.clear();
        }
        this.unlockWriteAll();
    }

    public void lockReadAll() {
        for (ReentrantReadWriteLock reentrantReadWriteLock : this.storageLock) {
            reentrantReadWriteLock.readLock().lock();
        }
    }

    public void unlockReadAll() {
        for (ReentrantReadWriteLock reentrantReadWriteLock : this.storageLock) {
            reentrantReadWriteLock.readLock().unlock();
        }
    }

    public void lockWriteAll() {
        for (ReentrantReadWriteLock reentrantReadWriteLock : this.storageLock) {
            reentrantReadWriteLock.writeLock().lock();
        }
    }

    public void unlockWriteAll() {
        for (ReentrantReadWriteLock reentrantReadWriteLock : this.storageLock) {
            reentrantReadWriteLock.writeLock().unlock();
        }
    }

    public void lockRead(StoredValue value) {
        for (int bucket : value.buckets) {
            this.storageLock[bucket].readLock().lock();
        }
    }

    public void unlockRead(StoredValue value) {
        for (int bucket : value.buckets) {
            this.storageLock[bucket].readLock().unlock();
        }
    }

    public void lockWrite(StoredValue value) {
        for (int bucket : value.buckets) {
            this.storageLock[bucket].writeLock().lock();
        }
    }

    public void unlockWrite(StoredValue value) {
        for (int bucket : value.buckets) {
            this.storageLock[bucket].writeLock().unlock();
        }
    }

    @Override
    public Set<Key> keySet() {
        return this.index.keySet();
    }

    @Override
    public Collection<LocalCacheElement> values() {
        throw new RuntimeException("operation not supporteded");
    }

    @Override
    public Set<Map.Entry<Key, LocalCacheElement>> entrySet() {
        throw new RuntimeException("operation not supporteded");
    }

    final class StoredValue
    implements SizedItem {
        final int flags;
        final int expire;
        final long casUnique;
        final int[] buckets;
        final Region[] regions;

        StoredValue(int flags, int expire, long casUnique, int[] buckets, Region ... regions) {
            this.flags = flags;
            this.expire = expire;
            this.buckets = buckets;
            this.regions = regions;
            this.casUnique = casUnique;
        }

        public final LocalCacheElement toElement(Key key) {
            LocalCacheElement element = new LocalCacheElement(key, this.flags, this.expire, this.casUnique);
            element.setData(this.getData());
            return element;
        }

        public final void free() {
            for (int i = 0; i < this.regions.length; ++i) {
                int bucket = this.buckets[i];
                BlockStorageCacheStorage.this.blockStorage[bucket].free(this.regions[i]);
            }
        }

        public final ChannelBuffer getData() {
            ChannelBuffer[] buffers = new ChannelBuffer[this.regions.length];
            for (int i = 0; i < this.regions.length; ++i) {
                int bucket = this.buckets[i];
                buffers[i] = BlockStorageCacheStorage.this.blockStorage[bucket].get(this.regions[i]);
            }
            return ChannelBuffers.wrappedBuffer((ChannelBuffer[])buffers);
        }

        public final int size() {
            int size = 0;
            for (Region region : this.regions) {
                size += region.size;
            }
            return size;
        }
    }
}

