/*
 * Decompiled with CFR 0.152.
 */
package com.thimbleware.jmemcached.protocol.binary;

import com.thimbleware.jmemcached.Key;
import com.thimbleware.jmemcached.LocalCacheElement;
import com.thimbleware.jmemcached.protocol.CommandMessage;
import com.thimbleware.jmemcached.protocol.Op;
import com.thimbleware.jmemcached.protocol.exceptions.MalformedCommandException;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.frame.FrameDecoder;

@ChannelHandler.Sharable
public class MemcachedBinaryCommandDecoder
extends FrameDecoder {
    public static final Charset USASCII = Charset.forName("US-ASCII");

    protected Object decode(ChannelHandlerContext channelHandlerContext, Channel channel, ChannelBuffer channelBuffer) throws Exception {
        if (channelBuffer.readableBytes() < 24) {
            return null;
        }
        channelBuffer.markReaderIndex();
        ChannelBuffer headerBuffer = ChannelBuffers.buffer((ByteOrder)ByteOrder.BIG_ENDIAN, (int)24);
        channelBuffer.readBytes(headerBuffer);
        short magic = headerBuffer.readUnsignedByte();
        if (magic != 128) {
            headerBuffer.resetReaderIndex();
            throw new MalformedCommandException("binary request payload is invalid, magic byte incorrect");
        }
        short opcode = headerBuffer.readUnsignedByte();
        short keyLength = headerBuffer.readShort();
        short extraLength = headerBuffer.readUnsignedByte();
        short dataType = headerBuffer.readUnsignedByte();
        short reserved = headerBuffer.readShort();
        int totalBodyLength = headerBuffer.readInt();
        int opaque = headerBuffer.readInt();
        long cas = headerBuffer.readLong();
        if (channelBuffer.readableBytes() < totalBodyLength) {
            channelBuffer.resetReaderIndex();
            return null;
        }
        BinaryOp bcmd = BinaryOp.values()[opcode];
        Op cmdType = bcmd.correspondingOp;
        CommandMessage cmdMessage = CommandMessage.command(cmdType);
        cmdMessage.noreply = bcmd.noreply;
        cmdMessage.cas_key = cas;
        cmdMessage.opaque = opaque;
        cmdMessage.addKeyToResponse = bcmd.addKeyToResponse;
        ChannelBuffer extrasBuffer = ChannelBuffers.buffer((ByteOrder)ByteOrder.BIG_ENDIAN, (int)extraLength);
        channelBuffer.readBytes(extrasBuffer);
        if (keyLength != 0) {
            ChannelBuffer keyBuffer = ChannelBuffers.buffer((ByteOrder)ByteOrder.BIG_ENDIAN, (int)keyLength);
            channelBuffer.readBytes(keyBuffer);
            ArrayList<Key> keys = new ArrayList<Key>();
            keys.add(new Key(keyBuffer.copy()));
            cmdMessage.keys = keys;
            if (cmdType == Op.ADD || cmdType == Op.SET || cmdType == Op.REPLACE || cmdType == Op.APPEND || cmdType == Op.PREPEND) {
                int expire = extrasBuffer.capacity() != 0 ? extrasBuffer.readUnsignedShort() : 0;
                short flags = (short)(extrasBuffer.capacity() != 0 ? extrasBuffer.readUnsignedShort() : 0);
                int size = totalBodyLength - keyLength - extraLength;
                cmdMessage.element = new LocalCacheElement(new Key(keyBuffer.slice()), flags, expire != 0 && expire < 2592000 ? LocalCacheElement.Now() + expire : expire, 0L);
                ChannelBuffer data = ChannelBuffers.buffer((int)size);
                channelBuffer.readBytes(data);
                cmdMessage.element.setData(data);
            } else if (cmdType == Op.INCR || cmdType == Op.DECR) {
                long initialValue = extrasBuffer.readUnsignedInt();
                long amount = extrasBuffer.readUnsignedInt();
                long expiration = extrasBuffer.readUnsignedInt();
                cmdMessage.incrAmount = (int)amount;
                cmdMessage.incrExpiry = (int)expiration;
            }
        }
        return cmdMessage;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BinaryOp {
        Get(0, Op.GET, false),
        Set(1, Op.SET, false),
        Add(2, Op.ADD, false),
        Replace(3, Op.REPLACE, false),
        Delete(4, Op.DELETE, false),
        Increment(5, Op.INCR, false),
        Decrement(6, Op.DECR, false),
        Quit(7, Op.QUIT, false),
        Flush(8, Op.FLUSH_ALL, false),
        GetQ(9, Op.GET, false),
        Noop(10, null, false),
        Version(11, Op.VERSION, false),
        GetK(12, Op.GET, false, true),
        GetKQ(13, Op.GET, true, true),
        Append(14, Op.APPEND, false),
        Prepend(15, Op.PREPEND, false),
        Stat(16, Op.STATS, false),
        SetQ(17, Op.SET, true),
        AddQ(18, Op.ADD, true),
        ReplaceQ(19, Op.REPLACE, true),
        DeleteQ(20, Op.DELETE, true),
        IncrementQ(21, Op.INCR, true),
        DecrementQ(22, Op.DECR, true),
        QuitQ(23, Op.QUIT, true),
        FlushQ(24, Op.FLUSH_ALL, true),
        AppendQ(25, Op.APPEND, true),
        PrependQ(26, Op.PREPEND, true);

        public byte code;
        public Op correspondingOp;
        public boolean noreply;
        public boolean addKeyToResponse = false;

        private BinaryOp(int code, Op correspondingOp, boolean noreply) {
            this.code = (byte)code;
            this.correspondingOp = correspondingOp;
            this.noreply = noreply;
        }

        private BinaryOp(int code, Op correspondingOp, boolean noreply, boolean addKeyToResponse) {
            this.code = (byte)code;
            this.correspondingOp = correspondingOp;
            this.noreply = noreply;
            this.addKeyToResponse = addKeyToResponse;
        }

        public static BinaryOp forCommandMessage(CommandMessage msg) {
            for (BinaryOp binaryOp : BinaryOp.values()) {
                if (binaryOp.correspondingOp != msg.op || binaryOp.noreply != msg.noreply || binaryOp.addKeyToResponse != msg.addKeyToResponse) continue;
                return binaryOp;
            }
            return null;
        }
    }
}

