/*
 * Decompiled with CFR 0.152.
 */
package com.thimbleware.jmemcached;

import com.thimbleware.jmemcached.CacheElement;
import com.thimbleware.jmemcached.Key;
import com.thimbleware.jmemcached.util.BufferUtils;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;

public final class LocalCacheElement
implements CacheElement,
Externalizable {
    private int expire;
    private int flags;
    private ChannelBuffer data;
    private Key key;
    private long casUnique = 0L;
    private boolean blocked = false;
    private long blockedUntil;

    public LocalCacheElement() {
    }

    public LocalCacheElement(Key key) {
        this.key = key;
    }

    public LocalCacheElement(Key key, int flags, int expire, long casUnique) {
        this.key = key;
        this.flags = flags;
        this.expire = expire;
        this.casUnique = casUnique;
    }

    public static int Now() {
        return (int)(System.currentTimeMillis() / 1000L);
    }

    public int size() {
        return this.getData().capacity();
    }

    public LocalCacheElement append(LocalCacheElement appendElement) {
        int newLength = this.size() + appendElement.size();
        LocalCacheElement appendedElement = new LocalCacheElement(this.getKey(), this.getFlags(), this.getExpire(), 0L);
        ChannelBuffer appended = ChannelBuffers.buffer((int)newLength);
        ChannelBuffer existing = this.getData();
        ChannelBuffer append = appendElement.getData();
        appended.writeBytes(existing);
        appended.writeBytes(append);
        appended.readerIndex(0);
        existing.readerIndex(0);
        append.readerIndex(0);
        appendedElement.setData(appended);
        appendedElement.setCasUnique(appendedElement.getCasUnique() + 1L);
        return appendedElement;
    }

    public LocalCacheElement prepend(LocalCacheElement prependElement) {
        int newLength = this.size() + prependElement.size();
        LocalCacheElement prependedElement = new LocalCacheElement(this.getKey(), this.getFlags(), this.getExpire(), 0L);
        ChannelBuffer prepended = ChannelBuffers.buffer((int)newLength);
        ChannelBuffer prepend = prependElement.getData();
        ChannelBuffer existing = this.getData();
        prepended.writeBytes(prepend);
        prepended.writeBytes(existing);
        existing.readerIndex(0);
        prepend.readerIndex(0);
        prepended.readerIndex(0);
        prependedElement.setData(prepended);
        prependedElement.setCasUnique(prependedElement.getCasUnique() + 1L);
        return prependedElement;
    }

    public IncrDecrResult add(int mod) {
        int modVal = BufferUtils.atoi(this.getData()) + mod;
        if (modVal < 0) {
            modVal = 0;
        }
        ChannelBuffer newData = BufferUtils.itoa(modVal);
        LocalCacheElement replace = new LocalCacheElement(this.getKey(), this.getFlags(), this.getExpire(), 0L);
        replace.setData(newData);
        replace.setCasUnique(replace.getCasUnique() + 1L);
        return new IncrDecrResult(modVal, replace);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalCacheElement that = (LocalCacheElement)o;
        if (this.blocked != that.blocked) {
            return false;
        }
        if (this.blockedUntil != that.blockedUntil) {
            return false;
        }
        if (this.casUnique != that.casUnique) {
            return false;
        }
        if (this.expire != that.expire) {
            return false;
        }
        if (this.flags != that.flags) {
            return false;
        }
        if (!this.data.equals(that.data)) {
            return false;
        }
        return this.key.equals(that.key);
    }

    public int hashCode() {
        int result = this.expire;
        result = 31 * result + this.flags;
        result = 31 * result + (this.data != null ? this.data.hashCode() : 0);
        result = 31 * result + this.key.hashCode();
        result = 31 * result + (int)(this.casUnique ^ this.casUnique >>> 32);
        result = 31 * result + (this.blocked ? 1 : 0);
        result = 31 * result + (int)(this.blockedUntil ^ this.blockedUntil >>> 32);
        return result;
    }

    public static LocalCacheElement key(Key key) {
        return new LocalCacheElement(key);
    }

    public int getExpire() {
        return this.expire;
    }

    public int getFlags() {
        return this.flags;
    }

    public ChannelBuffer getData() {
        this.data.readerIndex(0);
        return this.data;
    }

    public Key getKey() {
        return this.key;
    }

    public long getCasUnique() {
        return this.casUnique;
    }

    public boolean isBlocked() {
        return this.blocked;
    }

    public long getBlockedUntil() {
        return this.blockedUntil;
    }

    public void setCasUnique(long casUnique) {
        this.casUnique = casUnique;
    }

    public void block(long blockedUntil) {
        this.blocked = true;
        this.blockedUntil = blockedUntil;
    }

    public void setData(ChannelBuffer data) {
        data.readerIndex(0);
        this.data = data;
    }

    public void readExternal(ObjectInput in) throws IOException {
        this.expire = in.readInt();
        this.flags = in.readInt();
        int length = in.readInt();
        byte[] dataArrary = new byte[length];
        for (int readSize = 0; readSize < length; readSize += in.read(dataArrary, readSize, length - readSize)) {
        }
        this.data = ChannelBuffers.wrappedBuffer((byte[])dataArrary);
        byte[] keyBytes = new byte[in.readInt()];
        in.read(keyBytes);
        this.key = new Key(ChannelBuffers.wrappedBuffer((byte[])keyBytes));
        this.casUnique = in.readLong();
        this.blocked = in.readBoolean();
        this.blockedUntil = in.readLong();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.expire);
        out.writeInt(this.flags);
        byte[] dataArray = this.data.copy().array();
        out.writeInt(dataArray.length);
        out.write(dataArray);
        out.write(this.key.bytes.capacity());
        out.write(this.key.bytes.copy().array());
        out.writeLong(this.casUnique);
        out.writeBoolean(this.blocked);
        out.writeLong(this.blockedUntil);
    }

    public static class IncrDecrResult {
        int oldValue;
        LocalCacheElement replace;

        public IncrDecrResult(int oldValue, LocalCacheElement replace) {
            this.oldValue = oldValue;
            this.replace = replace;
        }
    }
}

