/*
 * Decompiled with CFR 0.152.
 */
package protocbridge.frontend;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import protocbridge.ProtocCodeGenerator;
import protocbridge.frontend.PluginFrontend;
import protocbridge.frontend.PluginFrontend$;
import protocbridge.frontend.PosixPluginFrontend;
import scala.Function0;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.sys.process.package$;

public final class PosixPluginFrontend$
implements PluginFrontend {
    public static final PosixPluginFrontend$ MODULE$ = new PosixPluginFrontend$();

    public Tuple2<Path, PosixPluginFrontend.InternalState> prepare(ProtocCodeGenerator plugin) {
        Path tempDirPath = Files.createTempDirectory("protopipe-", new FileAttribute[0]);
        Path inputPipe = this.createPipe(tempDirPath, "input");
        Path outputPipe = this.createPipe(tempDirPath, "output");
        Path sh = this.createShellScript(inputPipe, outputPipe);
        Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            InputStream fsin = Files.newInputStream(inputPipe, new OpenOption[0]);
            byte[] response = PluginFrontend$.MODULE$.runWithInputStream(plugin, fsin);
            fsin.close();
            OutputStream fsout = Files.newOutputStream(outputPipe, new OpenOption[0]);
            fsout.write(response);
            fsout.close();
        }, ExecutionContext.Implicits$.MODULE$.global());
        return new Tuple2((Object)sh, (Object)new PosixPluginFrontend.InternalState(inputPipe, outputPipe, tempDirPath, sh));
    }

    public void cleanup(PosixPluginFrontend.InternalState state) {
        Files.delete(state.inputPipe());
        Files.delete(state.outputPipe());
        Files.delete(state.tempDir());
        Files.delete(state.shellScript());
    }

    /*
     * WARNING - void declaration
     */
    private Path createPipe(Path tempDirPath, String name) {
        void var3_3;
        Path pipeName = tempDirPath.resolve(name);
        package$.MODULE$.stringSeqToProcess((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"mkfifo", "-m", "600", ((Object)pipeName.toAbsolutePath()).toString()}))).$bang$bang();
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private Path createShellScript(Path inputPipe, Path outputPipe) {
        void var3_3;
        Path scriptName = PluginFrontend$.MODULE$.createTempFile("", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(92).append("|#!/usr/bin/env sh\n          |set -e\n          |cat /dev/stdin > \"").append(inputPipe).append("\"\n          |cat \"").append(outputPipe).append("\"\n      ").toString())));
        Files.setPosixFilePermissions(scriptName, (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PosixFilePermission[]{PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.OWNER_READ}))).asJava());
        return var3_3;
    }

    private PosixPluginFrontend$() {
    }
}

