/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractise.halbuilder.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.theoryinpractise.halbuilder.api.ReadableRepresentation;
import com.theoryinpractise.halbuilder.api.RepresentationException;
import com.theoryinpractise.halbuilder.api.RepresentationFactory;
import com.theoryinpractise.halbuilder.api.RepresentationReader;
import com.theoryinpractise.halbuilder.impl.api.Support;
import com.theoryinpractise.halbuilder.impl.representations.MutableRepresentation;
import java.io.Reader;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonRepresentationReader
implements RepresentationReader {
    private RepresentationFactory representationFactory;

    public JsonRepresentationReader(RepresentationFactory representationFactory) {
        this.representationFactory = representationFactory;
    }

    public ReadableRepresentation read(Reader reader) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode rootNode = (JsonNode)mapper.readValue(reader, JsonNode.class);
            MutableRepresentation resource = this.readResource(rootNode);
            return resource.toImmutableResource();
        }
        catch (Exception e) {
            throw new RepresentationException((Throwable)e);
        }
    }

    private MutableRepresentation readResource(JsonNode rootNode) {
        MutableRepresentation resource = new MutableRepresentation(this.representationFactory);
        this.readNamespaces(resource, rootNode);
        this.readLinks(resource, rootNode);
        this.readProperties(resource, rootNode);
        this.readResources(resource, rootNode);
        return resource;
    }

    private void readNamespaces(MutableRepresentation resource, JsonNode rootNode) {
        JsonNode linksNode;
        if (rootNode.has("_links") && (linksNode = rootNode.get("_links")).has("curies")) {
            JsonNode curieNode = linksNode.get("curies");
            if (curieNode.isArray()) {
                Iterator values = curieNode.elements();
                while (values.hasNext()) {
                    JsonNode valueNode = (JsonNode)values.next();
                    resource.withNamespace(valueNode.get("name").asText(), valueNode.get("href").asText());
                }
            } else {
                resource.withNamespace(curieNode.get("name").asText(), curieNode.get("href").asText());
            }
        }
    }

    private void readLinks(MutableRepresentation resource, JsonNode rootNode) {
        if (rootNode.has("_links")) {
            Iterator fields = rootNode.get("_links").fields();
            while (fields.hasNext()) {
                Map.Entry keyNode = (Map.Entry)fields.next();
                if ("curies".equals(keyNode.getKey())) continue;
                if (((JsonNode)keyNode.getValue()).isArray()) {
                    Iterator values = ((JsonNode)keyNode.getValue()).elements();
                    while (values.hasNext()) {
                        JsonNode valueNode = (JsonNode)values.next();
                        this.withJsonLink(resource, keyNode, valueNode);
                    }
                    continue;
                }
                this.withJsonLink(resource, keyNode, (JsonNode)keyNode.getValue());
            }
        }
    }

    private void withJsonLink(MutableRepresentation resource, Map.Entry<String, JsonNode> keyNode, JsonNode valueNode) {
        String rel = keyNode.getKey();
        String href = valueNode.get("href").asText();
        String name = this.optionalNodeValueAsText(valueNode, "name");
        String title = this.optionalNodeValueAsText(valueNode, "title");
        String hreflang = this.optionalNodeValueAsText(valueNode, "hreflang");
        String profile = this.optionalNodeValueAsText(valueNode, "profile");
        resource.withLink(rel, href, name, title, hreflang, profile);
    }

    String optionalNodeValueAsText(JsonNode node, String key) {
        JsonNode value = node.get(key);
        return value != null ? value.asText() : null;
    }

    private void readProperties(MutableRepresentation resource, JsonNode rootNode) {
        Iterator fieldNames = rootNode.fieldNames();
        while (fieldNames.hasNext()) {
            String fieldName = (String)fieldNames.next();
            if (Support.RESERVED_JSON_PROPERTIES.contains(fieldName)) continue;
            JsonNode field = rootNode.get(fieldName);
            resource.withProperty(fieldName, (Object)(field.isNull() ? null : field.asText()));
        }
    }

    private void readResources(MutableRepresentation resource, JsonNode rootNode) {
        if (rootNode.has("_embedded")) {
            Iterator fields = rootNode.get("_embedded").fields();
            while (fields.hasNext()) {
                Map.Entry keyNode = (Map.Entry)fields.next();
                if (((JsonNode)keyNode.getValue()).isArray()) {
                    Iterator values = ((JsonNode)keyNode.getValue()).elements();
                    while (values.hasNext()) {
                        JsonNode valueNode = (JsonNode)values.next();
                        resource.withRepresentation((String)keyNode.getKey(), (ReadableRepresentation)this.readResource(valueNode));
                    }
                    continue;
                }
                resource.withRepresentation((String)keyNode.getKey(), (ReadableRepresentation)this.readResource((JsonNode)keyNode.getValue()));
            }
        }
    }
}

