/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractise.halbuilder.impl.xml;

import com.google.common.base.Strings;
import com.theoryinpractise.halbuilder.api.Link;
import com.theoryinpractise.halbuilder.api.ReadableRepresentation;
import com.theoryinpractise.halbuilder.api.RepresentationException;
import com.theoryinpractise.halbuilder.api.RepresentationFactory;
import com.theoryinpractise.halbuilder.api.RepresentationWriter;
import com.theoryinpractise.halbuilder.impl.api.Support;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.Text;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlRepresentationWriter<T>
implements RepresentationWriter<T> {
    public void write(ReadableRepresentation representation, Set<URI> flags, Writer writer) {
        Element element = this.renderElement("self", representation, false);
        try {
            Format prettyFormat = flags.contains(RepresentationFactory.PRETTY_PRINT) ? Format.getPrettyFormat() : Format.getCompactFormat();
            XMLOutputter outputter = new XMLOutputter(prettyFormat);
            outputter.output(element, writer);
        }
        catch (IOException e) {
            throw new RepresentationException((Throwable)e);
        }
    }

    private Element renderElement(String rel, ReadableRepresentation representation, boolean embedded) {
        Link resourceLink = representation.getResourceLink();
        Element resourceElement = new Element("resource");
        if (resourceLink != null) {
            resourceElement.setAttribute("href", resourceLink.getHref());
        }
        if (!rel.equals("self")) {
            resourceElement.setAttribute("rel", rel);
        }
        if (!embedded) {
            for (Map.Entry entry : representation.getNamespaces().entrySet()) {
                resourceElement.addNamespaceDeclaration(Namespace.getNamespace((String)((String)entry.getKey()), (String)((String)entry.getValue())));
            }
            if (representation.hasNullProperties()) {
                resourceElement.addNamespaceDeclaration(Support.XSI_NAMESPACE);
            }
        }
        List links = representation.getLinks();
        for (Link link : links) {
            Element linkElement = new Element("link");
            if (link.getRel().equals("self")) continue;
            linkElement.setAttribute("rel", link.getRel());
            linkElement.setAttribute("href", link.getHref());
            if (!Strings.isNullOrEmpty((String)link.getName())) {
                linkElement.setAttribute("name", link.getName());
            }
            if (!Strings.isNullOrEmpty((String)link.getTitle())) {
                linkElement.setAttribute("title", link.getTitle());
            }
            if (!Strings.isNullOrEmpty((String)link.getHreflang())) {
                linkElement.setAttribute("hreflang", link.getHreflang());
            }
            if (!Strings.isNullOrEmpty((String)link.getProfile())) {
                linkElement.setAttribute("profile", link.getProfile());
            }
            if (link.hasTemplate()) {
                linkElement.setAttribute("templated", "true");
            }
            resourceElement.addContent((Content)linkElement);
        }
        for (Map.Entry entry : representation.getProperties().entrySet()) {
            Element propertyElement = new Element((String)entry.getKey());
            if (entry.getValue() != null) {
                propertyElement.setContent((Content)new Text(entry.getValue().toString()));
            } else {
                propertyElement.setAttribute("nil", "true", Support.XSI_NAMESPACE);
            }
            resourceElement.addContent((Content)propertyElement);
        }
        for (Map.Entry entry : representation.getResources()) {
            Element subResourceElement = this.renderElement((String)entry.getKey(), (ReadableRepresentation)entry.getValue(), true);
            resourceElement.addContent((Content)subResourceElement);
        }
        return resourceElement;
    }
}

