/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractise.halbuilder.impl.xml;

import com.theoryinpractise.halbuilder.api.ReadableRepresentation;
import com.theoryinpractise.halbuilder.api.Representation;
import com.theoryinpractise.halbuilder.api.RepresentationException;
import com.theoryinpractise.halbuilder.api.RepresentationFactory;
import com.theoryinpractise.halbuilder.api.RepresentationReader;
import com.theoryinpractise.halbuilder.impl.api.Support;
import com.theoryinpractise.halbuilder.impl.representations.MutableRepresentation;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;

public class XmlRepresentationReader
implements RepresentationReader {
    private RepresentationFactory representationFactory;

    public XmlRepresentationReader(RepresentationFactory representationFactory) {
        this.representationFactory = representationFactory;
    }

    public ReadableRepresentation read(Reader reader) {
        try {
            Document d = new SAXBuilder().build(reader);
            Element root = d.getRootElement();
            return this.readRepresentation(root).toImmutableResource();
        }
        catch (JDOMException e) {
            throw new RepresentationException((Throwable)e);
        }
        catch (IOException e) {
            throw new RepresentationException((Throwable)e);
        }
    }

    private MutableRepresentation readRepresentation(Element root) {
        String href = root.getAttributeValue("href");
        MutableRepresentation resource = new MutableRepresentation(this.representationFactory, href);
        this.readNamespaces(resource, root);
        this.readLinks(resource, root);
        this.readProperties(resource, root);
        this.readResources(resource, root);
        return resource;
    }

    private void readNamespaces(Representation resource, Element element) {
        List namespaces = element.getAdditionalNamespaces();
        for (Namespace ns : namespaces) {
            resource.withNamespace(ns.getPrefix(), ns.getURI());
        }
    }

    private void readLinks(Representation resource, Element element) {
        List links = element.getChildren("link");
        for (Element link : links) {
            String rel = link.getAttributeValue("rel");
            String href = link.getAttributeValue("href");
            String name = link.getAttributeValue("name");
            String title = link.getAttributeValue("title");
            String hreflang = link.getAttributeValue("hreflang");
            String profile = link.getAttributeValue("profile");
            resource.withLink(rel, href, name, title, hreflang, profile);
        }
    }

    private void readProperties(Representation resource, Element element) {
        List properties = element.getChildren();
        for (Element property : properties) {
            if (property.getName().matches("(link|resource)")) continue;
            if (property.getAttribute("nil", Support.XSI_NAMESPACE) != null) {
                resource.withProperty(property.getName(), null);
                continue;
            }
            resource.withProperty(property.getName(), (Object)property.getValue());
        }
    }

    private void readResources(Representation halResource, Element element) {
        List resources = element.getChildren("resource");
        for (Element resource : resources) {
            String rel = resource.getAttributeValue("rel");
            MutableRepresentation subResource = this.readRepresentation(resource);
            halResource.withRepresentation(rel, (ReadableRepresentation)subResource);
        }
    }
}

