/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractise.halbuilder.impl.representations;

import com.theoryinpractise.halbuilder.api.Link;
import com.theoryinpractise.halbuilder.api.ReadableRepresentation;
import com.theoryinpractise.halbuilder.api.Representable;
import com.theoryinpractise.halbuilder.api.Representation;
import com.theoryinpractise.halbuilder.api.RepresentationException;
import com.theoryinpractise.halbuilder.api.RepresentationFactory;
import com.theoryinpractise.halbuilder.impl.api.Support;
import com.theoryinpractise.halbuilder.impl.representations.BaseRepresentation;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.net.URI;

public class MutableRepresentation
extends BaseRepresentation
implements Representation {
    public MutableRepresentation(RepresentationFactory representationFactory, String href) {
        super(representationFactory);
        if (href != null) {
            this.links.add(new Link(representationFactory, "self", href));
        }
    }

    public MutableRepresentation(RepresentationFactory representationFactory) {
        super(representationFactory);
    }

    public MutableRepresentation withLink(String rel, String href) {
        this.withLink(rel, href, null, null, null, null);
        return this;
    }

    public MutableRepresentation withLink(String rel, String href, String name, String title, String hreflang, String profile) {
        Support.checkRelType(rel);
        this.links.add(new Link(this.representationFactory, rel, href, name, title, hreflang, profile));
        return this;
    }

    public MutableRepresentation withLink(String rel, URI uri) {
        return this.withLink(rel, uri.toASCIIString());
    }

    public Representation withProperty(String name, Object value) {
        if (this.properties.containsKey(name)) {
            throw new RepresentationException(String.format("Duplicate property '%s' found for resource", name));
        }
        if (null == value) {
            this.hasNullProperties = true;
        }
        this.properties.put(name, value);
        return this;
    }

    public Representation withBean(Object value) {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(value.getClass());
            for (PropertyDescriptor pd : beanInfo.getPropertyDescriptors()) {
                if ("class".equals(pd.getName())) continue;
                this.withProperty(pd.getName(), pd.getReadMethod().invoke(value, new Object[0]));
            }
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public Representation withFields(Object value) {
        try {
            for (Field field : value.getClass().getDeclaredFields()) {
                if (!Modifier.isPublic(field.getModifiers())) continue;
                this.withProperty(field.getName(), field.get(value));
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public Representation withRepresentable(Representable representable) {
        representable.representResource((Representation)this);
        return this;
    }

    public Representation withFieldBasedRepresentation(String rel, String href, Object o) {
        return this.withRepresentation(rel, (ReadableRepresentation)this.representationFactory.newRepresentation(href).withFields(o));
    }

    public Representation withBeanBasedRepresentation(String rel, String href, Object o) {
        return this.withRepresentation(rel, (ReadableRepresentation)this.representationFactory.newRepresentation(href).withBean(o));
    }

    public Representation withNamespace(String namespace, String href) {
        if (this.namespaces.containsKey(namespace)) {
            throw new RepresentationException(String.format("Duplicate namespace '%s' found for resource", namespace));
        }
        this.namespaces.put(namespace, href);
        return this;
    }

    public MutableRepresentation withRepresentation(String rel, ReadableRepresentation resource) {
        Support.checkRelType(rel);
        this.resources.put((Object)rel, (Object)resource);
        if (resource.hasNullProperties()) {
            this.hasNullProperties = true;
        }
        return this;
    }
}

