/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractise.halbuilder.impl.representations;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.theoryinpractise.halbuilder.api.Contract;
import com.theoryinpractise.halbuilder.api.Link;
import com.theoryinpractise.halbuilder.api.ReadableRepresentation;
import com.theoryinpractise.halbuilder.api.RepresentationException;
import com.theoryinpractise.halbuilder.api.RepresentationFactory;
import com.theoryinpractise.halbuilder.api.RepresentationWriter;
import com.theoryinpractise.halbuilder.impl.api.Support;
import com.theoryinpractise.halbuilder.impl.bytecode.InterfaceContract;
import com.theoryinpractise.halbuilder.impl.bytecode.InterfaceRenderer;
import com.theoryinpractise.halbuilder.impl.representations.ImmutableRepresentation;
import com.theoryinpractise.halbuilder.impl.representations.LinkPredicate;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseRepresentation
implements ReadableRepresentation {
    public static final Ordering<Link> RELATABLE_ORDERING = Ordering.from((Comparator)new Comparator<Link>(){

        @Override
        public int compare(Link l1, Link l2) {
            if (l1.getRel().contains("self")) {
                return -1;
            }
            if (l2.getRel().contains("self")) {
                return 1;
            }
            return l1.getRel().compareTo(l2.getRel());
        }
    });
    protected Map<String, String> namespaces = Maps.newTreeMap((Comparator)Ordering.usingToString());
    protected List<Link> links = Lists.newArrayList();
    protected Map<String, Object> properties = Maps.newTreeMap((Comparator)Ordering.usingToString());
    protected Multimap<String, ReadableRepresentation> resources = ArrayListMultimap.create();
    protected RepresentationFactory representationFactory;
    protected boolean hasNullProperties = false;

    protected BaseRepresentation(RepresentationFactory representationFactory) {
        this.representationFactory = representationFactory;
    }

    public Link getResourceLink() {
        return (Link)Iterables.find(this.getLinks(), (Predicate)LinkPredicate.newLinkPredicate("self"), null);
    }

    public Map<String, String> getNamespaces() {
        return ImmutableMap.copyOf(this.namespaces);
    }

    public List<Link> getCanonicalLinks() {
        return ImmutableList.copyOf(this.getNaturalLinks());
    }

    public Link getLinkByRel(String rel) {
        return (Link)Iterables.getFirst(this.getLinksByRel(rel), null);
    }

    public List<Link> getLinksByRel(String rel) {
        Support.checkRelType(rel);
        String curiedRel = this.currieHref(rel);
        ImmutableList.Builder linkBuilder = ImmutableList.builder();
        linkBuilder.addAll(this.getLinksByRel(this, curiedRel));
        for (ReadableRepresentation resource : this.resources.values()) {
            linkBuilder.addAll(this.getLinksByRel(resource, curiedRel));
        }
        return linkBuilder.build();
    }

    public List<? extends ReadableRepresentation> getResourcesByRel(String rel) {
        Support.checkRelType(rel);
        return ImmutableList.copyOf((Collection)this.resources.get((Object)rel));
    }

    public Object getValue(String name) {
        if (this.properties.containsKey(name)) {
            return this.properties.get(name);
        }
        throw new RepresentationException("Resource does not contain " + name);
    }

    public Object getValue(String name, Object defaultValue) {
        try {
            return this.getValue(name);
        }
        catch (RepresentationException e) {
            return defaultValue;
        }
    }

    private List<Link> getLinksByRel(ReadableRepresentation representation, final String rel) {
        Support.checkRelType(rel);
        return ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)representation.getCanonicalLinks(), (Predicate)new Predicate<Link>(){

            public boolean apply(@Nullable Link relatable) {
                return rel.equals(relatable.getRel()) || Iterables.contains((Iterable)Support.WHITESPACE_SPLITTER.split((CharSequence)relatable.getRel()), (Object)rel);
            }
        }));
    }

    public List<Link> getLinks() {
        if (this.representationFactory.getFlags().contains(RepresentationFactory.COALESCE_LINKS)) {
            return this.getCollatedLinks();
        }
        return this.getNaturalLinks();
    }

    private List<Link> getNaturalLinks() {
        return FluentIterable.from(this.links).transform((Function)new Function<Link, Link>(){

            @Nullable
            public Link apply(@Nullable Link link) {
                return new Link(BaseRepresentation.this.representationFactory, BaseRepresentation.this.currieHref(link.getRel()), BaseRepresentation.this.currieHref(link.getHref()), link.getName(), link.getTitle(), link.getHreflang(), link.getProfile());
            }
        }).toSortedImmutableList(RELATABLE_ORDERING);
    }

    private List<Link> getCollatedLinks() {
        ArrayList collatedLinks = Lists.newArrayList();
        HashBasedTable linkTable = HashBasedTable.create();
        for (Link link : this.links) {
            linkTable.put((Object)link.getHref(), (Object)link.getRel(), (Object)link);
        }
        for (String href : linkTable.rowKeySet()) {
            Set relTypes = linkTable.row((Object)href).keySet();
            Collection hrefLinks = linkTable.row((Object)href).values();
            String rels = (String)this.mkSortableJoinerForIterable(" ", relTypes).apply((Object)new Function<String, String>(){

                public String apply(@Nullable String relType) {
                    return BaseRepresentation.this.currieHref(relType);
                }
            });
            Function nameFunc = this.mkSortableJoinerForIterable(", ", hrefLinks);
            String titles = (String)nameFunc.apply((Object)new Function<Link, String>(){

                public String apply(@Nullable Link link) {
                    return link.getTitle();
                }
            });
            String names = (String)nameFunc.apply((Object)new Function<Link, String>(){

                public String apply(@Nullable Link link) {
                    return link.getName();
                }
            });
            String hreflangs = (String)nameFunc.apply((Object)new Function<Link, String>(){

                public String apply(@Nullable Link link) {
                    return link.getHreflang();
                }
            });
            String profile = (String)nameFunc.apply((Object)new Function<Link, String>(){

                public String apply(@Nullable Link link) {
                    return link.getProfile();
                }
            });
            String curiedHref = this.currieHref(href);
            collatedLinks.add(new Link(this.representationFactory, rels, curiedHref, Strings.emptyToNull((String)names), Strings.emptyToNull((String)titles), Strings.emptyToNull((String)hreflangs), Strings.emptyToNull((String)profile)));
        }
        return RELATABLE_ORDERING.sortedCopy((Iterable)collatedLinks);
    }

    private <T> Function<Function<T, String>, String> mkSortableJoinerForIterable(final String join, final Iterable<T> ts) {
        return new Function<Function<T, String>, String>(){

            @Nullable
            public String apply(Function<T, String> f) {
                return Joiner.on((String)join).skipNulls().join((Iterable)Ordering.usingToString().nullsFirst().sortedCopy((Iterable)Sets.newHashSet((Iterable)Iterables.transform((Iterable)ts, f))));
            }
        };
    }

    private String currieHref(String href) {
        for (Map.Entry<String, String> entry : this.namespaces.entrySet()) {
            if (!href.startsWith(entry.getValue())) continue;
            return href.replace(entry.getValue(), entry.getKey() + ":");
        }
        return href;
    }

    public Map<String, Object> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public Collection<Map.Entry<String, ReadableRepresentation>> getResources() {
        return ImmutableMultimap.copyOf(this.resources).entries();
    }

    public Map<String, Collection<ReadableRepresentation>> getResourceMap() {
        return ImmutableMap.copyOf((Map)this.resources.asMap());
    }

    protected void validateNamespaces(ReadableRepresentation representation) {
        for (Link link : representation.getCanonicalLinks()) {
            this.validateNamespaces(link.getRel());
        }
        for (Map.Entry aResource : representation.getResources()) {
            this.validateNamespaces((String)aResource.getKey());
            this.validateNamespaces((ReadableRepresentation)aResource.getValue());
        }
    }

    private void validateNamespaces(String sourceRel) {
        for (String rel : Support.WHITESPACE_SPLITTER.split((CharSequence)sourceRel)) {
            if (rel.contains("://") || !rel.contains(":")) continue;
            String[] relPart = rel.split(":");
            if (this.namespaces.keySet().contains(relPart[0])) continue;
            throw new RepresentationException(String.format("Undeclared namespace in rel %s for resource", rel));
        }
    }

    public boolean isSatisfiedBy(Contract contract) {
        return contract.isSatisfiedBy((ReadableRepresentation)this);
    }

    public boolean hasNullProperties() {
        return this.hasNullProperties;
    }

    public ImmutableRepresentation toImmutableResource() {
        return new ImmutableRepresentation(this.representationFactory, this.getNamespaces(), this.getCanonicalLinks(), this.getProperties(), this.getResources(), this.hasNullProperties);
    }

    public <T> T toClass(Class<T> anInterface) {
        if (InterfaceContract.newInterfaceContract(anInterface).isSatisfiedBy(this)) {
            return InterfaceRenderer.newInterfaceRenderer(anInterface).render(this);
        }
        throw new RepresentationException("Unable to write representation to " + anInterface.getName());
    }

    public String toString(String contentType) {
        return this.toString(contentType, Collections.<URI>emptySet());
    }

    public String toString(String contentType, Set<URI> flags) {
        StringWriter sw = new StringWriter();
        this.toString(contentType, flags, sw);
        return sw.toString();
    }

    public void toString(String contentType, Writer writer) {
        this.toString(contentType, Collections.<URI>emptySet(), writer);
    }

    public void toString(String contentType, Set<URI> flags, Writer writer) {
        this.validateNamespaces(this);
        RepresentationWriter representationWriter = this.representationFactory.lookupRenderer(contentType);
        ImmutableSet.Builder uriBuilder = ImmutableSet.builder().addAll((Iterable)this.representationFactory.getFlags());
        if (flags != null) {
            uriBuilder.addAll(flags);
        }
        representationWriter.write((ReadableRepresentation)this, (Set)uriBuilder.build(), writer);
    }

    public int hashCode() {
        int h = this.namespaces.hashCode();
        h += this.links.hashCode();
        h += this.properties.hashCode();
        return h += this.resources.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BaseRepresentation)) {
            return false;
        }
        BaseRepresentation that = (BaseRepresentation)obj;
        boolean e = this.namespaces.equals(that.namespaces);
        e &= this.links.equals(that.links);
        e &= this.properties.equals(that.properties);
        return e &= this.resources.equals(that.resources);
    }

    public String toString() {
        Link href = this.getLinkByRel("self");
        if (href != null) {
            return "<Representation: " + href.getHref() + ">";
        }
        return "<Representation: @" + Integer.toHexString(this.hashCode()) + ">";
    }
}

