/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractise.halbuilder.impl.bytecode;

import com.google.common.base.Preconditions;
import com.theoryinpractise.halbuilder.api.ReadableRepresentation;
import com.theoryinpractise.halbuilder.api.RepresentationException;
import com.theoryinpractise.halbuilder.impl.bytecode.InterfaceContract;
import com.theoryinpractise.halbuilder.impl.bytecode.InterfaceSupport;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterfaceRenderer<T> {
    private Class<T> anInterface;

    public static <I> InterfaceRenderer<I> newInterfaceRenderer(Class<I> anInterface) {
        return new InterfaceRenderer<I>(anInterface);
    }

    private InterfaceRenderer(Class<T> anInterface) {
        Preconditions.checkArgument((boolean)anInterface.isInterface(), (Object)"Provided class MUST be an interface.");
        this.anInterface = anInterface;
    }

    public T render(final ReadableRepresentation representation) {
        if (representation.isSatisfiedBy(InterfaceContract.newInterfaceContract(this.anInterface))) {
            Object proxy = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{this.anInterface}, new InvocationHandler(){

                public Object invoke(Object o, Method method, Object[] objects) throws Throwable {
                    String propertyName = InterfaceSupport.derivePropertyNameFromMethod(method);
                    Object propertyValue = representation.getProperties().get(propertyName);
                    Class<?> returnType = method.getReturnType();
                    Object returnValue = propertyValue != null ? returnType.getConstructor(propertyValue.getClass()).newInstance(propertyValue) : null;
                    return returnValue;
                }
            });
            return (T)proxy;
        }
        throw new RepresentationException("Unable to write representation to " + this.anInterface.getName());
    }
}

