/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractise.halbuilder.impl.bytecode;

import com.google.common.base.Preconditions;
import com.theoryinpractise.halbuilder.api.Contract;
import com.theoryinpractise.halbuilder.api.ReadableRepresentation;
import com.theoryinpractise.halbuilder.impl.bytecode.InterfaceSupport;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterfaceContract<T>
implements Contract {
    private Class<T> anInterface;

    public static <T> InterfaceContract<T> newInterfaceContract(Class<T> anInterface) {
        return new InterfaceContract<T>(anInterface);
    }

    private InterfaceContract(Class<T> anInterface) {
        Preconditions.checkArgument((boolean)anInterface.isInterface(), (Object)"Contract class MUST be an interface.");
        this.anInterface = anInterface;
    }

    public boolean isSatisfiedBy(ReadableRepresentation representation) {
        for (Method method : this.anInterface.getDeclaredMethods()) {
            String propertyName = InterfaceSupport.derivePropertyNameFromMethod(method);
            if ("class".equals(propertyName) || representation.getProperties().containsKey(propertyName)) continue;
            return false;
        }
        return true;
    }
}

