/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractise.halbuilder;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.theoryinpractise.halbuilder.api.Link;
import com.theoryinpractise.halbuilder.api.ReadableRepresentation;
import com.theoryinpractise.halbuilder.api.Representation;
import com.theoryinpractise.halbuilder.api.RepresentationException;
import com.theoryinpractise.halbuilder.api.RepresentationFactory;
import com.theoryinpractise.halbuilder.api.RepresentationReader;
import com.theoryinpractise.halbuilder.api.RepresentationWriter;
import com.theoryinpractise.halbuilder.impl.ContentType;
import com.theoryinpractise.halbuilder.impl.json.JsonRepresentationReader;
import com.theoryinpractise.halbuilder.impl.json.JsonRepresentationWriter;
import com.theoryinpractise.halbuilder.impl.representations.MutableRepresentation;
import com.theoryinpractise.halbuilder.impl.xml.XmlRepresentationReader;
import com.theoryinpractise.halbuilder.impl.xml.XmlRepresentationWriter;
import java.io.BufferedReader;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRepresentationFactory
extends RepresentationFactory {
    private Map<ContentType, Class<? extends RepresentationWriter>> contentRenderers = Maps.newHashMap();
    private Map<ContentType, Class<? extends RepresentationReader>> representationReaders = Maps.newHashMap();
    private TreeMap<String, String> namespaces = Maps.newTreeMap((Comparator)Ordering.usingToString());
    private List<Link> links = Lists.newArrayList();
    private Set<URI> flags = Sets.newHashSet();

    public DefaultRepresentationFactory() {
        this.contentRenderers.put(new ContentType("application/hal+xml"), XmlRepresentationWriter.class);
        this.contentRenderers.put(new ContentType("application/hal+json"), JsonRepresentationWriter.class);
        this.representationReaders.put(new ContentType("application/hal+xml"), XmlRepresentationReader.class);
        this.representationReaders.put(new ContentType("application/hal+json"), JsonRepresentationReader.class);
    }

    public DefaultRepresentationFactory withRenderer(String contentType, Class<? extends RepresentationWriter<String>> rendererClass) {
        this.contentRenderers.put(new ContentType(contentType), rendererClass);
        return this;
    }

    public DefaultRepresentationFactory withReader(String contentType, Class<? extends RepresentationReader> readerClass) {
        this.representationReaders.put(new ContentType(contentType), readerClass);
        return this;
    }

    public DefaultRepresentationFactory withNamespace(String namespace, String href) {
        if (this.namespaces.containsKey(namespace)) {
            throw new RepresentationException(String.format("Duplicate namespace '%s' found for representation factory", namespace));
        }
        this.namespaces.put(namespace, href);
        return this;
    }

    public DefaultRepresentationFactory withLink(String rel, String href) {
        this.links.add(new Link((RepresentationFactory)this, rel, href));
        return this;
    }

    public RepresentationFactory withFlag(URI flag) {
        this.flags.add(flag);
        return this;
    }

    public Representation newRepresentation(URI uri) {
        return this.newRepresentation(uri.toString());
    }

    public Representation newRepresentation() {
        return this.newRepresentation((String)null);
    }

    public Representation newRepresentation(String href) {
        MutableRepresentation representation = new MutableRepresentation(this, href);
        for (Map.Entry<String, String> entry : this.namespaces.entrySet()) {
            representation.withNamespace(entry.getKey(), entry.getValue());
        }
        for (Link link : this.links) {
            representation.withLink(link.getRel(), link.getHref(), link.getName(), link.getTitle(), link.getHreflang(), link.getProfile());
        }
        return representation;
    }

    public ReadableRepresentation readRepresentation(Reader reader) {
        try {
            Class<? extends RepresentationReader> readerClass;
            BufferedReader bufferedReader = new BufferedReader(reader);
            ((Reader)bufferedReader).mark(1);
            char firstChar = (char)((Reader)bufferedReader).read();
            ((Reader)bufferedReader).reset();
            switch (firstChar) {
                case '{': {
                    readerClass = this.representationReaders.get(new ContentType("application/hal+json"));
                    break;
                }
                case '<': {
                    readerClass = this.representationReaders.get(new ContentType("application/hal+xml"));
                    break;
                }
                default: {
                    throw new RepresentationException("unrecognized initial character in stream: " + firstChar);
                }
            }
            Constructor<? extends RepresentationReader> readerConstructor = readerClass.getConstructor(RepresentationFactory.class);
            return readerConstructor.newInstance(new Object[]{this}).read((Reader)bufferedReader);
        }
        catch (Exception e) {
            throw new RepresentationException((Throwable)e);
        }
    }

    public RepresentationWriter<String> lookupRenderer(String contentType) {
        for (Map.Entry<ContentType, Class<? extends RepresentationWriter>> entry : this.contentRenderers.entrySet()) {
            if (!entry.getKey().matches(contentType)) continue;
            try {
                return entry.getValue().newInstance();
            }
            catch (InstantiationException e) {
                throw new RepresentationException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new RepresentationException((Throwable)e);
            }
        }
        throw new IllegalArgumentException("Unsupported contentType: " + contentType);
    }

    public Set<URI> getFlags() {
        return ImmutableSet.copyOf(this.flags);
    }
}

