/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractise.halbuilder.api;

import com.theoryinpractise.halbuilder.api.ReadableRepresentation;
import com.theoryinpractise.halbuilder.api.Representation;
import com.theoryinpractise.halbuilder.api.RepresentationException;
import com.theoryinpractise.halbuilder.api.RepresentationWriter;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RepresentationFactory {
    public static final String HAL_XML = "application/hal+xml";
    public static final String HAL_JSON = "application/hal+json";
    public static final URI PRETTY_PRINT = RepresentationFactory.makeUri("urn:halbuilder:prettyprint");
    public static final URI COALESCE_LINKS = RepresentationFactory.makeUri("urn:halbuilder:coalescelinks");

    protected static URI makeUri(String uri) {
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new RepresentationException(e);
        }
    }

    public abstract RepresentationFactory withNamespace(String var1, String var2);

    public abstract RepresentationFactory withLink(String var1, String var2);

    public abstract RepresentationFactory withFlag(URI var1);

    public abstract Representation newRepresentation(URI var1);

    public abstract Representation newRepresentation();

    public abstract Representation newRepresentation(String var1);

    public abstract ReadableRepresentation readRepresentation(Reader var1);

    public abstract RepresentationWriter<String> lookupRenderer(String var1);

    public abstract Set<URI> getFlags();
}

