/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractise.halbuilder.api;

import com.theoryinpractise.halbuilder.api.RepresentationFactory;
import java.util.regex.Pattern;

public class Link {
    private static final Pattern URI_TEMPLATE_PATTERN = Pattern.compile("\\{.+\\}");
    private RepresentationFactory representationFactory;
    private String href;
    private String rel;
    private String name;
    private String title;
    private String hreflang;
    private String profile;
    private boolean hasTemplate = false;

    public Link(RepresentationFactory representationFactory, String rel, String href) {
        this.representationFactory = representationFactory;
        this.href = href;
        this.rel = rel;
        if (this.hasTemplate(href)) {
            this.hasTemplate = true;
        }
    }

    public Link(RepresentationFactory representationFactory, String rel, String href, String name, String title, String hreflang, String profile) {
        this(representationFactory, rel, href);
        this.name = name;
        this.title = title;
        this.hreflang = hreflang;
        this.profile = profile;
    }

    public String getHref() {
        return this.href;
    }

    public String getRel() {
        return this.rel;
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        return this.title;
    }

    public String getHreflang() {
        return this.hreflang;
    }

    public String getProfile() {
        return this.profile;
    }

    public boolean hasTemplate() {
        return this.hasTemplate;
    }

    private boolean hasTemplate(String href) {
        if (href == null) {
            return false;
        }
        return URI_TEMPLATE_PATTERN.matcher(href).find();
    }

    public int hashCode() {
        int h = this.href.hashCode();
        h += this.rel.hashCode();
        if (this.name != null) {
            h += this.name.hashCode();
        }
        if (this.title != null) {
            h += this.title.hashCode();
        }
        if (this.profile != null) {
            h += this.profile.hashCode();
        }
        if (this.hreflang != null) {
            h += this.hreflang.hashCode();
        }
        return h;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Link)) {
            return false;
        }
        Link that = (Link)obj;
        boolean e = this.href.equals(that.href);
        e &= this.rel.equals(that.rel);
        if (!this.emptyOrNull(this.name)) {
            e &= this.name.equals(that.name);
        }
        if (!this.emptyOrNull(this.title)) {
            e &= this.title.equals(that.title);
        }
        if (!this.emptyOrNull(this.profile)) {
            e &= this.profile.equals(that.profile);
        }
        if (!this.emptyOrNull(this.hreflang)) {
            e &= this.hreflang.equals(that.hreflang);
        }
        return e;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<link rel=\"").append(this.rel).append("\" href=\"").append(this.href).append("\"");
        if (!this.emptyOrNull(this.name)) {
            sb.append(" name=\"").append(this.name).append("\"");
        }
        if (!this.emptyOrNull(this.title)) {
            sb.append(" title=\"").append(this.title).append("\"");
        }
        if (!this.emptyOrNull(this.profile)) {
            sb.append(" profile=\"").append(this.profile).append("\"");
        }
        if (!this.emptyOrNull(this.hreflang)) {
            sb.append(" hreflang=\"").append(this.hreflang).append("\"");
        }
        sb.append("/>");
        return sb.toString();
    }

    private boolean emptyOrNull(String s) {
        return s == null || "".equals(s.trim());
    }
}

