/*
 * Decompiled with CFR 0.152.
 */
package theoremreach.com.theoremreach.utils;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.os.Build;
import android.telephony.TelephonyManager;

public class ConnectionType {
    public static String getTypeString(Context ctx) {
        try {
            int networkType;
            TelephonyManager telephonyManager = (TelephonyManager)ctx.getSystemService("phone");
            ConnectivityManager cm = (ConnectivityManager)ctx.getSystemService("connectivity");
            if (cm == null || telephonyManager == null) {
                return "unknown";
            }
            boolean isConnected = false;
            boolean isCellular = false;
            boolean isWifi = false;
            if (Build.VERSION.SDK_INT >= 23) {
                NetworkCapabilities netCapabilities = cm.getNetworkCapabilities(cm.getActiveNetwork());
                if (netCapabilities == null) {
                    return "unknown";
                }
                isConnected = true;
                isCellular = netCapabilities.hasTransport(0);
                isWifi = netCapabilities.hasTransport(1);
                networkType = telephonyManager.getNetworkType();
            } else {
                NetworkInfo info = cm.getActiveNetworkInfo();
                if (info == null) {
                    return "unknown";
                }
                isConnected = info.isConnected();
                isCellular = info.getType() == 0;
                isWifi = info.getType() == 1;
                networkType = info.getSubtype();
            }
            if (!isConnected || !isWifi && !isCellular) {
                return "unknown";
            }
            if (isWifi) {
                return "WIFI";
            }
            if (isCellular) {
                switch (networkType) {
                    case 1: 
                    case 2: 
                    case 4: 
                    case 7: 
                    case 11: {
                        return "2G";
                    }
                    case 3: 
                    case 5: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 12: 
                    case 14: 
                    case 15: {
                        return "3G";
                    }
                    case 13: {
                        return "4G";
                    }
                    case 20: {
                        return "5G";
                    }
                }
                return "unknown";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "unknown";
    }
}

