/*
 * Decompiled with CFR 0.152.
 */
package theoremreach.com.theoremreach;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.graphics.drawable.Drawable;
import android.os.AsyncTask;
import android.os.Build;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import androidx.preference.PreferenceManager;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.unity3d.player.UnityPlayer;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.security.InvalidParameterException;
import java.util.Timer;
import java.util.TimerTask;
import theoremreach.com.theoremreach.AppuserConnection;
import theoremreach.com.theoremreach.MomentSurveyActivity;
import theoremreach.com.theoremreach.RewardCenterActivity;
import theoremreach.com.theoremreach.TheoremReachMomentListener;
import theoremreach.com.theoremreach.TheoremReachRewardListener;
import theoremreach.com.theoremreach.TheoremReachSurveyAvailableListener;
import theoremreach.com.theoremreach.TheoremReachSurveyListener;
import theoremreach.com.theoremreach.utils.AdvertisingIdClientInfo;
import theoremreach.com.theoremreach.utils.ConnectionType;

public class TheoremReach {
    private static TheoremReach _instance;
    private TheoremReachRewardListener _rewardListener;
    private TheoremReachSurveyListener _surveyListener;
    private TheoremReachSurveyAvailableListener _surveyAvailableListener;
    private TheoremReachMomentListener _momentListener;
    private String _apiKey = "";
    private String _userId = "";
    private String _surveyUrl = "";
    private WeakReference<Activity> _parentContext;
    private String _googleAdvertiserId;
    private String _unityObjectName;
    private String _carrier;
    private String _osVersion;
    private String _appDevice;
    private String _connectionType;
    private String _appuserId = "";
    private int _awardedContent = 0;
    private boolean surveyAvailable = false;
    private int momentSurveyLength = 999999;
    private String momentEntryURL = "";
    private boolean isProfiled = false;
    private int unityEarnedContent = 0;
    public boolean rewardCenterOpen = false;
    public boolean momentSurveyOpen = false;
    public boolean resetProfiler = false;
    private boolean initialized = false;
    private String navigationBarColor = "#211548";
    private String navigationBarTextColor = "#FFFFFF";
    private String navigationBarText = "";
    private String overrideCloseButtonURL;
    private String overrideRefreshButtonURL;
    private Drawable overrideCloseButton;
    private Drawable overrideRefreshButton;
    private int momentsPollingFrequency = -1;
    private boolean unity = false;
    private String placementId = "";
    private boolean momentsEnabled = false;
    private boolean momentsTitleBarEnabled = false;
    private boolean fetchingMomentSurvey = false;
    private boolean momentSurveyAvailable = false;
    private String rewardIds = "";
    public static String SDK_VERSION;
    private boolean fetchingAppuserId = false;
    private Timer refreshAvailableSurvey;
    private TRTimer refreshAvailableSurveyTask;
    private final String TAG = "TheoremReach";

    public static TheoremReach getInstance() {
        if (_instance == null) {
            _instance = new TheoremReach();
        }
        return _instance;
    }

    public static TheoremReach initWithApiKeyAndUserIdAndActivityContext(String apiKey, String userId, Activity parentActivity) {
        TheoremReach.getInstance().setup(apiKey, userId, parentActivity);
        TheoremReach.getInstance().setNavigationBarText("TheoremReach");
        return TheoremReach.getInstance();
    }

    public void setup(String apiKey, String userId, Activity parentActivity) {
        TheoremReach.getInstance().setParentActivityContext(parentActivity);
        TheoremReach.getInstance().setUserId(userId);
        TheoremReach.getInstance().setApiKey(apiKey);
        TheoremReach.getInstance().setCarrier(parentActivity);
        TheoremReach.getInstance().setConnectionType(parentActivity);
        TheoremReach.getInstance().setAppDevice();
        TheoremReach.getInstance().setOsVersion();
        TheoremReach.getInstance().setGoogleAdvertiserId();
    }

    public void showMomentSurvey() {
        if (!this.confirmConnectivity()) {
            return;
        }
        if (!TheoremReach.getInstance().momentSurveyAvailable) {
            return;
        }
        TheoremReach.getInstance().momentSurveyAvailable = false;
        this.momentSurveyOpen = true;
        this.onMomentSurveyOpened();
        this.setDisplaySettings();
        this.generateSurveyEntryURL();
        if (this._parentContext != null && this._parentContext.get() != null) {
            Intent intent = new Intent((Context)this._parentContext.get(), MomentSurveyActivity.class);
            intent.setFlags(0x14000000);
            ((Activity)this._parentContext.get()).startActivity(intent);
        }
    }

    private boolean confirmConnectivity() {
        if (TheoremReach.getInstance().getAppuserId() == null || TheoremReach.getInstance()._googleAdvertiserId == null) {
            TheoremReach.getInstance().setGoogleAdvertiserId();
            return false;
        }
        return this.checkConnectionStatus();
    }

    public void setPlacementId(String placementId) {
        this.placementId = placementId;
    }

    public void showRewardCenter(String placementId) {
        this.setPlacementId(placementId);
        this.showRewardCenter();
    }

    public void showRewardCenter() {
        if (!this.confirmConnectivity()) {
            return;
        }
        this.rewardCenterOpen = true;
        this.onRewardCenterOpened();
        this.startCreateSurveySessionTask();
        this.setDisplaySettings();
        this.generateRewardCenterURL();
        if (this._parentContext != null && this._parentContext.get() != null) {
            Intent intent = new Intent((Context)this._parentContext.get(), RewardCenterActivity.class);
            intent.setFlags(0x14000000);
            ((Activity)this._parentContext.get()).startActivity(intent);
        }
    }

    public void onResume(Activity activity) {
        TheoremReach.getInstance()._parentContext = new WeakReference<Activity>(activity);
        if (TheoremReach.getInstance().getAppuserId() == null || TheoremReach.getInstance()._googleAdvertiserId == null) {
            TheoremReach.getInstance().setGoogleAdvertiserId();
        }
        TheoremReach.getInstance().startMomentsTimer();
    }

    private void startMomentsTimer() {
        if (null != this.refreshAvailableSurvey) {
            return;
        }
        if (TheoremReach.getInstance().isMomentsEnabled() && TheoremReach.getInstance().momentsPollingFrequency >= 1) {
            this.refreshAvailableSurvey = new Timer();
            this.refreshAvailableSurveyTask = new TRTimer();
            this.refreshAvailableSurvey.schedule((TimerTask)this.refreshAvailableSurveyTask, 0L, (long)TheoremReach.getInstance().getMomentsPollingFrequency());
        }
    }

    public void onPause() {
        TheoremReach.getInstance()._parentContext = null;
        this.momentSurveyAvailable = false;
        if (null != this.refreshAvailableSurvey) {
            this.refreshAvailableSurvey.cancel();
            this.refreshAvailableSurveyTask = null;
            this.refreshAvailableSurvey = null;
        }
    }

    void setGoogleAdvertiserId() {
        if (this.fetchingAppuserId) {
            return;
        }
        this.fetchingAppuserId = true;
        if (TheoremReach.isKindleFire()) {
            String advertisingID = "";
            boolean limitAdTracking = false;
            try {
                ContentResolver cr = TheoremReach.getInstance().getParentContext().getContentResolver();
                boolean bl = limitAdTracking = Settings.Secure.getInt((ContentResolver)cr, (String)"limit_ad_tracking") != 0;
                if (limitAdTracking) {
                    return;
                }
                advertisingID = Settings.Secure.getString((ContentResolver)cr, (String)"advertising_id");
                TheoremReach.getInstance().startGetAppuserTask();
            }
            catch (Settings.SettingNotFoundException settingNotFoundException) {
                // empty catch block
            }
            TheoremReach.getInstance()._googleAdvertiserId = advertisingID;
            this.fetchingAppuserId = false;
        } else {
            new GpsIdTask().execute(new Void[0]);
        }
    }

    public void showUnityRewardCenter(final Activity context) {
        if (!this.checkConnectionStatus()) {
            return;
        }
        TheoremReach.getInstance()._parentContext = new WeakReference<Activity>(context);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    AdvertisingIdClientInfo.AdInfo adInfo = AdvertisingIdClientInfo.getAdvertisingIdInfo((Context)context);
                    TheoremReach.getInstance()._googleAdvertiserId = adInfo.getId();
                    TheoremReach.this.showRewardCenter();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).start();
    }

    public void showUnityMomentSurvey(final Activity context) {
        if (!this.checkConnectionStatus()) {
            return;
        }
        TheoremReach.getInstance()._parentContext = new WeakReference<Activity>(context);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    AdvertisingIdClientInfo.AdInfo adInfo = AdvertisingIdClientInfo.getAdvertisingIdInfo((Context)context);
                    TheoremReach.getInstance()._googleAdvertiserId = adInfo.getId();
                    TheoremReach.this.showMomentSurvey();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).start();
    }

    private boolean checkConnectionStatus() {
        if (this._parentContext != null && this._parentContext.get() != null) {
            this.setConnectionType((Activity)this._parentContext.get());
            return !this._connectionType.contains("unknown");
        }
        return false;
    }

    private void setDisplaySettings() throws InvalidParameterException {
        String wifi;
        if (this._parentContext != null && this._parentContext.get() != null) {
            TheoremReach.getInstance().setConnectionType(TheoremReach.getInstance().getParentContext());
        }
        if ((wifi = TheoremReach.getInstance().getConnectionType()).equals("unknown")) {
            return;
        }
        if (TheoremReach.getInstance().getGpsId() == null && this._parentContext != null && this._parentContext.get() != null) {
            String android_id = Settings.Secure.getString((ContentResolver)((Activity)this._parentContext.get()).getContentResolver(), (String)"android_id");
            TheoremReach.getInstance().setGpsId(android_id);
        }
    }

    private void generateRewardCenterURL() {
        TheoremReach tr = TheoremReach.getInstance();
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(this.getUrlPrefix() + "sdk/v2/appuser_entry?gps_id=").append(tr.getGpsId());
        urlBuilder.append("&api_key=").append(tr.getApiKey());
        urlBuilder.append("&user_id=").append(tr.getUserID());
        if (TheoremReach.getInstance().resetProfiler) {
            urlBuilder.append("&reset_profiler=").append("true");
        }
        if (TheoremReach.getInstance().placementId != null && TheoremReach.getInstance().placementId.length() > 1) {
            urlBuilder.append("&placement_id=").append(TheoremReach.getInstance().placementId);
        }
        this._surveyUrl = urlBuilder.toString();
    }

    private void generateSurveyEntryURL() {
        this._surveyUrl = TheoremReach.getInstance().getMomentEntryURL();
    }

    public void unityEarnedReward(int quantity) {
        this.unityEarnedContent = quantity;
    }

    public void unityAwardNotification() {
        if (TheoremReach.getInstance()._unityObjectName != null && TheoremReach.getInstance().getUnityEarnedContent() > 0) {
            String quantity = TheoremReach.getInstance().getUnityEarnedContent() + "";
            UnityPlayer.UnitySendMessage((String)TheoremReach.getInstance()._unityObjectName, (String)"OnReward", (String)quantity);
            TheoremReach.getInstance().setUnityEarnedContent(0);
            this.startUpdatePendingCoinsTask();
        }
    }

    public void awardContent(int quantity) {
        try {
            if (quantity > 0) {
                if (TheoremReach.getInstance()._rewardListener != null) {
                    TheoremReach.getInstance().getRewardListener().onReward(quantity);
                    this.startUpdatePendingCoinsTask();
                }
                if (TheoremReach.getInstance()._unityObjectName != null) {
                    SharedPreferences prefs;
                    TheoremReach.getInstance().unityEarnedReward(quantity);
                    if (TheoremReach.getInstance()._parentContext != null && TheoremReach.getInstance()._parentContext.get() != null && !(prefs = PreferenceManager.getDefaultSharedPreferences((Context)TheoremReach.getInstance().getParentContext())).getBoolean("theoremReachActive", false)) {
                        this.unityAwardNotification();
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void startGetAppuserTask() {
        new GetAppuserId().execute(new Void[0]);
    }

    private void checkForEarnedContent() {
        if (TheoremReach.getInstance().getAppuserId() == null || TheoremReach.getInstance()._appuserId.length() < 1 || TheoremReach.getInstance()._googleAdvertiserId == null) {
            TheoremReach.getInstance().setGoogleAdvertiserId();
            return;
        }
        this.startCheckForRewardsTask();
    }

    private void startCheckForRewardsTask() {
        new CheckAppuserRewards().execute(new Void[0]);
    }

    void fetchSurveyEntryURL() {
        if (TheoremReach.getInstance().momentsPollingFrequency < 1) {
            return;
        }
        if (TheoremReach.getInstance().getAppuserId() == null || TheoremReach.getInstance()._googleAdvertiserId == null) {
            TheoremReach.getInstance().setGoogleAdvertiserId();
            return;
        }
        new FetchSurveyEntryURL().execute(new Void[0]);
    }

    void fetchCloseButtonFromURL() {
        if (TheoremReach.getInstance().overrideCloseButtonURL == null) {
            return;
        }
        new FetchCloseButtonFromURL().execute(new Void[0]);
    }

    void fetchRefreshButtonFromURL() {
        if (TheoremReach.getInstance().overrideRefreshButtonURL == null) {
            return;
        }
        new FetchRefreshButtonFromURL().execute(new Void[0]);
    }

    private void startUpdatePendingCoinsTask() {
        new UpdatePendingCoins().execute(new Void[0]);
    }

    private void startCreateSurveySessionTask() {
        new CreateSurveySession().execute(new Void[0]);
    }

    public void resetProfiler(boolean resetProfiler) {
        TheoremReach.getInstance().resetProfiler = resetProfiler;
    }

    public void enableMoments(boolean momentEnabled) {
        TheoremReach.getInstance().momentsEnabled = momentEnabled;
        if (TheoremReach.getInstance().getAppuserId() != null && TheoremReach.getInstance().getAppuserId().length() > 0 && TheoremReach.getInstance().isSurveyAvailable() && TheoremReach.getInstance().momentsPollingFrequency >= 1) {
            this.fetchSurveyEntryURL();
        }
    }

    public void enableTitleBarInMoments(boolean enabled) {
        TheoremReach.getInstance().momentsTitleBarEnabled = enabled;
    }

    public void setTheoremReachRewardListener(TheoremReachRewardListener object) {
        this._rewardListener = object;
    }

    public void setTheoremReachSurveyListener(TheoremReachSurveyListener object) {
        this._surveyListener = object;
    }

    public void setTheoremReachSurveyAvailableListener(TheoremReachSurveyAvailableListener object) {
        this._surveyAvailableListener = object;
    }

    public void setTheoremReachMomentListener(TheoremReachMomentListener object) {
        this._momentListener = object;
    }

    private TheoremReachRewardListener getRewardListener() {
        return this._rewardListener;
    }

    private TheoremReachSurveyListener getSurveyListener() {
        return this._surveyListener;
    }

    private TheoremReachMomentListener getMomentListener() {
        return this._momentListener;
    }

    private TheoremReachSurveyAvailableListener getSurveyAvailableListener() {
        return this._surveyAvailableListener;
    }

    public void onRewardCenterOpened() {
        if (TheoremReach.getInstance()._surveyListener != null) {
            TheoremReach.getInstance().getSurveyListener().onRewardCenterOpened();
        }
        if (TheoremReach.getInstance()._unityObjectName != null) {
            UnityPlayer.UnitySendMessage((String)TheoremReach.getInstance()._unityObjectName, (String)"OnRewardCenterOpened", (String)"");
        }
    }

    public void onMomentSurveyOpened() {
        if (TheoremReach.getInstance()._momentListener != null) {
            TheoremReach.getInstance().getMomentListener().onMomentSurveyOpened();
        }
        if (TheoremReach.getInstance()._unityObjectName != null) {
            UnityPlayer.UnitySendMessage((String)TheoremReach.getInstance()._unityObjectName, (String)"OnMomentSurveyOpened", (String)"");
        }
    }

    public void onMomentSurveyClosed() {
        this.momentSurveyOpen = false;
        if (TheoremReach.getInstance()._momentListener != null) {
            TheoremReach.getInstance().getMomentListener().onMomentSurveyClosed();
        }
        if (TheoremReach.getInstance()._unityObjectName != null) {
            UnityPlayer.UnitySendMessage((String)TheoremReach.getInstance()._unityObjectName, (String)"OnMomentSurveyClosed", (String)"");
        }
    }

    public void onMomentSurveyReceived(int surveyLength) {
        if (TheoremReach.getInstance()._momentListener != null) {
            TheoremReach.getInstance().getMomentListener().onMomentSurveyReceived(surveyLength);
        }
        if (TheoremReach.getInstance()._unityObjectName != null) {
            String length = surveyLength + "";
            UnityPlayer.UnitySendMessage((String)TheoremReach.getInstance()._unityObjectName, (String)"OnMomentSurveyReceived", (String)length);
        }
    }

    public void onMomentSurveyCompleted() {
        if (TheoremReach.getInstance()._momentListener != null) {
            TheoremReach.getInstance().getMomentListener().onMomentSurveyCompleted();
        }
        if (TheoremReach.getInstance()._unityObjectName != null) {
            UnityPlayer.UnitySendMessage((String)TheoremReach.getInstance()._unityObjectName, (String)"OnMomentSurveyCompleted", (String)"");
        }
    }

    public void onMomentSurveyNotEligible() {
        if (TheoremReach.getInstance()._momentListener != null) {
            TheoremReach.getInstance().getMomentListener().onMomentSurveyNotEligible();
        }
        if (TheoremReach.getInstance()._unityObjectName != null) {
            UnityPlayer.UnitySendMessage((String)TheoremReach.getInstance()._unityObjectName, (String)"OnMomentSurveyNotEligible", (String)"");
        }
    }

    public void onRewardCenterClosed() {
        TheoremReach tr = TheoremReach.getInstance();
        tr.surveyAvailable = false;
        tr.placementId = "";
        this.checkForEarnedContent();
        if (tr._surveyListener != null) {
            tr.getSurveyListener().onRewardCenterClosed();
        }
        if (tr._unityObjectName != null) {
            UnityPlayer.UnitySendMessage((String)tr._unityObjectName, (String)"OnRewardCenterClosed", (String)"");
        }
        this.startGetAppuserTask();
    }

    public String getConnectionType() {
        return this._connectionType;
    }

    private String getMomentEntryURL() {
        return this.momentEntryURL;
    }

    public void setConnectionType(Activity context) {
        this._connectionType = ConnectionType.getTypeString((Context)context);
    }

    public void setAppDevice() {
        this._appDevice = Build.BRAND + " " + Build.MODEL;
    }

    public void setCarrier(Activity context) {
        try {
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            this._carrier = telephonyManager != null && telephonyManager.getSimOperatorName() != null ? telephonyManager.getSimOperatorName() : "";
        }
        catch (Exception e) {
            this._carrier = "";
        }
    }

    public void setOsVersion() {
        this._osVersion = String.valueOf(Build.VERSION.SDK_INT);
    }

    public Activity getParentContext() {
        return (Activity)this._parentContext.get();
    }

    public void setAppuserId(String appuserId) {
        this._appuserId = appuserId;
    }

    public String getAppuserId() {
        if ((this._appuserId == null || this._appuserId.length() < 1) && TheoremReach.getInstance()._parentContext != null && TheoremReach.getInstance()._parentContext.get() != null) {
            SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)TheoremReach.getInstance().getParentContext());
            return prefs.getString("theoremReachAppuserId", null);
        }
        return this._appuserId;
    }

    public int getUnityEarnedContent() {
        return TheoremReach.getInstance().unityEarnedContent;
    }

    private void setUnityEarnedContent(int content) {
        TheoremReach.getInstance().unityEarnedContent = content;
    }

    protected void setRewardIds(String rewardIds) {
        TheoremReach.getInstance().rewardIds = rewardIds;
    }

    public String getRewardIds() {
        return TheoremReach.getInstance().rewardIds;
    }

    public void setMomentSurveyLength(int minLength) {
        TheoremReach.getInstance().momentSurveyLength = minLength;
    }

    public void setMomentEntryURL(String momentEntryURL) {
        TheoremReach.getInstance().momentEntryURL = momentEntryURL;
    }

    public void setSurveyAvailable(boolean surveyAvailable) {
        TheoremReach.getInstance().surveyAvailable = surveyAvailable;
        if (TheoremReach.getInstance()._surveyAvailableListener != null) {
            TheoremReach.getInstance().getSurveyAvailableListener().theoremreachSurveyAvailable(surveyAvailable);
        }
        if (TheoremReach.getInstance()._unityObjectName != null) {
            UnityPlayer.UnitySendMessage((String)TheoremReach.getInstance()._unityObjectName, (String)"TheoremReachSurveyAvailable", (String)("" + surveyAvailable));
        }
    }

    public void setIsProfiled(boolean isProfiled) {
        TheoremReach.getInstance().isProfiled = isProfiled;
    }

    private void setGpsId(String android_id) {
        if (this._googleAdvertiserId == null) {
            this._googleAdvertiserId = android_id;
        }
    }

    public void setNavigationBarColor(String colorHexCode) {
        this.navigationBarColor = colorHexCode;
    }

    public String getNavigationBarColor() {
        return this.navigationBarColor;
    }

    public void setNavigationBarTextColor(String colorHexCode) {
        this.navigationBarTextColor = colorHexCode;
    }

    public String getNavigationBarTextColor() {
        return this.navigationBarTextColor;
    }

    public void setNavigationBarText(String navigationBarText) {
        this.navigationBarText = navigationBarText;
    }

    public String getNavigationBarText() {
        return this.navigationBarText;
    }

    public void setOverrideCloseButtonURL(String overrideCloseButtonURL) {
        this.overrideCloseButtonURL = overrideCloseButtonURL;
        this.fetchCloseButtonFromURL();
    }

    public Drawable getOverrideCloseButton() {
        return this.overrideCloseButton;
    }

    public String getOverrideCloseButtonURL() {
        return this.overrideCloseButtonURL;
    }

    public void setOverrideRefreshButtonURL(String overrideRefreshButtonURL) {
        this.overrideRefreshButtonURL = overrideRefreshButtonURL;
        this.fetchRefreshButtonFromURL();
    }

    public Drawable getOverrideRefreshButton() {
        return this.overrideRefreshButton;
    }

    public String getOverrideRefreshButtonURL() {
        return this.overrideRefreshButtonURL;
    }

    public void setApiKey(String key) {
        this._apiKey = key;
    }

    public void setParentActivityContext(Activity key) {
        this._parentContext = new WeakReference<Activity>(key);
    }

    public void setUserId(String key) {
        this._userId = key;
    }

    public String getSurveyUrl() {
        return this._surveyUrl;
    }

    public String getUserID() {
        return this._userId;
    }

    public String getCarrier() {
        return this._carrier;
    }

    public String getOsVersion() {
        return this._osVersion;
    }

    public String getAppDevice() {
        return this._appDevice;
    }

    private String getUrlPrefix() {
        return "https://theoremreach.com/";
    }

    public void setUnityObjectName(String objectName) {
        TheoremReach.getInstance()._unityObjectName = objectName;
    }

    public String getApiKey() {
        return this._apiKey;
    }

    public String getGpsId() {
        return this._googleAdvertiserId;
    }

    public boolean isSurveyAvailable() {
        if (TheoremReach.getInstance().getAppuserId() == null || TheoremReach.getInstance()._googleAdvertiserId == null) {
            TheoremReach.getInstance().setGoogleAdvertiserId();
            return false;
        }
        return TheoremReach.getInstance().surveyAvailable;
    }

    private int getMomentSurveyLength() {
        return TheoremReach.getInstance().momentSurveyLength;
    }

    public boolean isProfiled() {
        return TheoremReach.getInstance().isProfiled;
    }

    public boolean isMomentsEnabled() {
        return TheoremReach.getInstance().momentsEnabled;
    }

    public boolean isMomentsTitleBarEnabled() {
        return TheoremReach.getInstance().momentsTitleBarEnabled;
    }

    public void setMomentsSurveyPollingFrequency(int momentsPollingFrequency) {
        TheoremReach.getInstance().momentsPollingFrequency = momentsPollingFrequency;
    }

    private int getMomentsPollingFrequency() {
        return TheoremReach.getInstance().momentsPollingFrequency * 60 * 1000;
    }

    public boolean isSurveyAvailable(int maxLength) {
        TheoremReach tr = TheoremReach.getInstance();
        return tr.isSurveyAvailable() && tr.momentSurveyAvailable && tr.getMomentSurveyLength() <= maxLength;
    }

    public static boolean unityIsSurveyAvailable() {
        return TheoremReach.getInstance().isSurveyAvailable();
    }

    public static boolean unityIsProfiled() {
        return TheoremReach.getInstance().isProfiled();
    }

    public void setUnityGame(boolean unity) {
        TheoremReach.getInstance().unity = unity;
    }

    public boolean isUnity() {
        return TheoremReach.getInstance().unity;
    }

    public static boolean isKindleFire() {
        return Build.MANUFACTURER.equals("Amazon") && (Build.MODEL.equals("Kindle Fire") || Build.MODEL.startsWith("KF"));
    }

    static {
        SDK_VERSION = "3.4.0";
    }

    private static class CreateSurveySession
    extends AsyncTask<Void, Void, Void> {
        private CreateSurveySession() {
        }

        protected Void doInBackground(Void ... params) {
            try {
                new AppuserConnection().createSurveySession();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }
    }

    private static class UpdatePendingCoins
    extends AsyncTask<Void, Void, Void> {
        private UpdatePendingCoins() {
        }

        protected Void doInBackground(Void ... params) {
            try {
                new AppuserConnection().grantUserReward();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }
    }

    private static class GpsIdTask
    extends AsyncTask<Void, Void, String> {
        private GpsIdTask() {
        }

        protected String doInBackground(Void ... params) {
            AdvertisingIdClient.Info idInfo = null;
            try {
                if (TheoremReach.getInstance()._parentContext != null && TheoremReach.getInstance()._parentContext.get() != null) {
                    idInfo = AdvertisingIdClient.getAdvertisingIdInfo((Context)TheoremReach.getInstance().getParentContext());
                }
            }
            catch (GooglePlayServicesNotAvailableException e) {
                e.printStackTrace();
            }
            catch (GooglePlayServicesRepairableException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            String advertId = null;
            try {
                advertId = idInfo.getId();
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
            return advertId;
        }

        protected void onPostExecute(String advertId) {
            if (advertId != null) {
                TheoremReach.getInstance()._googleAdvertiserId = advertId;
                TheoremReach.getInstance().startGetAppuserTask();
            } else {
                TheoremReach.getInstance().fetchingAppuserId = false;
            }
        }
    }

    private static class FetchRefreshButtonFromURL
    extends AsyncTask<Void, Void, Void> {
        private FetchRefreshButtonFromURL() {
        }

        protected Void doInBackground(Void ... params) {
            try {
                TheoremReach.getInstance().overrideRefreshButton = new AppuserConnection().drawableFromUrl(TheoremReach.getInstance().overrideRefreshButtonURL);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }
    }

    private static class FetchCloseButtonFromURL
    extends AsyncTask<Void, Void, Void> {
        private FetchCloseButtonFromURL() {
        }

        protected Void doInBackground(Void ... params) {
            try {
                TheoremReach.getInstance().overrideCloseButton = new AppuserConnection().drawableFromUrl(TheoremReach.getInstance().overrideCloseButtonURL);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }
    }

    private static class FetchSurveyEntryURL
    extends AsyncTask<Void, Void, Void> {
        private FetchSurveyEntryURL() {
        }

        protected Void doInBackground(Void ... params) {
            try {
                if (TheoremReach.getInstance().fetchingMomentSurvey) {
                    return null;
                }
                TheoremReach.getInstance().momentSurveyAvailable = false;
                TheoremReach.getInstance().setMomentEntryURL("");
                TheoremReach.getInstance().fetchingMomentSurvey = true;
                new AppuserConnection().getMomentSurveyEntryURL();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        protected void onPostExecute(Void result) {
            TheoremReach.getInstance().fetchingMomentSurvey = false;
            if (TheoremReach.getInstance().getMomentSurveyLength() > 0 && TheoremReach.getInstance().getMomentSurveyLength() < 31 && TheoremReach.getInstance().getMomentEntryURL() != null && TheoremReach.getInstance().getMomentEntryURL().length() > 10) {
                int length = TheoremReach.getInstance().getMomentSurveyLength();
                TheoremReach.getInstance().onMomentSurveyReceived(length);
                TheoremReach.getInstance().momentSurveyAvailable = true;
            }
        }
    }

    private static class CheckAppuserRewards
    extends AsyncTask<Void, Void, Void> {
        private CheckAppuserRewards() {
        }

        protected Void doInBackground(Void ... params) {
            try {
                new AppuserConnection().checkAppuserRewards();
                TheoremReach.getInstance().fetchingAppuserId = false;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }
    }

    private static class GetAppuserId
    extends AsyncTask<Void, Void, Void> {
        private GetAppuserId() {
        }

        protected Void doInBackground(Void ... params) {
            try {
                new AppuserConnection().getAppuserId();
                TheoremReach.getInstance().fetchingAppuserId = false;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        protected void onPostExecute(Void result) {
            if (TheoremReach.getInstance()._appuserId != null && TheoremReach.getInstance()._appuserId.length() > 1) {
                if (TheoremReach.getInstance()._parentContext != null && TheoremReach.getInstance()._parentContext.get() != null) {
                    SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)TheoremReach.getInstance().getParentContext());
                    prefs.edit().putString("theoremReachAppuserId", TheoremReach.getInstance()._appuserId).apply();
                }
                if (!TheoremReach.getInstance().initialized) {
                    TheoremReach.getInstance().checkForEarnedContent();
                    TheoremReach.getInstance().initialized = true;
                }
                if (TheoremReach.getInstance().isMomentsEnabled() && !TheoremReach.getInstance().fetchingMomentSurvey && TheoremReach.getInstance().momentsPollingFrequency >= 1 && TheoremReach.getInstance().getMomentEntryURL() == "") {
                    TheoremReach.getInstance().startMomentsTimer();
                }
            }
        }
    }

    class TRTimer
    extends TimerTask {
        TRTimer() {
        }

        @Override
        public void run() {
            if (TheoremReach.getInstance().momentsPollingFrequency < 1) {
                return;
            }
            if (TheoremReach.getInstance().getAppuserId() != null && TheoremReach.getInstance()._googleAdvertiserId != null) {
                TheoremReach.this.fetchSurveyEntryURL();
            }
        }
    }
}

