/*
 * Decompiled with CFR 0.152.
 */
package theoremreach.com.theoremreach;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.DialogInterface;
import android.content.SharedPreferences;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.PorterDuff;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.http.SslError;
import android.os.Bundle;
import android.os.Message;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.webkit.SslErrorHandler;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import androidx.preference.PreferenceManager;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.atomic.AtomicInteger;
import theoremreach.com.theoremreach.R;
import theoremreach.com.theoremreach.TheoremReach;

public class RewardCenterActivity
extends AppCompatActivity {
    private int currentId = 1000000;
    protected String _baseUrl;
    protected String _homeButtonURL;
    protected RelativeLayout _progressIndicatorView;
    protected FrameLayout _webViewPlaceholder;
    protected SurveyWebView _webView;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.supportRequestWindowFeature(9);
        this.requestWindowFeature(1);
        this.getWindow().setFlags(1024, 1024);
        RelativeLayout survey_layout = this.generateSurveyLayout();
        this._baseUrl = TheoremReach.getInstance().getSurveyUrl();
        this._homeButtonURL = "https://theoremreach.com/sdk/v1/appuser_abandoned_campaign?id=" + TheoremReach.getInstance().getAppuserId();
        this.setOrientationPermission();
        this.initUI();
        this.setContentView((View)survey_layout);
    }

    protected void onStart() {
        super.onStart();
        this.updateSharedPreferences(true);
    }

    protected void onStop() {
        super.onStop();
        if (TheoremReach.getInstance().getUnityEarnedContent() > 0) {
            TheoremReach.getInstance().unityAwardNotification();
        }
        this.updateSharedPreferences(false);
    }

    private void updateSharedPreferences(boolean status) {
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)this);
        prefs.edit().putBoolean("theoremReachActive", status).apply();
    }

    public boolean onCreateOptionsMenu(Menu menu) {
        Drawable drawable2;
        if (TheoremReach.getInstance().getOverrideRefreshButtonURL() != null && TheoremReach.getInstance().getOverrideRefreshButton() != null) {
            drawable2 = TheoremReach.getInstance().getOverrideRefreshButton();
            Bitmap bitmap = ((BitmapDrawable)drawable2).getBitmap();
            BitmapDrawable newDrawable = new BitmapDrawable(this.getResources(), Bitmap.createScaledBitmap((Bitmap)bitmap, (int)100, (int)100, (boolean)true));
            menu.add(0, 1623333523, 0, (CharSequence)"Refresh").setIcon((Drawable)newDrawable).setShowAsAction(2);
        } else {
            menu.add(0, 1623333523, 0, (CharSequence)"Refresh").setIcon(R.drawable.ic_action_refresh_white).setShowAsAction(2);
        }
        drawable2 = menu.getItem(0).getIcon();
        drawable2.mutate();
        drawable2.setColorFilter(Color.parseColor((String)TheoremReach.getInstance().getNavigationBarTextColor()), PorterDuff.Mode.SRC_ATOP);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 16908332: {
                if (TheoremReach.getInstance().momentSurveyOpen) {
                    this.closeRewardCenter();
                    return true;
                }
                SurveyWebView view = this._webView;
                URL url = null;
                try {
                    url = new URL(view.getUrl());
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
                if (url != null) {
                    if (url.getHost().equals("theoremreach.com") || url.getHost().equals("staging.theoremreach.com")) {
                        this.closeRewardCenter();
                        return true;
                    }
                    this._webView.loadUrl(this._homeButtonURL);
                } else {
                    this.closeRewardCenter();
                }
                return true;
            }
            case 1623333523: {
                try {
                    this._webView.loadUrl(this._webView.getUrl());
                }
                catch (Exception e) {
                    this._webView.reload();
                }
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    protected void initUI() {
        if (this._webView == null) {
            this._webView = new SurveyWebView((Context)this);
            this._webView.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
            this._webView.getSettings().setJavaScriptEnabled(true);
            this._webView.getSettings().setUseWideViewPort(true);
            this._webView.getSettings().setDomStorageEnabled(true);
            this._webView.setWebChromeClient(new SurveyWebChromeClient());
            this._webView.setWebViewClient(new SurveyWebViewClient());
            this._webView.getSettings().setSupportZoom(true);
            this._webView.loadUrl(this._baseUrl);
        } else {
            if (this._webView.getProgress() >= 100) {
                this._progressIndicatorView.setVisibility(4);
            }
            this.setNavigationButtonsState();
        }
        this._webViewPlaceholder.addView((View)this._webView);
    }

    public static String getApplicationName(Context context) {
        return context.getApplicationInfo().loadLabel(context.getPackageManager()).toString();
    }

    private RelativeLayout generateSurveyLayout() {
        RelativeLayout progressView;
        FrameLayout webViewPlaceholder;
        Drawable appIcon;
        RelativeLayout survey_layout = new RelativeLayout((Context)this);
        survey_layout.setId(this.generateViewId());
        survey_layout.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        Toolbar toolbar = new Toolbar((Context)this);
        toolbar.setId(this.generateViewId());
        LinearLayout.LayoutParams myLayoutParams = new LinearLayout.LayoutParams(-1, -2);
        myLayoutParams.weight = 1.0f;
        myLayoutParams.gravity = 17;
        toolbar.setLayoutParams((ViewGroup.LayoutParams)myLayoutParams);
        toolbar.setPopupTheme(R.style.LibraryTheme);
        toolbar.setBackgroundColor(Color.parseColor((String)TheoremReach.getInstance().getNavigationBarColor()));
        if (!TheoremReach.getInstance().isUnity()) {
            toolbar.setContentInsetStartWithNavigation(0);
        }
        survey_layout.addView((View)toolbar, 0);
        this.setSupportActionBar(toolbar);
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        Drawable iconDrawable = appIcon = this.getResources().getDrawable(R.drawable.ic_action_remove_white);
        iconDrawable.mutate();
        iconDrawable.setColorFilter(Color.parseColor((String)TheoremReach.getInstance().getNavigationBarTextColor()), PorterDuff.Mode.SRC_ATOP);
        if (TheoremReach.getInstance().getOverrideCloseButtonURL() != null && TheoremReach.getInstance().getOverrideCloseButton() != null) {
            Drawable drawable2 = TheoremReach.getInstance().getOverrideCloseButton();
            Bitmap bitmap = ((BitmapDrawable)drawable2).getBitmap();
            BitmapDrawable newDrawable = new BitmapDrawable(this.getResources(), Bitmap.createScaledBitmap((Bitmap)bitmap, (int)80, (int)80, (boolean)true));
            newDrawable.mutate();
            newDrawable.setColorFilter(Color.parseColor((String)TheoremReach.getInstance().getNavigationBarTextColor()), PorterDuff.Mode.SRC_ATOP);
            if (!TheoremReach.getInstance().momentSurveyOpen) {
                this.getSupportActionBar().setHomeAsUpIndicator((Drawable)newDrawable);
            }
        } else if (!TheoremReach.getInstance().momentSurveyOpen) {
            this.getSupportActionBar().setHomeAsUpIndicator(appIcon);
        }
        TextView title = new TextView((Context)this);
        title.setId(this.generateViewId());
        title.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        title.setTextColor(Color.parseColor((String)TheoremReach.getInstance().getNavigationBarTextColor()));
        title.setText((CharSequence)TheoremReach.getInstance().getNavigationBarText());
        title.setTextSize(2, 18.0f);
        title.setMaxLines(1);
        title.setEllipsize(TextUtils.TruncateAt.END);
        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)title.getLayoutParams();
        layoutParams.addRule(13, -1);
        layoutParams.addRule(15, -1);
        title.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        title.setGravity(17);
        toolbar.addView((View)title);
        this._webViewPlaceholder = webViewPlaceholder = new FrameLayout((Context)this);
        webViewPlaceholder.setId(this.generateViewId());
        webViewPlaceholder.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        RelativeLayout.LayoutParams webViewPlaceholderLayoutParams = new RelativeLayout.LayoutParams(-1, -1);
        webViewPlaceholderLayoutParams.addRule(3, toolbar.getId());
        webViewPlaceholder.setLayoutParams((ViewGroup.LayoutParams)webViewPlaceholderLayoutParams);
        survey_layout.addView((View)webViewPlaceholder);
        this._progressIndicatorView = progressView = new RelativeLayout((Context)this);
        progressView.setId(this.generateViewId());
        progressView.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        RelativeLayout.LayoutParams progressViewLayoutParams = new RelativeLayout.LayoutParams(-1, -1);
        progressViewLayoutParams.addRule(3, toolbar.getId());
        progressView.setLayoutParams((ViewGroup.LayoutParams)progressViewLayoutParams);
        progressView.setClickable(true);
        progressView.setBackgroundColor(Color.parseColor((String)"#b0555555"));
        progressView.setVisibility(0);
        survey_layout.addView((View)progressView);
        ProgressBar progressBar = new ProgressBar((Context)this);
        progressBar.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-2, -2));
        RelativeLayout.LayoutParams progressBarParams = (RelativeLayout.LayoutParams)progressBar.getLayoutParams();
        progressBarParams.addRule(13, -1);
        progressView.addView((View)progressBar);
        return survey_layout;
    }

    public void onConfigurationChanged(Configuration newConfig) {
        if (this._webView != null) {
            this._webViewPlaceholder.removeView((View)this._webView);
        }
        super.onConfigurationChanged(newConfig);
        RelativeLayout survey_layout = this.generateSurveyLayout();
        this.setContentView((View)survey_layout);
        this.initUI();
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        this._webView.saveState(outState);
    }

    protected void onRestoreInstanceState(Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
        this._webView.restoreState(savedInstanceState);
    }

    private void setOrientationPermission() {
        WindowManager window_manager = (WindowManager)this.getSystemService("window");
        Display display = window_manager.getDefaultDisplay();
        DisplayMetrics metrics = new DisplayMetrics();
        display.getMetrics(metrics);
        int width = metrics.widthPixels;
        if (this.getResources().getConfiguration().orientation == 2) {
            width = metrics.heightPixels;
        }
        if (width < 760) {
            this.setRequestedOrientation(1);
        }
    }

    public int generateViewId() {
        int newValue;
        int result;
        AtomicInteger sNextGeneratedId = new AtomicInteger(this.currentId);
        ++this.currentId;
        do {
            if ((newValue = (result = sNextGeneratedId.get()) + 1) <= 0xFFFFFF) continue;
            newValue = 1;
        } while (!sNextGeneratedId.compareAndSet(result, newValue));
        return result;
    }

    protected void closeRewardCenter() {
        this.finish();
        TheoremReach.getInstance().onRewardCenterClosed();
    }

    public void onBackPressed() {
        SurveyWebView view = this._webView;
        URL url = null;
        try {
            url = new URL(view.getUrl());
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (url != null) {
            String path = url.getPath();
            if (url.getHost().equals("theoremreach.com") || url.getHost().equals("staging.theoremreach.com")) {
                this.closeRewardCenter();
            }
        }
    }

    protected void setNavigationButtonsState() {
        SurveyWebView view = this._webView;
        URL url = null;
        try {
            url = new URL(view.getUrl());
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (url != null) {
            String path = url.getPath();
            if ((url.getHost().equals("theoremreach.com") || url.getHost().equals("staging.theoremreach.com")) && path.contains("pulley/finish")) {
                this.closeRewardCenter();
                return;
            }
        } else {
            this._webView.loadUrl(this._baseUrl);
        }
    }

    class SurveyWebViewClient
    extends WebViewClient {
        SurveyWebViewClient() {
        }

        public void onReceivedSslError(WebView view, final SslErrorHandler handler, SslError error) {
            try {
                AlertDialog.Builder builder = new AlertDialog.Builder((Context)RewardCenterActivity.this);
                builder.setMessage((CharSequence)"Uh oh! The survey has encountered an SSL error while loading. Please click OK to continue to the survey.");
                builder.setPositiveButton((CharSequence)"OK", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        handler.proceed();
                    }
                });
                builder.setNegativeButton((CharSequence)"Cancel", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        handler.cancel();
                    }
                });
                AlertDialog dialog = builder.create();
                dialog.show();
            }
            catch (Exception e) {
                e.printStackTrace();
                view.loadUrl(TheoremReach.getInstance().getSurveyUrl());
            }
        }

        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            super.onPageStarted(view, url, favicon);
            RewardCenterActivity.this._progressIndicatorView.setVisibility(0);
            if (url.contains("https://play.google.com/store/apps/") || url.contains("market://")) {
                view.loadUrl(TheoremReach.getInstance().getSurveyUrl());
            }
        }

        public void onPageFinished(WebView view, String url) {
        }
    }

    class SurveyWebView
    extends WebView {
        public SurveyWebView(Context context) {
            super(context);
        }

        public void goBack() {
            super.goBack();
        }
    }

    class SurveyWebChromeClient
    extends WebChromeClient {
        SurveyWebChromeClient() {
        }

        public void onProgressChanged(WebView view, int newProgress) {
            super.onProgressChanged(view, newProgress);
            if (newProgress >= 100 && view.getUrl() != null) {
                RewardCenterActivity.this._progressIndicatorView.setVisibility(4);
                RewardCenterActivity.this.setNavigationButtonsState();
            }
        }

        public boolean onCreateWindow(WebView view, boolean dialog, boolean userGesture, Message resultMsg) {
            ((WebView.WebViewTransport)resultMsg.obj).setWebView(view);
            resultMsg.sendToTarget();
            return true;
        }
    }
}

