/*
 * Decompiled with CFR 0.152.
 */
package theoremreach.com.theoremreach;

import android.os.Bundle;
import java.net.MalformedURLException;
import java.net.URL;
import theoremreach.com.theoremreach.RewardCenterActivity;
import theoremreach.com.theoremreach.TheoremReach;

public class MomentSurveyActivity
extends RewardCenterActivity {
    private boolean finished = false;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (TheoremReach.getInstance().isMomentsTitleBarEnabled()) {
            this.getSupportActionBar().setDisplayHomeAsUpEnabled(false);
        } else {
            this.getSupportActionBar().hide();
        }
    }

    @Override
    protected void setNavigationButtonsState() {
        super.setNavigationButtonsState();
        RewardCenterActivity.SurveyWebView view = this._webView;
        URL url = null;
        try {
            url = new URL(view.getUrl());
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (url != null) {
            String path = url.getPath();
            if (url.getHost().equals("theoremreach.com") || url.getHost().equals("staging.theoremreach.com")) {
                if (path.contains("moments_result/success")) {
                    if (!this.finished) {
                        TheoremReach.getInstance().onMomentSurveyCompleted();
                        this.closeRewardCenter();
                        return;
                    }
                } else if (path.contains("moments_result/term")) {
                    if (!this.finished) {
                        TheoremReach.getInstance().onMomentSurveyNotEligible();
                        this.closeRewardCenter();
                        return;
                    }
                } else if (path.contains("moments_result/quit") && !this.finished) {
                    this.closeRewardCenter();
                    return;
                }
            }
        } else {
            this.closeRewardCenter();
        }
    }

    @Override
    protected void closeRewardCenter() {
        if (!this.finished) {
            TheoremReach.getInstance().onMomentSurveyClosed();
        }
        this.finished = true;
        TheoremReach.getInstance().momentSurveyOpen = false;
        this.finish();
    }
}

