package theoremreach.com.theoremreach.utils;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.os.Build;
import android.telephony.TelephonyManager;

public class ConnectionType {
    static public String getTypeString(Context ctx) {
        try {
            TelephonyManager telephonyManager = (TelephonyManager) ctx.getSystemService(Context.TELEPHONY_SERVICE);
            ConnectivityManager cm = (ConnectivityManager) ctx.getSystemService(Context.CONNECTIVITY_SERVICE);
            if (cm == null || telephonyManager == null) {
                return "unknown";
            }

            int networkType;
            boolean isConnected = false;
            boolean isCellular = false;
            boolean isWifi = false;

            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
                NetworkCapabilities netCapabilities = cm.getNetworkCapabilities(cm.getActiveNetwork());
                if (netCapabilities == null) {
                    return "unknown";
                }

                isConnected = true;
                isCellular = netCapabilities.hasTransport(NetworkCapabilities.TRANSPORT_CELLULAR);
                isWifi = netCapabilities.hasTransport(NetworkCapabilities.TRANSPORT_WIFI);
                networkType = telephonyManager.getNetworkType();
            } else {
                NetworkInfo info = cm.getActiveNetworkInfo();
                if (info == null) {
                    return "unknown";
                }

                isConnected = info.isConnected();
                isCellular = info.getType() == ConnectivityManager.TYPE_MOBILE;
                isWifi = info.getType() == ConnectivityManager.TYPE_WIFI;
                networkType = info.getSubtype();
            }

            if (!isConnected || (!isWifi && !isCellular)) {
                return "unknown";
            }

            if (isWifi) {
                return "WIFI";
            } else if (isCellular) {
                switch (networkType) {
                    case TelephonyManager.NETWORK_TYPE_GPRS:
                    case TelephonyManager.NETWORK_TYPE_EDGE:
                    case TelephonyManager.NETWORK_TYPE_CDMA:
                    case TelephonyManager.NETWORK_TYPE_1xRTT:
                    case TelephonyManager.NETWORK_TYPE_IDEN: //api<8 : replace by 11
                        return "2G";
                    case TelephonyManager.NETWORK_TYPE_UMTS:
                    case TelephonyManager.NETWORK_TYPE_EVDO_0:
                    case TelephonyManager.NETWORK_TYPE_EVDO_A:
                    case TelephonyManager.NETWORK_TYPE_HSDPA:
                    case TelephonyManager.NETWORK_TYPE_HSUPA:
                    case TelephonyManager.NETWORK_TYPE_HSPA:
                    case TelephonyManager.NETWORK_TYPE_EVDO_B: //api<9 : replace by 14
                    case TelephonyManager.NETWORK_TYPE_EHRPD:  //api<11 : replace by 12
                    case TelephonyManager.NETWORK_TYPE_HSPAP:  //api<13 : replace by 15
                        return "3G";
                    case TelephonyManager.NETWORK_TYPE_LTE:    //api<11 : replace by 13
                        return "4G";
                    case TelephonyManager.NETWORK_TYPE_NR:
                        return "5G";
                    default:
                        return "unknown";
                }
            }
        } catch (Exception e) { }

        return "unknown";
    }
}
