package theoremreach.com.theoremreach;

/**
 * Created by thammond on 12/22/15.
 */

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.graphics.drawable.Drawable;
import android.os.AsyncTask;
import android.os.Build;
import androidx.preference.PreferenceManager;
import android.provider.Settings;
import android.provider.Settings.Secure;
import android.provider.Settings.SettingNotFoundException;
import android.telephony.TelephonyManager;

import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.security.InvalidParameterException;
import java.util.Timer;
import java.util.TimerTask;

import theoremreach.com.theoremreach.utils.AdvertisingIdClientInfo;
import theoremreach.com.theoremreach.utils.ConnectionType;

public class TheoremReach {
    private static TheoremReach _instance;
    private TheoremReachRewardListener _rewardListener;
    private TheoremReachSurveyListener _surveyListener;
    private TheoremReachSurveyAvailableListener _surveyAvailableListener;
    private TheoremReachMomentListener _momentListener;
    private String _apiKey = "";
    private String _userId = "";
    private String _surveyUrl = "";
    private WeakReference<Activity> _parentContext;
    private String _googleAdvertiserId;
    private String _unityObjectName;
    private String _carrier;
    private String _osVersion;
    private String _appDevice;
    private String _connectionType;
    private String _appuserId = "";
    private int _awardedContent = 0;
    private boolean surveyAvailable = false;
    private int momentSurveyLength = 999999;
    private String momentEntryURL = "";
    private boolean isProfiled = false;
    private int unityEarnedContent = 0;
    public boolean rewardCenterOpen = false;
    public boolean momentSurveyOpen = false;
    public boolean resetProfiler = false;
    private boolean initialized = false;
    private String navigationBarColor = "#211548";
    private String navigationBarTextColor = "#FFFFFF";
    private String navigationBarText = "";
    private String overrideCloseButtonURL;
    private String overrideRefreshButtonURL;
    private Drawable overrideCloseButton;
    private Drawable overrideRefreshButton;
    private int momentsPollingFrequency = -1;
    private boolean unity = false;
    private String placementId = "";

    private boolean momentsEnabled = false;
    private boolean momentsTitleBarEnabled = false;
    private boolean fetchingMomentSurvey = false;
    private boolean momentSurveyAvailable = false;

    private String rewardIds = "";
    public static String SDK_VERSION = BuildConfig.VERSION_NAME;
    private boolean fetchingAppuserId = false;
    private Timer refreshAvailableSurvey;
    private TRTimer refreshAvailableSurveyTask;

    private final String TAG = "TheoremReach";

    public static TheoremReach getInstance()
    {
        if (_instance == null)
        {
            _instance = new TheoremReach();
        }
        return _instance;
    }

    public static TheoremReach initWithApiKeyAndUserIdAndActivityContext(String apiKey, String userId, Activity parentActivity)  {
        getInstance().setup(apiKey, userId, parentActivity);
        getInstance().setNavigationBarText("TheoremReach");

        return getInstance();
    }

    // TODO: is the ThreadPolicy global? Enforce this in a demo app.

    public void setup(String apiKey, String userId, Activity parentActivity) {
        getInstance().setParentActivityContext(parentActivity);
        getInstance().setUserId(userId);
        getInstance().setApiKey(apiKey);
        getInstance().setCarrier(parentActivity);
        getInstance().setConnectionType(parentActivity);
        getInstance().setAppDevice();
        getInstance().setOsVersion();
        getInstance().setGoogleAdvertiserId();
    }

    public void showMomentSurvey(){
        if (!confirmConnectivity()) return;

        if (!TheoremReach.getInstance().momentSurveyAvailable) return;

        TheoremReach.getInstance().momentSurveyAvailable = false;

        momentSurveyOpen = true;

        onMomentSurveyOpened();

        setDisplaySettings();
        generateSurveyEntryURL();
        if (this._parentContext != null && this._parentContext.get() != null) {
            Intent intent = new Intent(this._parentContext.get(), MomentSurveyActivity.class);
            intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_CLEAR_TOP);
            this._parentContext.get().startActivity(intent);
        }
    }

    private boolean confirmConnectivity() {
        if (TheoremReach.getInstance().getAppuserId() == null || TheoremReach.getInstance()._googleAdvertiserId == null) {
            TheoremReach.getInstance().setGoogleAdvertiserId();
            return false;
        }

        return checkConnectionStatus();
    }

    public void setPlacementId(String placementId) {
        this.placementId = placementId;
    }

    public void showRewardCenter(String placementId) {
        this.setPlacementId(placementId);

        showRewardCenter();
    }

    public void showRewardCenter()
    {
        if (!confirmConnectivity()) return;

        rewardCenterOpen = true;
        onRewardCenterOpened();
        startCreateSurveySessionTask();

        setDisplaySettings();
        generateRewardCenterURL();
        if (this._parentContext != null && this._parentContext.get() != null) {
            Intent intent = new Intent(this._parentContext.get(), RewardCenterActivity.class);
            intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_CLEAR_TOP);
            this._parentContext.get().startActivity(intent);
        }
    }

    public void onResume(Activity activity) {
        TheoremReach.getInstance()._parentContext = new WeakReference<Activity>(activity);
        if (TheoremReach.getInstance().getAppuserId() == null || TheoremReach.getInstance()._googleAdvertiserId == null) {
            TheoremReach.getInstance().setGoogleAdvertiserId();
        }

        TheoremReach.getInstance().startMomentsTimer();
    }

    private void startMomentsTimer() {
        if (null != refreshAvailableSurvey) return;

        if (TheoremReach.getInstance().isMomentsEnabled() && TheoremReach.getInstance().momentsPollingFrequency >= 1) {
            refreshAvailableSurvey = new Timer();
            refreshAvailableSurveyTask = new TRTimer();
            refreshAvailableSurvey.schedule(refreshAvailableSurveyTask, 0, TheoremReach.getInstance().getMomentsPollingFrequency());
        }
    }

    public void onPause() {
        TheoremReach.getInstance()._parentContext = null;
        momentSurveyAvailable = false;

        if (null != refreshAvailableSurvey) {
            refreshAvailableSurvey.cancel();
            refreshAvailableSurveyTask = null;
            refreshAvailableSurvey = null;
        }
    }

    class  TRTimer extends TimerTask {
        @Override
        public void run() {
            if (TheoremReach.getInstance().momentsPollingFrequency < 1) {
                return;
            }

            if (TheoremReach.getInstance().getAppuserId() != null && TheoremReach.getInstance()._googleAdvertiserId!= null) {
                fetchSurveyEntryURL();
            }
        }
    }

    // TODO: setup unregister listener that sets _parentContext to null. Implement onStart/onStop? Or maybe onDestroy if it's always called

    // TODO: do we actually need the AdvertisingIdClientInfo for Unity or can we use the standard Google?

    // TODO: create a new IntentService class instead of AsyncTasks?

    // TODO: include OKHTTP library? http://square.github.io/okhttp/. RetroFit - http://square.github.io/retrofit/. RetroFit is build for REST, de-serializeation, etc.

    // TODO: look into RefWatcher to ensure we aren't holding onto references inappropriately. https://github.com/square/leakcanary/blob/master/leakcanary-watcher/src/main/java/com/squareup/leakcanary/RefWatcher.java

    // TODO: create new class for all of the static AsyncTasks called like "BackgroundWork"

    void setGoogleAdvertiserId() {
        if (fetchingAppuserId) return;

        fetchingAppuserId = true;

        if (isKindleFire()) {
            String advertisingID = "";
            boolean limitAdTracking = false;

            try {
                ContentResolver cr = TheoremReach.getInstance().getParentContext().getContentResolver();

                // get user's tracking preference
                limitAdTracking = Secure.getInt(cr, "limit_ad_tracking") != 0;
                if (limitAdTracking) return;

                // get advertising
                advertisingID = Secure.getString(cr, "advertising_id");
                TheoremReach.getInstance().startGetAppuserTask();
            } catch (SettingNotFoundException ex) {
                // not supported
            }

            TheoremReach.getInstance()._googleAdvertiserId = advertisingID;
            fetchingAppuserId = false;
        } else {
            new GpsIdTask().execute();
        }
    }

    public void showUnityRewardCenter(final Activity context)
    {
        if (!checkConnectionStatus()) return;

        getInstance()._parentContext = new WeakReference<Activity>(context);

        new Thread(new Runnable()
        {
            public void run()
            {
                try
                {
                    AdvertisingIdClientInfo.AdInfo adInfo = AdvertisingIdClientInfo.getAdvertisingIdInfo(context);
                    TheoremReach.getInstance()._googleAdvertiserId = adInfo.getId();
                    TheoremReach.this.showRewardCenter();
                }
                catch (Exception e)
                {
                    e.printStackTrace();
                }
            }
        }).start();
    }

    public void showUnityMomentSurvey(final Activity context)
    {
        if (!checkConnectionStatus()) return;

        getInstance()._parentContext = new WeakReference<Activity>(context);

        new Thread(new Runnable()
        {
            public void run()
            {
                try
                {
                    AdvertisingIdClientInfo.AdInfo adInfo = AdvertisingIdClientInfo.getAdvertisingIdInfo(context);
                    TheoremReach.getInstance()._googleAdvertiserId = adInfo.getId();
                    TheoremReach.this.showMomentSurvey();
                }
                catch (Exception e)
                {
                    e.printStackTrace();
                }
            }
        }).start();
    }

    // TODO: update _parentContext to like parentContextReference or whatever it references

    private boolean checkConnectionStatus() {
        if (this._parentContext != null && this._parentContext.get() != null) {
            setConnectionType(this._parentContext.get());

            if (this._connectionType.contains("unknown")) {
                return false;
            } else {
                return true;
            }
        }

        return false;
    }

    private void setDisplaySettings() throws InvalidParameterException {
        if (this._parentContext != null && this._parentContext.get() != null) {
            TheoremReach.getInstance().setConnectionType(TheoremReach.getInstance().getParentContext());
        }

        String wifi = TheoremReach.getInstance().getConnectionType();
        if (wifi.equals("unknown")) {
            return;
        }

        if (TheoremReach.getInstance().getGpsId() == null) {
            if (this._parentContext != null && this._parentContext.get() != null) {
                String android_id = Settings.Secure.getString(_parentContext.get().getContentResolver(),
                        Settings.Secure.ANDROID_ID);
                TheoremReach.getInstance().setGpsId(android_id);
            }
        }

    }

    private void generateRewardCenterURL() {
        TheoremReach tr = TheoremReach.getInstance();
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(getUrlPrefix() + "sdk/v2/appuser_entry?gps_id=").append(tr.getGpsId());
        urlBuilder.append("&api_key=").append(tr.getApiKey());
        urlBuilder.append("&user_id=").append(tr.getUserID());

        if (TheoremReach.getInstance().resetProfiler) {
            urlBuilder.append("&reset_profiler=").append("true");
        }

        if (TheoremReach.getInstance().placementId != null && TheoremReach.getInstance().placementId.length() > 1) {
            urlBuilder.append("&placement_id=").append(TheoremReach.getInstance().placementId);
        }

        this._surveyUrl = urlBuilder.toString();

    }

    private void generateSurveyEntryURL() {
        this._surveyUrl = TheoremReach.getInstance().getMomentEntryURL();
    }

    public void unityEarnedReward(int quantity) {
        unityEarnedContent = quantity;
    }

    public void unityAwardNotification() {
        if (TheoremReach.getInstance()._unityObjectName != null && TheoremReach.getInstance().getUnityEarnedContent() > 0) {

            String quantity = TheoremReach.getInstance().getUnityEarnedContent() + "";
            com.unity3d.player.UnityPlayer.UnitySendMessage(TheoremReach.getInstance()._unityObjectName, "OnReward", quantity);

            TheoremReach.getInstance().setUnityEarnedContent(0);

            startUpdatePendingCoinsTask();
        }
    }

    public void awardContent(int quantity) {
        try {
            if (quantity > 0) {
                if (TheoremReach.getInstance()._rewardListener != null) {
                    TheoremReach.getInstance().getRewardListener().onReward(quantity);

                    startUpdatePendingCoinsTask();
                }

                if (TheoremReach.getInstance()._unityObjectName != null) {
                    TheoremReach.getInstance().unityEarnedReward(quantity);

                    if (TheoremReach.getInstance()._parentContext != null && TheoremReach.getInstance()._parentContext.get() != null) {
                        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences(TheoremReach.getInstance().getParentContext());

                        if (!(prefs.getBoolean("theoremReachActive", false))) {
                            unityAwardNotification();
                        }
                    }
                }
            }

        } catch (Exception e) {

        }
    }

    private void startGetAppuserTask() {
        new GetAppuserId().execute();
    }

    private static class GetAppuserId extends AsyncTask<Void, Void, Void> {
        protected Void doInBackground(Void... params) {
            try {

                new AppuserConnection().getAppuserId();

                TheoremReach.getInstance().fetchingAppuserId = false;

            } catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        @Override
        protected void onPostExecute(Void result) {
            if (TheoremReach.getInstance()._appuserId != null && TheoremReach.getInstance()._appuserId.length() > 1) {
                if (TheoremReach.getInstance()._parentContext != null && TheoremReach.getInstance()._parentContext.get() != null) {
                    SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences(TheoremReach.getInstance().getParentContext());
                    prefs.edit().putString("theoremReachAppuserId", TheoremReach.getInstance()._appuserId).apply();
                }

                if (!TheoremReach.getInstance().initialized) {
                    TheoremReach.getInstance().checkForEarnedContent();
                    TheoremReach.getInstance().initialized = true;
                }

                if (TheoremReach.getInstance().isMomentsEnabled() && !TheoremReach.getInstance().fetchingMomentSurvey && (TheoremReach.getInstance().momentsPollingFrequency >= 1) && TheoremReach.getInstance().getMomentEntryURL() == "") {
                    TheoremReach.getInstance().startMomentsTimer();
                }
            }
        }
    }

    private void checkForEarnedContent() {
        if (TheoremReach.getInstance().getAppuserId() == null || TheoremReach.getInstance()._appuserId.length() < 1 || TheoremReach.getInstance()._googleAdvertiserId == null) {
            TheoremReach.getInstance().setGoogleAdvertiserId();
            return;
        }
        startCheckForRewardsTask();
    }

    private void startCheckForRewardsTask() {
        new CheckAppuserRewards().execute();
    }

    private static class CheckAppuserRewards extends AsyncTask<Void, Void, Void> {
        protected Void doInBackground(Void... params) {
            try {

                new AppuserConnection().checkAppuserRewards();

                TheoremReach.getInstance().fetchingAppuserId = false;

            } catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }
    }

    void fetchSurveyEntryURL() {
        if (TheoremReach.getInstance().momentsPollingFrequency < 1) {
            return;
        }

        if (TheoremReach.getInstance().getAppuserId() == null || TheoremReach.getInstance()._googleAdvertiserId == null) {
            TheoremReach.getInstance().setGoogleAdvertiserId();
            return;
        }
        new FetchSurveyEntryURL().execute();
    }

    private static class FetchSurveyEntryURL extends AsyncTask<Void, Void, Void> {
        protected Void doInBackground(Void... params) {
            try {
                if (TheoremReach.getInstance().fetchingMomentSurvey) return null;

                TheoremReach.getInstance().momentSurveyAvailable = false;
                TheoremReach.getInstance().setMomentEntryURL("");

                TheoremReach.getInstance().fetchingMomentSurvey = true;
                new AppuserConnection().getMomentSurveyEntryURL();

            } catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        @Override
        protected void onPostExecute(Void result) {
            TheoremReach.getInstance().fetchingMomentSurvey = false;
            if (TheoremReach.getInstance().getMomentSurveyLength() > 0 && TheoremReach.getInstance().getMomentSurveyLength() < 31 && TheoremReach.getInstance().getMomentEntryURL() != null && TheoremReach.getInstance().getMomentEntryURL().length() > 10) {
                int length = TheoremReach.getInstance().getMomentSurveyLength();
                TheoremReach.getInstance().onMomentSurveyReceived(length);
                TheoremReach.getInstance().momentSurveyAvailable = true;
            }
        }
    }

    void fetchCloseButtonFromURL() {
        if (TheoremReach.getInstance().overrideCloseButtonURL == null) return;

        new FetchCloseButtonFromURL().execute();
    }

    private static class FetchCloseButtonFromURL extends AsyncTask<Void, Void, Void> {
        protected Void doInBackground(Void... params) {
            try {

                TheoremReach.getInstance().overrideCloseButton = new AppuserConnection().drawableFromUrl(TheoremReach.getInstance().overrideCloseButtonURL);

            } catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }
    }

    void fetchRefreshButtonFromURL() {
        if (TheoremReach.getInstance().overrideRefreshButtonURL == null) return;

        new FetchRefreshButtonFromURL().execute();
    }

    private static class FetchRefreshButtonFromURL extends AsyncTask<Void, Void, Void> {
        protected Void doInBackground(Void... params) {
            try {

                TheoremReach.getInstance().overrideRefreshButton = new AppuserConnection().drawableFromUrl(TheoremReach.getInstance().overrideRefreshButtonURL);

            } catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }
    }

    private static class GpsIdTask extends AsyncTask<Void, Void, String> {
        @Override protected String doInBackground(Void... params) {
            AdvertisingIdClient.Info idInfo = null;
            try {
                if (TheoremReach.getInstance()._parentContext != null && TheoremReach.getInstance()._parentContext.get() != null) {
                    idInfo = AdvertisingIdClient.getAdvertisingIdInfo(TheoremReach.getInstance().getParentContext());
                }
            } catch (GooglePlayServicesNotAvailableException e) {
                e.printStackTrace();
            } catch (GooglePlayServicesRepairableException e) {
                e.printStackTrace();
            } catch (IOException e) {
                e.printStackTrace();
            }
            String advertId = null;
            try{
                advertId = idInfo.getId();
            }catch (NullPointerException e){
                e.printStackTrace();
            }

            return advertId;
        }
        @Override
        protected void onPostExecute(String advertId) {

            if (advertId != null) {
                TheoremReach.getInstance()._googleAdvertiserId = advertId;
                TheoremReach.getInstance().startGetAppuserTask();
            } else {
                TheoremReach.getInstance().fetchingAppuserId = false;
            }
        }
    }

    private void startUpdatePendingCoinsTask() {
        new UpdatePendingCoins().execute();
    }

    private static class UpdatePendingCoins extends AsyncTask<Void, Void, Void> {

        @Override
        protected Void doInBackground(Void... params) {
            try {
                new AppuserConnection().grantUserReward();
            } catch (Exception e) {
                e.printStackTrace();

            }
            return null;
        }
    }

    private void startCreateSurveySessionTask() {
        new CreateSurveySession().execute();
    }

    private static class CreateSurveySession extends AsyncTask<Void, Void, Void> {

        @Override
        protected Void doInBackground(Void... params) {
            try {
                new AppuserConnection().createSurveySession();

            } catch (Exception e) {
                e.printStackTrace();

            }
            return null;
        }
    }

    public void resetProfiler(boolean resetProfiler) {
        TheoremReach.getInstance().resetProfiler = resetProfiler;
    }

    public void enableMoments(boolean momentEnabled) {

        TheoremReach.getInstance().momentsEnabled = momentEnabled;
        if (TheoremReach.getInstance().getAppuserId() != null && TheoremReach.getInstance().getAppuserId().length() > 0 && TheoremReach.getInstance().isSurveyAvailable() && (TheoremReach.getInstance().momentsPollingFrequency >= 1)) {
            fetchSurveyEntryURL();
        }
    }

    public void enableTitleBarInMoments(boolean enabled) {

        TheoremReach.getInstance().momentsTitleBarEnabled = enabled;
    }

    public void setTheoremReachRewardListener(TheoremReachRewardListener object)
    {
        this._rewardListener = object;
    }

    public void setTheoremReachSurveyListener(TheoremReachSurveyListener object)
    {
        this._surveyListener = object;
    }

    public void setTheoremReachSurveyAvailableListener(TheoremReachSurveyAvailableListener object)
    {
        this._surveyAvailableListener = object;
    }

    public void setTheoremReachMomentListener(TheoremReachMomentListener object)
    {
        this._momentListener = object;
    }

    private TheoremReachRewardListener getRewardListener() {
        return _rewardListener;
    }

    private TheoremReachSurveyListener getSurveyListener() {
        return _surveyListener;
    }

    private TheoremReachMomentListener getMomentListener() {
        return _momentListener;
    }

    private TheoremReachSurveyAvailableListener getSurveyAvailableListener() {
        return _surveyAvailableListener;
    }

    public void onRewardCenterOpened() {
        if (TheoremReach.getInstance()._surveyListener != null) {
            TheoremReach.getInstance().getSurveyListener().onRewardCenterOpened();
        }

        if (TheoremReach.getInstance()._unityObjectName != null) {
            com.unity3d.player.UnityPlayer.UnitySendMessage(TheoremReach.getInstance()._unityObjectName, "OnRewardCenterOpened", "");
        }
    }

    public void onMomentSurveyOpened() {
        if (TheoremReach.getInstance()._momentListener != null) {
            TheoremReach.getInstance().getMomentListener().onMomentSurveyOpened();
        }

        if (TheoremReach.getInstance()._unityObjectName != null) {
            com.unity3d.player.UnityPlayer.UnitySendMessage(TheoremReach.getInstance()._unityObjectName, "OnMomentSurveyOpened", "");
        }
    }

    public void onMomentSurveyClosed() {
        momentSurveyOpen = false;
        if (TheoremReach.getInstance()._momentListener != null) {
            TheoremReach.getInstance().getMomentListener().onMomentSurveyClosed();
        }

        if (TheoremReach.getInstance()._unityObjectName != null) {
            com.unity3d.player.UnityPlayer.UnitySendMessage(TheoremReach.getInstance()._unityObjectName, "OnMomentSurveyClosed", "");
        }
    }

    public void onMomentSurveyReceived(int surveyLength) {
        if (TheoremReach.getInstance()._momentListener != null) {
            TheoremReach.getInstance().getMomentListener().onMomentSurveyReceived(surveyLength);
        }

        if (TheoremReach.getInstance()._unityObjectName != null) {
            String length = surveyLength + "";
            com.unity3d.player.UnityPlayer.UnitySendMessage(TheoremReach.getInstance()._unityObjectName, "OnMomentSurveyReceived", length);
        }
    }

    public void onMomentSurveyCompleted() {
        if (TheoremReach.getInstance()._momentListener != null) {
            TheoremReach.getInstance().getMomentListener().onMomentSurveyCompleted();
        }

        if (TheoremReach.getInstance()._unityObjectName != null) {
            com.unity3d.player.UnityPlayer.UnitySendMessage(TheoremReach.getInstance()._unityObjectName, "OnMomentSurveyCompleted", "");
        }
    }
    public void onMomentSurveyNotEligible() {
        if (TheoremReach.getInstance()._momentListener != null) {
            TheoremReach.getInstance().getMomentListener().onMomentSurveyNotEligible();
        }

        if (TheoremReach.getInstance()._unityObjectName != null) {
            com.unity3d.player.UnityPlayer.UnitySendMessage(TheoremReach.getInstance()._unityObjectName, "OnMomentSurveyNotEligible", "");
        }
    }

    public void onRewardCenterClosed() {
        TheoremReach tr = TheoremReach.getInstance();

        tr.surveyAvailable = false;
        tr.placementId = "";

        checkForEarnedContent();

        if (tr._surveyListener != null) {
            tr.getSurveyListener().onRewardCenterClosed();
        }

        if (tr._unityObjectName != null) {
            com.unity3d.player.UnityPlayer.UnitySendMessage(tr._unityObjectName, "OnRewardCenterClosed", "");
        }

        startGetAppuserTask();
    }

    public String getConnectionType() {
        return _connectionType;
    }

    private String getMomentEntryURL() {
        return momentEntryURL;
    }

    public void setConnectionType(Activity context) {
        this._connectionType = ConnectionType.getTypeString(context);
    }

    public void setAppDevice() {
        this._appDevice = Build.BRAND + " " + Build.MODEL;
    }

    public void setCarrier(Activity context) {
        try {
            TelephonyManager telephonyManager = ((TelephonyManager) context.getSystemService(Context.TELEPHONY_SERVICE));
            if (telephonyManager != null && telephonyManager.getSimOperatorName() != null) {
                this._carrier = telephonyManager.getSimOperatorName();
            } else {
                this._carrier = "";
            }
        } catch (Exception e) {
            this._carrier = "";
        }
    }

    public void setOsVersion() {
        this._osVersion = String.valueOf(Build.VERSION.SDK_INT);
    }

    public Activity getParentContext() {
        return _parentContext.get();
    }

    public void setAppuserId(String appuserId)
    {
        this._appuserId = appuserId;
    }

    public String getAppuserId() {
        if (this._appuserId == null || this._appuserId.length() < 1) {
            if (TheoremReach.getInstance()._parentContext != null && TheoremReach.getInstance()._parentContext.get() != null) {
                SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences(TheoremReach.getInstance().getParentContext());

                return prefs.getString("theoremReachAppuserId", null);
            }
        }

        return this._appuserId;
    }

    public int getUnityEarnedContent() {
        return TheoremReach.getInstance().unityEarnedContent;
    }

    private void setUnityEarnedContent(int content) {
        TheoremReach.getInstance().unityEarnedContent = content;
    }

    protected void setRewardIds(String rewardIds) {
        TheoremReach.getInstance().rewardIds = rewardIds;
    }

    public String getRewardIds() {
        return TheoremReach.getInstance().rewardIds;
    }

    public void setMomentSurveyLength(int minLength) {
        TheoremReach.getInstance().momentSurveyLength = minLength;
    }

    public void setMomentEntryURL(String momentEntryURL) {
        TheoremReach.getInstance().momentEntryURL = momentEntryURL;
    }

    public void setSurveyAvailable(boolean surveyAvailable) {
        TheoremReach.getInstance().surveyAvailable = surveyAvailable;

        if (TheoremReach.getInstance()._surveyAvailableListener != null) {
            TheoremReach.getInstance().getSurveyAvailableListener().theoremreachSurveyAvailable(surveyAvailable);
        }

        if (TheoremReach.getInstance()._unityObjectName != null) {
            com.unity3d.player.UnityPlayer.UnitySendMessage(TheoremReach.getInstance()._unityObjectName, "TheoremReachSurveyAvailable", "" + surveyAvailable);
        }
    }

    public void setIsProfiled(boolean isProfiled) {
        TheoremReach.getInstance().isProfiled = isProfiled;
    }

    private void setGpsId(String android_id)
    {
        if (this._googleAdvertiserId == null) {
            this._googleAdvertiserId = android_id;
        }
    }

    public void setNavigationBarColor(String colorHexCode) {
        this.navigationBarColor = colorHexCode;
    }

    public String getNavigationBarColor() {
        return this.navigationBarColor;
    }

    public void setNavigationBarTextColor(String colorHexCode) {
        this.navigationBarTextColor = colorHexCode;
    }

    public String getNavigationBarTextColor() {
        return this.navigationBarTextColor;
    }

    public void setNavigationBarText(String navigationBarText) {
        this.navigationBarText = navigationBarText;
    }

    public String getNavigationBarText() {
        return this.navigationBarText;
    }

    public void setOverrideCloseButtonURL(String overrideCloseButtonURL) {
        this.overrideCloseButtonURL = overrideCloseButtonURL;
        fetchCloseButtonFromURL();
    }

    public Drawable getOverrideCloseButton() {
        return this.overrideCloseButton;
    }

    public String getOverrideCloseButtonURL() {
        return this.overrideCloseButtonURL;
    }

    public void setOverrideRefreshButtonURL(String overrideRefreshButtonURL) {
        this.overrideRefreshButtonURL = overrideRefreshButtonURL;
        fetchRefreshButtonFromURL();
    }

    public Drawable getOverrideRefreshButton() {
        return this.overrideRefreshButton;
    }

    public String getOverrideRefreshButtonURL() {
        return this.overrideRefreshButtonURL;
    }

    public void setApiKey(String key)
    {
        this._apiKey = key;
    }

    public void setParentActivityContext(Activity key)
    {
        this._parentContext = new WeakReference<Activity>(key);
    }

    public void setUserId(String key)
    {
        this._userId = key;
    }

    public String getSurveyUrl()
    {
        return this._surveyUrl;
    }

    public String getUserID()
    {
        return this._userId;
    }

    public String getCarrier()
    {
        return this._carrier;
    }

    public String getOsVersion()
    {
        return this._osVersion;
    }

    public String getAppDevice()
    {
        return this._appDevice;
    }

    private String getUrlPrefix() {
        return  "https://theoremreach.com/";
    }

    public void setUnityObjectName(String objectName) {
        TheoremReach.getInstance()._unityObjectName = objectName;
    }

    public String getApiKey() {
        return _apiKey;
    }

    public String getGpsId() {
        return _googleAdvertiserId;
    }

    public boolean isSurveyAvailable() {
        if (TheoremReach.getInstance().getAppuserId() == null || TheoremReach.getInstance()._googleAdvertiserId == null) {
            TheoremReach.getInstance().setGoogleAdvertiserId();
            return false;
        }

        return TheoremReach.getInstance().surveyAvailable;
    }

    private int getMomentSurveyLength() {
        return TheoremReach.getInstance().momentSurveyLength;
    }

    public boolean isProfiled() {
        return TheoremReach.getInstance().isProfiled;
    }

    public boolean isMomentsEnabled() {
        return TheoremReach.getInstance().momentsEnabled;
    }

    public boolean isMomentsTitleBarEnabled() {
        return TheoremReach.getInstance().momentsTitleBarEnabled;
    }

    public void setMomentsSurveyPollingFrequency(int momentsPollingFrequency) {
        TheoremReach.getInstance().momentsPollingFrequency = momentsPollingFrequency;
    }

    private int getMomentsPollingFrequency() {
        return TheoremReach.getInstance().momentsPollingFrequency * 60 * 1000;
    }

    public boolean isSurveyAvailable(int maxLength) {
        TheoremReach tr = TheoremReach.getInstance();
        return tr.isSurveyAvailable() && tr.momentSurveyAvailable && tr.getMomentSurveyLength() <= maxLength;
    }

    public static boolean unityIsSurveyAvailable() {
        return TheoremReach.getInstance().isSurveyAvailable();
    }

    public static boolean unityIsProfiled() {
        return TheoremReach.getInstance().isProfiled();
    }

    public void setUnityGame(boolean unity) {
        TheoremReach.getInstance().unity = unity;
    }

    public boolean isUnity() {
        return TheoremReach.getInstance().unity;
    }

    public static boolean isKindleFire() {
        return android.os.Build.MANUFACTURER.equals("Amazon") && (android.os.Build.MODEL.equals("Kindle Fire") || android.os.Build.MODEL.startsWith("KF"));
    }
}
