/*
 * Decompiled with CFR 0.152.
 */
package com.theomota.tmimageview;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import android.widget.ImageView;
import com.theomota.tmimageview.R;
import com.theomota.tmimageview.ReverseInterpolator;

public class TmImageView
extends ImageView
implements View.OnClickListener {
    private View.OnClickListener clickListener;
    private Context context;
    private int animation_ref = R.anim.scale_up;

    public TmImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setOnClickListener(this);
        this.context = context;
    }

    public TmImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setOnClickListener(this);
        this.context = context;
        for (int i = 0; i < attrs.getAttributeCount(); ++i) {
            if (!attrs.getAttributeName(i).equals("animation")) continue;
            try {
                String anim2 = attrs.getAttributeValue(i);
                this.animation_ref = Integer.valueOf(anim2.replace("@", ""));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public TmImageView(Context context) {
        super(context);
        this.setOnClickListener(this);
        this.context = context;
    }

    public void setOnClickListener(View.OnClickListener l) {
        if (l == this) {
            super.setOnClickListener(l);
        } else {
            this.clickListener = l;
        }
    }

    public void onClick(View view) {
        if (this.clickListener != null) {
            this.clickListener.onClick((View)this);
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        Animation anim2 = AnimationUtils.loadAnimation((Context)this.context, (int)this.animation_ref);
        anim2.setFillAfter(true);
        if (event.getAction() == 0) {
            this.startAnimation(anim2);
        } else if (event.getAction() == 1) {
            anim2.setInterpolator((Interpolator)new ReverseInterpolator());
            this.startAnimation(anim2);
        }
        return super.onTouchEvent(event);
    }
}

