/*
 * Decompiled with CFR 0.152.
 */
package com.thelastcheck.io.base;

import com.google.common.base.Throwables;
import com.thelastcheck.commons.base.exception.InvalidDataException;
import com.thelastcheck.commons.base.fields.OnUsField;
import com.thelastcheck.commons.base.fields.RoutingNumber;
import com.thelastcheck.commons.base.utils.ToXmlBuilder;
import com.thelastcheck.commons.buffer.ByteArray;
import com.thelastcheck.io.base.Field;
import com.thelastcheck.io.base.Record;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public abstract class RecordImpl
implements Record,
Cloneable {
    private ByteArray record;
    private int recordPosition;
    private long offsetPosition;
    protected static final String INVALID_FIELD_NUMBER = "Invalid Field Number";

    public RecordImpl() {
    }

    public RecordImpl(int recordLength, String encoding) {
        this.record = new ByteArray(recordLength, encoding);
    }

    public RecordImpl(ByteArray record) {
        this.record = record;
    }

    @Override
    public Object clone() {
        try {
            RecordImpl object = (RecordImpl)super.clone();
            object.record = (ByteArray)this.record.clone();
            return object;
        }
        catch (CloneNotSupportedException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public Object duplicate() {
        try {
            RecordImpl object = (RecordImpl)super.clone();
            object.record = new ByteArray(this.record);
            return object;
        }
        catch (CloneNotSupportedException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public Object getField(int fieldNumber) throws InvalidDataException {
        return this.getField(this.field(fieldNumber));
    }

    @Override
    public Record setField(String value, int fieldNumber) {
        this.setField(value, this.field(fieldNumber));
        return this;
    }

    @Override
    public Record setField(long value, int fieldNumber) {
        this.setField(value, this.field(fieldNumber));
        return this;
    }

    @Override
    public Record setField(int value, int fieldNumber) {
        this.setField(value, this.field(fieldNumber));
        return this;
    }

    @Override
    public String fieldName(int fieldNumber) {
        return this.field(fieldNumber).name();
    }

    protected Object getField(Field field) throws InvalidDataException {
        return field.extract(this.record);
    }

    protected String getFieldAsString(Field field) {
        return field.extractAsString(this.record);
    }

    protected RoutingNumber getFieldAsRoutingNumber(Field field) {
        return field.extractStringAsRoutingNumber(this.record);
    }

    protected OnUsField getFieldAsOnUsField(Field field) {
        return field.extractStringAsOnUsField(this.record);
    }

    protected ByteArray getFieldAsByteArray(Field field) {
        return field.extractAsByteArray(this.record);
    }

    protected Date getFieldAsDate(Field field) throws InvalidDataException {
        return field.extractStringAsDate(this.record);
    }

    protected Date getFieldAsDate(Field field, TimeZone zone) throws InvalidDataException {
        return field.extractStringAsDate(this.record, zone);
    }

    protected Date getFieldAsTime(Field field) throws InvalidDataException {
        return field.extractStringAsTime(this.record);
    }

    protected Date getFieldAsTime(Field field, TimeZone zone) throws InvalidDataException {
        return field.extractStringAsTime(this.record, zone);
    }

    protected long getFieldAsLong(Field field) throws InvalidDataException {
        return field.extractStringAsLong(this.record);
    }

    protected int getFieldAsInt(Field field) throws InvalidDataException {
        return field.extractStringAsInt(this.record);
    }

    protected void setField(String value, Field field) {
        field.insert(value, this.record);
    }

    protected void setFieldRight(String value, Field field) {
        field.insertRight(value, this.record);
    }

    protected void setField(ByteArray value, Field field) {
        field.insert(value, this.record);
    }

    protected void setFieldDate(Date value, Field field) {
        field.insertDate(value, this.record);
    }

    protected void setFieldDate(Date value, Field field, TimeZone zone) {
        field.insertDate(value, this.record, zone);
    }

    protected void setFieldTime(Date value, Field field) {
        field.insertTime(value, this.record);
    }

    protected void setFieldTime(Date value, Field field, TimeZone zone) {
        field.insertTime(value, this.record, zone);
    }

    protected void setField(RoutingNumber value, Field field) {
        field.insert(value, this.record);
    }

    protected void setField(OnUsField value, Field field) {
        field.insert(value, this.record);
    }

    protected void setField(long value, Field field) {
        field.insertAsString(value, this.record);
    }

    protected void setField(int value, Field field) {
        field.insertAsString(value, this.record);
    }

    protected void allocateNewRecord(int currentLength, int newLength, int replaceLengthField, int replacedField) {
        Field field;
        int i;
        ByteArray currentRecord = this.record();
        ByteArray newRecord = new ByteArray(currentRecord.getLength() - currentLength + newLength, currentRecord.getEncoding());
        ByteArray[] currentValues = new ByteArray[this.numberOfFields() + 1];
        for (i = 1; i <= this.numberOfFields(); ++i) {
            field = this.field(i);
            if (i == replacedField) continue;
            currentValues[i] = field.extractAsByteArray(currentRecord);
        }
        this.record(newRecord);
        this.resetDynamicFields();
        for (i = 1; i <= this.numberOfFields(); ++i) {
            field = this.field(i);
            if (i == replacedField) continue;
            if (i == replaceLengthField) {
                field.insertAsString(newLength, newRecord);
                continue;
            }
            field.insert(currentValues[i], newRecord);
        }
    }

    @Override
    public int length() {
        return this.record.getLength();
    }

    @Override
    public ByteArray record() {
        return this.record;
    }

    protected void record(ByteArray record) {
        this.record = record;
    }

    @Override
    public int recordPosition() {
        return this.recordPosition;
    }

    @Override
    public Record recordPosition(int position) {
        this.recordPosition = position;
        return this;
    }

    @Override
    public long offsetPosition() {
        return this.offsetPosition;
    }

    @Override
    public Record offsetPosition(long offset) {
        this.offsetPosition = offset;
        return this;
    }

    @Override
    public abstract int numberOfFields();

    protected abstract Field field(int var1);

    protected abstract void resetDynamicFields();

    public String toString() {
        ToStringStyle style = ToStringStyle.MULTI_LINE_STYLE;
        ToStringBuilder sb = new ToStringBuilder((Object)this, style);
        sb.append("position", this.recordPosition);
        sb.append("offset", this.offsetPosition);
        int maxFields = this.numberOfFields();
        for (int fieldNumber = 1; fieldNumber <= maxFields; ++fieldNumber) {
            Field field = this.field(fieldNumber);
            field.formatToString(this.record, sb);
        }
        return sb.toString();
    }

    @Override
    public String toXml() {
        return this.toXml(true);
    }

    @Override
    public String toXml(boolean useAttributes) {
        String recordName = this.getClass().getSimpleName();
        int pos = recordName.lastIndexOf("Impl");
        if (pos != -1) {
            recordName = recordName.substring(0, pos);
        }
        ToXmlBuilder xb = new ToXmlBuilder(recordName, useAttributes, 512);
        int maxFields = this.numberOfFields();
        for (int fieldNumber = 1; fieldNumber <= maxFields; ++fieldNumber) {
            Field field = this.field(fieldNumber);
            field.formatToXml(this.record, xb);
        }
        return xb.toString();
    }
}

