/*
 * Decompiled with CFR 0.152.
 */
package com.thelastcheck.io.base;

import com.thelastcheck.commons.buffer.ByteArray;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class RandomAccessFileRecordReader {
    private RandomAccessFile raf;
    private byte[] maxBuffer;

    public RandomAccessFileRecordReader(File file) throws FileNotFoundException {
        this.raf = new RandomAccessFile(file, "r");
    }

    public void close() throws IOException {
        if (this.raf != null) {
            this.raf.close();
            this.raf = null;
        }
    }

    protected boolean isStreamAvailable() throws IOException {
        return this.raf != null;
    }

    protected void seek(long pos) throws IOException {
        this.raf.seek(pos);
    }

    protected int read(ByteArray record) throws IOException {
        return this.read(record, 0, record.getLength());
    }

    protected int read(ByteArray record, int displacement, int length) throws IOException {
        int count;
        if (record.hasArray()) {
            ByteArray.UnderlyingArray array = record.getArray();
            count = this.read(array.value, array.offset + displacement, length);
        } else {
            byte[] buffer = this.getBuffer(length);
            count = this.read(buffer, 0, length);
            record.write(buffer, 0, count, displacement);
        }
        return count;
    }

    private byte[] getBuffer(int size) {
        if (this.maxBuffer == null || this.maxBuffer.length < size) {
            this.maxBuffer = new byte[size];
        }
        return this.maxBuffer;
    }

    private int read(byte[] data, int displacement, int length) throws IOException {
        int bytesRead;
        int totalBytesRead = 0;
        int bytesRemaining = length;
        int currentDisplacement = displacement;
        while (bytesRemaining > 0 && (bytesRead = this.raf.read(data, currentDisplacement, bytesRemaining)) != -1) {
            bytesRemaining -= bytesRead;
            currentDisplacement += bytesRead;
            totalBytesRead += bytesRead;
        }
        return totalBytesRead;
    }
}

