/*
 * Decompiled with CFR 0.152.
 */
package com.thelastcheck.io.base;

import com.thelastcheck.commons.buffer.ByteArray;
import com.thelastcheck.io.base.Record;
import com.thelastcheck.io.base.RecordFilter;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public abstract class OutputStreamRecordWriter
implements Closeable {
    private OutputStream os;
    private List<RecordFilter> filterList = new ArrayList<RecordFilter>();
    private byte[] maxBuffer;

    public OutputStreamRecordWriter(OutputStream os) {
        this.os = os;
    }

    @Override
    public void close() throws IOException {
        if (this.os != null) {
            this.os.close();
            this.os = null;
        }
    }

    public void write(Record record) throws IOException {
        if (this.os == null) {
            throw new IllegalStateException("Stream is not open or available for writing");
        }
        if ((record = this.processFilters(record)) != null) {
            this.writeRecord(record);
        }
    }

    protected final void write(ByteArray byteArray) throws IOException {
        this.write(byteArray, 0, byteArray.getLength());
    }

    protected final void write(ByteArray byteArray, int offset, int length) throws IOException {
        if (byteArray.hasArray()) {
            ByteArray.UnderlyingArray array = byteArray.getArray();
            this.write(array.value, array.offset + offset, length);
        } else {
            byte[] buffer = this.getBuffer(length);
            byteArray.read(offset, buffer, 0, length);
            this.write(buffer);
        }
    }

    private byte[] getBuffer(int size) {
        if (this.maxBuffer == null || this.maxBuffer.length < size) {
            this.maxBuffer = new byte[size];
        }
        return this.maxBuffer;
    }

    protected final void write(byte[] bytes) throws IOException {
        this.os.write(bytes);
    }

    protected final void write(byte[] bytes, int offset, int length) throws IOException {
        this.os.write(bytes, offset, length);
    }

    private Record processFilters(Record record) {
        for (RecordFilter filter : this.filterList) {
            record = filter.filter(record);
            if (record != null) continue;
            return null;
        }
        return record;
    }

    public void addFilter(RecordFilter inputStreamFilter) {
        this.filterList.add(inputStreamFilter);
    }

    protected abstract void writeRecord(Record var1) throws IOException;
}

