/*
 * Decompiled with CFR 0.152.
 */
package com.thelastcheck.io.base;

import com.thelastcheck.commons.buffer.ByteArray;
import com.thelastcheck.io.base.Record;
import com.thelastcheck.io.base.RecordFilter;
import com.thelastcheck.io.base.exception.InvalidFormatException;
import com.thelastcheck.io.base.exception.RecordReaderException;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public abstract class InputStreamRecordReader
implements Iterable<Record>,
Closeable {
    protected static final String US_ASCII = "US-ASCII";
    protected static final String EBCDIC = "IBM1047";
    protected static final String END_OF_STREAM_ERROR = "End of stream reached before finished processing expected data.";
    private InputStream is;
    private List<RecordFilter> filterList = new ArrayList<RecordFilter>();
    private Record cachedRecord;
    private int recordCount;
    private long offset;
    private long bytesReadForRecord;
    private boolean skipInvalidRecords;
    private byte[] maxBuffer;

    public InputStreamRecordReader(InputStream is) {
        this(is, false);
    }

    public InputStreamRecordReader(InputStream is, boolean skipInvalidRecords) {
        this.is = is;
        this.skipInvalidRecords = skipInvalidRecords;
    }

    @Override
    public void close() throws IOException {
        if (this.is != null) {
            this.is.close();
            this.is = null;
        }
    }

    public boolean isSkipInvalidRecords() {
        return this.skipInvalidRecords;
    }

    public void setSkipInvalidRecords(boolean skipInvalidRecords) {
        this.skipInvalidRecords = skipInvalidRecords;
    }

    protected final boolean isStreamAvailable() throws IOException {
        return this.is != null && this.is.available() != 0;
    }

    protected final int read(ByteArray record) throws IOException {
        return this.read(record, 0, record.getLength());
    }

    protected final int read(ByteArray record, int displacement, int length) throws IOException {
        int count;
        if (record.hasArray()) {
            ByteArray.UnderlyingArray array = record.getArray();
            count = this.read(array.value, array.offset + displacement, length);
        } else {
            byte[] buffer = this.getBuffer(length);
            count = this.read(buffer, 0, length);
            record.write(buffer, 0, count, displacement);
        }
        return count;
    }

    private byte[] getBuffer(int size) {
        if (this.maxBuffer == null || this.maxBuffer.length < size) {
            this.maxBuffer = new byte[size];
        }
        return this.maxBuffer;
    }

    private int read(byte[] data, int displacement, int length) throws IOException {
        int bytesRead;
        int totalBytesRead = 0;
        int bytesRemaining = length;
        int currentDisplacement = displacement;
        while (bytesRemaining > 0 && (bytesRead = this.is.read(data, currentDisplacement, bytesRemaining)) != -1) {
            bytesRemaining -= bytesRead;
            currentDisplacement += bytesRead;
            totalBytesRead += bytesRead;
        }
        this.bytesReadForRecord += (long)totalBytesRead;
        return totalBytesRead;
    }

    private Record processFilters(Record record) {
        for (RecordFilter filter : this.filterList) {
            record = filter.filter(record);
            if (record != null) continue;
            return null;
        }
        return record;
    }

    public void addFilter(RecordFilter recordFilter) {
        this.filterList.add(recordFilter);
    }

    public Record nextRecord() throws IOException {
        if (this.cachedRecord != null) {
            Record record = this.cachedRecord;
            this.cachedRecord = null;
            return record;
        }
        Record record = null;
        do {
            if (!this.isStreamAvailable()) {
                return null;
            }
            try {
                this.bytesReadForRecord = 0L;
                record = this.readNextRecord();
                record.recordPosition(++this.recordCount);
                record.offsetPosition(this.offset);
                this.offset += this.bytesReadForRecord;
                record = this.processFilters(record);
            }
            catch (InvalidFormatException e) {
                if (!this.skipInvalidRecords) {
                    throw e;
                }
                ++this.recordCount;
                this.offset += this.bytesReadForRecord;
            }
        } while (record == null);
        return record;
    }

    protected abstract Record readNextRecord() throws IOException;

    @Override
    public Iterator<Record> iterator() {
        return new Iterator<Record>(){

            @Override
            public boolean hasNext() {
                if (InputStreamRecordReader.this.cachedRecord != null) {
                    return true;
                }
                try {
                    InputStreamRecordReader.this.cachedRecord = InputStreamRecordReader.this.nextRecord();
                    if (InputStreamRecordReader.this.cachedRecord == null) {
                        return false;
                    }
                }
                catch (Exception e) {
                    throw new RecordReaderException(e);
                }
                return true;
            }

            @Override
            public Record next() {
                Record record;
                try {
                    record = InputStreamRecordReader.this.nextRecord();
                }
                catch (Exception e) {
                    throw new RecordReaderException(e);
                }
                if (record == null) {
                    throw new NoSuchElementException();
                }
                return record;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

