/*
 * Decompiled with CFR 0.152.
 */
package com.thelastcheck.io.base;

import com.thelastcheck.commons.base.exception.InvalidDataException;
import com.thelastcheck.commons.base.fields.OnUsField;
import com.thelastcheck.commons.base.fields.RoutingNumber;
import com.thelastcheck.commons.base.utils.ToXmlBuilder;
import com.thelastcheck.commons.buffer.ByteArray;
import com.thelastcheck.io.base.FieldType;
import com.thelastcheck.io.base.exception.InvalidLengthException;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class Field {
    private static final String SPACES_80 = "                                                                                ";
    private int offset;
    private int length;
    private FieldType type;
    private String name;
    private int number;
    private static Map<String, DateFormat> dateFormatterMap = Collections.synchronizedMap(new HashMap());
    private static Map<String, DateFormat> timeFormatterHHmmssMap = Collections.synchronizedMap(new HashMap());
    private static Map<String, DateFormat> timeFormatterHHmmMap = Collections.synchronizedMap(new HashMap());
    private static NumberFormat numberFormatter = NumberFormat.getInstance();
    protected static SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd");
    protected static SimpleDateFormat sdfTime = new SimpleDateFormat("HH:mm:ss");

    public Field() {
    }

    public Field(int offset, int length) {
        this.offset = offset;
        this.length = length;
        this.type = FieldType.STRING;
    }

    public Field(int offset, int length, FieldType type) {
        this.offset = offset;
        this.length = length;
        this.type = type;
    }

    public Field(String fieldName, int fieldNumber, int offset, int length) {
        this(offset, length);
        this.name = fieldName;
        this.number = fieldNumber;
    }

    public Field(String fieldName, int fieldNumber, int offset, int length, FieldType type) {
        this(offset, length, type);
        this.name = fieldName;
        this.number = fieldNumber;
    }

    public boolean isType(FieldType type) {
        return type.equals((Object)this.type);
    }

    public FieldType type() {
        return this.type;
    }

    public Object extract(ByteArray record) throws InvalidDataException {
        Object value = null;
        switch (this.type) {
            case STRING: {
                value = this.extractAsString(record);
                break;
            }
            case BINARY: {
                value = this.extractAsByteArray(record);
                break;
            }
            case INT: {
                value = this.extractStringAsInt(record);
                break;
            }
            case LONG: {
                value = this.extractStringAsLong(record);
                break;
            }
            case DATE: {
                value = this.extractStringAsDate(record);
                break;
            }
            case TIME: {
                value = this.extractStringAsTime(record);
                break;
            }
            case ROUTING_NUMBER: {
                value = new RoutingNumber(this.extractAsString(record));
                break;
            }
            case ONUS: {
                value = new OnUsField(this.extractAsString(record));
            }
        }
        return value;
    }

    public byte[] extractAsBytes(ByteArray record) {
        return record.read(this.offset, this.length);
    }

    public ByteArray extractAsByteArray(ByteArray record) {
        return record.readAsByteArray(this.offset, this.length);
    }

    public String extractAsString(ByteArray record) {
        return record.readAsString(this.offset, this.length);
    }

    public long extractStringAsLong(ByteArray record) throws InvalidDataException {
        String s = this.extractAsString(record).trim();
        long value = 0L;
        if (s.length() > 0) {
            try {
                value = Long.parseLong(s);
            }
            catch (NumberFormatException e) {
                throw new InvalidDataException((Throwable)e);
            }
        }
        return value;
    }

    public int extractStringAsInt(ByteArray record) throws InvalidDataException {
        String s = this.extractAsString(record).trim();
        int value = 0;
        if (s.length() > 0) {
            try {
                value = Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                throw new InvalidDataException((Throwable)e);
            }
        }
        return value;
    }

    public long extractAsLong(ByteArray record) {
        long value;
        switch (this.length) {
            case 8: {
                value = record.readAsLong(this.offset);
                break;
            }
            case 4: {
                value = record.readAsInt(this.offset);
                break;
            }
            case 2: {
                value = record.readAsShort(this.offset);
                break;
            }
            case 1: {
                value = record.readAsByte(this.offset);
                break;
            }
            default: {
                throw new InvalidLengthException();
            }
        }
        return value;
    }

    public byte extractAsByte(ByteArray record) {
        byte value;
        switch (this.length) {
            case 1: {
                value = record.readAsByte(this.offset);
                break;
            }
            case 2: {
                value = (byte)record.readAsShort(this.offset);
                break;
            }
            case 4: {
                value = (byte)record.readAsInt(this.offset);
                break;
            }
            case 8: {
                value = (byte)record.readAsLong(this.offset);
                break;
            }
            default: {
                throw new InvalidLengthException();
            }
        }
        return value;
    }

    public short extractAsShort(ByteArray record) {
        short value;
        switch (this.length) {
            case 2: {
                value = record.readAsShort(this.offset);
                break;
            }
            case 1: {
                value = record.readAsByte(this.offset);
                break;
            }
            case 4: {
                value = (short)record.readAsInt(this.offset);
                break;
            }
            case 8: {
                value = (short)record.readAsLong(this.offset);
                break;
            }
            default: {
                throw new InvalidLengthException();
            }
        }
        return value;
    }

    public int extractAsInt(ByteArray record) {
        int value;
        switch (this.length) {
            case 4: {
                value = record.readAsInt(this.offset);
                break;
            }
            case 2: {
                value = record.readAsShort(this.offset);
                break;
            }
            case 1: {
                value = record.readAsByte(this.offset);
                break;
            }
            case 8: {
                value = (int)record.readAsLong(this.offset);
                break;
            }
            default: {
                throw new InvalidLengthException();
            }
        }
        return value;
    }

    public String extractPnsAsString(ByteArray record) {
        return record.readPns(this.offset, this.length);
    }

    public Date extractStringAsDate(ByteArray record) throws InvalidDataException {
        return this.extractStringAsDate(record, null);
    }

    public Date extractStringAsDate(ByteArray record, TimeZone zone) throws InvalidDataException {
        String date = this.extractAsString(record);
        if (date.length() != 8) {
            throw new InvalidDataException("Date field must be 8 characters in length");
        }
        DateFormat format = this.dateFormatForZone(zone);
        return this.formatDateTime(date, format);
    }

    public Date extractStringAsTime(ByteArray record) throws InvalidDataException {
        return this.extractStringAsTime(record, null);
    }

    public Date extractStringAsTime(ByteArray record, TimeZone zone) throws InvalidDataException {
        String time = this.extractAsString(record);
        if (time.length() != 4 && time.length() != 6) {
            throw new InvalidDataException("Time field must be 4 or 6 characters in length");
        }
        DateFormat format = time.length() == 4 ? this.timeFormatHHmmForZone(zone) : this.timeFormatHHmmssForZone(zone);
        return this.formatDateTime(time, format);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Date formatDateTime(String time, DateFormat format) throws InvalidDataException {
        Date value = null;
        if (time.trim().length() > 0) {
            DateFormat dateFormat = format;
            synchronized (dateFormat) {
                try {
                    value = format.parse(time);
                }
                catch (ParseException e) {
                    throw new InvalidDataException((Throwable)e);
                }
            }
        }
        return value;
    }

    public RoutingNumber extractStringAsRoutingNumber(ByteArray record) {
        String s = this.extractAsString(record).trim();
        return new RoutingNumber(s);
    }

    public OnUsField extractStringAsOnUsField(ByteArray record) {
        String s = this.extractAsString(record).trim();
        return new OnUsField(s);
    }

    public void insert(byte[] value, ByteArray record) {
        record.write(value, 0, this.length, this.offset);
    }

    public void insert(ByteArray value, ByteArray record) {
        record.write(value, this.offset, this.length);
    }

    public void insert(String value, ByteArray record) {
        record.write(value, this.offset, this.length, false);
    }

    public void insertRight(String value, ByteArray record) {
        if (value.length() > this.length) {
            value = value.substring(value.length() - this.length);
        }
        while (value.length() < this.length) {
            if (this.length - value.length() > 80) {
                value = SPACES_80 + value;
                continue;
            }
            value = SPACES_80.substring(0, this.length - value.length()) + value;
        }
        record.write(value, this.offset, this.length, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertAsString(long value, ByteArray record) {
        String s;
        NumberFormat numberFormat = numberFormatter;
        synchronized (numberFormat) {
            numberFormatter.setGroupingUsed(false);
            numberFormatter.setMinimumIntegerDigits(this.length);
            s = numberFormatter.format(value);
        }
        this.insert(s, record);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertAsString(int value, ByteArray record) {
        String s;
        NumberFormat numberFormat = numberFormatter;
        synchronized (numberFormat) {
            numberFormatter.setGroupingUsed(false);
            numberFormatter.setMinimumIntegerDigits(this.length);
            s = numberFormatter.format(value);
        }
        this.insert(s, record);
    }

    public void insert(byte value, ByteArray record) {
        switch (this.length) {
            case 1: {
                record.write(value, this.offset);
                break;
            }
            case 2: {
                record.write((short)value, this.offset);
                break;
            }
            case 4: {
                record.write((int)value, this.offset);
                break;
            }
            default: {
                throw new InvalidLengthException();
            }
        }
    }

    public void insert(short value, ByteArray record) {
        switch (this.length) {
            case 2: {
                record.write(value, this.offset);
                break;
            }
            case 1: {
                record.write((byte)value, this.offset);
                break;
            }
            case 4: {
                record.write((int)value, this.offset);
                break;
            }
            default: {
                throw new InvalidLengthException();
            }
        }
    }

    public void insert(int value, ByteArray record) {
        switch (this.length) {
            case 4: {
                record.write(value, this.offset);
                break;
            }
            case 2: {
                record.write((short)value, this.offset);
                break;
            }
            case 1: {
                record.write((byte)value, this.offset);
                break;
            }
            default: {
                throw new InvalidLengthException();
            }
        }
    }

    public void insert(long value, ByteArray record) {
        switch (this.length) {
            case 8: {
                record.write(value, this.offset);
                break;
            }
            case 4: {
                record.write((int)value, this.offset);
                break;
            }
            case 2: {
                record.write((short)value, this.offset);
                break;
            }
            case 1: {
                record.write((byte)value, this.offset);
                break;
            }
            default: {
                throw new InvalidLengthException();
            }
        }
    }

    public void insertDate(Date value, ByteArray record) {
        this.insertDate(value, record, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertDate(Date value, ByteArray record, TimeZone zone) {
        String date;
        DateFormat df;
        DateFormat dateFormat = df = this.dateFormatForZone(zone);
        synchronized (dateFormat) {
            date = df.format(value);
        }
        this.insert(date, record);
    }

    public void insertTime(Date value, ByteArray record) {
        this.insertTime(value, record, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertTime(Date value, ByteArray record, TimeZone zone) {
        String time;
        DateFormat df = this.length == 4 ? this.timeFormatHHmmForZone(zone) : this.timeFormatHHmmssForZone(zone);
        DateFormat dateFormat = df;
        synchronized (dateFormat) {
            time = df.format(value);
        }
        this.insert(time, record);
    }

    private DateFormat dateFormatForZone(TimeZone zone) {
        return this.formatForZone(dateFormatterMap, "yyyyMMdd", zone);
    }

    private DateFormat timeFormatHHmmssForZone(TimeZone zone) {
        return this.formatForZone(timeFormatterHHmmssMap, "HHmmss", zone);
    }

    private DateFormat timeFormatHHmmForZone(TimeZone zone) {
        return this.formatForZone(timeFormatterHHmmMap, "HHmm", zone);
    }

    private DateFormat formatForZone(Map<String, DateFormat> map, String format, TimeZone zone) {
        DateFormat df = zone == null ? map.get(null) : map.get(zone.getID());
        if (df == null) {
            df = new SimpleDateFormat(format);
            if (zone == null) {
                map.put(null, df);
            } else {
                Calendar cal = Calendar.getInstance(zone);
                df.setCalendar(cal);
                map.put(zone.getID(), df);
            }
        }
        return df;
    }

    public void insert(RoutingNumber value, ByteArray record) {
        record.write(value.toString(), this.offset, this.length, false);
    }

    public void insert(OnUsField value, ByteArray record) {
        record.write(value.toString(), this.offset, this.length, false);
    }

    public void insertPns(String value, ByteArray record) {
        record.writeAsPns(value, this.offset, this.length);
    }

    public void setBit(byte mask, ByteArray record) {
        record.setBit(this.offset, mask);
    }

    public void clearBit(byte mask, ByteArray record) {
        record.clearBit(this.offset, mask);
    }

    public boolean testBit(byte mask, ByteArray record) {
        return record.testBit(this.offset, mask);
    }

    public String name() {
        return this.name;
    }

    public String toString() {
        ToStringBuilder sb = new ToStringBuilder((Object)this);
        sb.append("Offset", this.offset);
        sb.append("Length", this.length);
        sb.append("Type", (Object)this.type);
        sb.append("Number", this.number);
        sb.append("Name", (Object)this.name);
        return sb.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void formatToString(ByteArray record, ToStringBuilder sb) {
        switch (this.type) {
            case BINARY: {
                int len = this.length < 16 ? this.length : 16;
                String data = record.readPns(this.offset, len);
                sb.append(this.name, (Object)("BINARY DATA[LEN=" + this.length + ",x'" + data + "']"));
                break;
            }
            case DATE: {
                SimpleDateFormat simpleDateFormat = sdfDate;
                synchronized (simpleDateFormat) {
                    try {
                        sb.append(this.name, (Object)sdfDate.format(this.extract(record)));
                    }
                    catch (Exception e) {
                        sb.append(this.name, (Object)this.extractAsString(record));
                    }
                    break;
                }
            }
            case TIME: {
                SimpleDateFormat simpleDateFormat = sdfTime;
                synchronized (simpleDateFormat) {
                    try {
                        sb.append(this.name, (Object)sdfTime.format(this.extract(record)));
                    }
                    catch (Exception e) {
                        sb.append(this.name, (Object)this.extractAsString(record));
                    }
                    break;
                }
            }
            default: {
                sb.append(this.name, (Object)this.extractAsString(record));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void formatToXml(ByteArray record, ToXmlBuilder xb) {
        switch (this.type) {
            case BINARY: {
                int len = this.length < 16 ? this.length : 16;
                String data = record.readPns(this.offset, len);
                xb.append(this.name, "BINARY DATA[LEN=" + this.length + ",x'" + data + "']");
                break;
            }
            case DATE: {
                SimpleDateFormat simpleDateFormat = sdfDate;
                synchronized (simpleDateFormat) {
                    try {
                        xb.append(this.name, sdfDate.format(this.extract(record)));
                    }
                    catch (Exception e) {
                        xb.append(this.name, this.extractAsString(record));
                    }
                    break;
                }
            }
            case TIME: {
                SimpleDateFormat simpleDateFormat = sdfTime;
                synchronized (simpleDateFormat) {
                    try {
                        xb.append(this.name, sdfTime.format(this.extract(record)));
                    }
                    catch (Exception e) {
                        xb.append(this.name, this.extractAsString(record));
                    }
                    break;
                }
            }
            default: {
                xb.append(this.name, this.extractAsString(record));
            }
        }
    }
}

