/*
 * Decompiled with CFR 0.152.
 */
package com.thelastcheck.commons.buffer;

import com.thelastcheck.commons.buffer.ByteArrayConverter;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;

public class EbcdicToAsciiByteArrayConverter
extends ByteArrayConverter {
    private static final String EBCDIC = "IBM1047";
    private static final String ASCII = "US-ASCII";
    private static byte[] convertToAsciiTable = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected byte[] loadConvertTable() throws UnsupportedEncodingException {
        Class<EbcdicToAsciiByteArrayConverter> clazz = EbcdicToAsciiByteArrayConverter.class;
        synchronized (EbcdicToAsciiByteArrayConverter.class) {
            this.loadConvertTableSynch();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return convertToAsciiTable;
        }
    }

    private void loadConvertTableSynch() throws UnsupportedEncodingException {
        if (convertToAsciiTable != null) {
            return;
        }
        Charset csEbcdic = Charset.forName(EBCDIC);
        byte[] bytesEbcdic = new byte[256];
        for (int i = 0; i < bytesEbcdic.length; ++i) {
            bytesEbcdic[i] = (byte)i;
        }
        ByteBuffer bbEbcdic = ByteBuffer.wrap(bytesEbcdic);
        CharBuffer cbAscii = csEbcdic.decode(bbEbcdic);
        char[] caAscii = new char[256];
        cbAscii.get(caAscii);
        convertToAsciiTable = new byte[256];
        for (int i = 0; i < 256; ++i) {
            int b = caAscii[i];
            if (b < 0) {
                b = 63;
            }
            EbcdicToAsciiByteArrayConverter.convertToAsciiTable[i] = b;
        }
    }

    @Override
    protected String outputEncoding() {
        return ASCII;
    }
}

