/*
 * Decompiled with CFR 0.152.
 */
package com.thelastcheck.commons.buffer;

import com.thelastcheck.commons.buffer.ByteArrayConverter;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;

public class AsciiToEbcdicByteArrayConverter
extends ByteArrayConverter {
    private static final String EBCDIC = "IBM1047";
    private static byte[] convertToEbcdicTable = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected byte[] loadConvertTable() throws UnsupportedEncodingException {
        Class<AsciiToEbcdicByteArrayConverter> clazz = AsciiToEbcdicByteArrayConverter.class;
        synchronized (AsciiToEbcdicByteArrayConverter.class) {
            this.loadConvertTableSynch();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return convertToEbcdicTable;
        }
    }

    private void loadConvertTableSynch() {
        if (convertToEbcdicTable != null) {
            return;
        }
        Charset csEbcdic = Charset.forName(EBCDIC);
        char[] charsAscii = new char[256];
        for (int i = 0; i < charsAscii.length; ++i) {
            charsAscii[i] = (char)i;
        }
        CharBuffer cbAscii = CharBuffer.wrap(charsAscii);
        ByteBuffer bbEbcdic = csEbcdic.encode(cbAscii);
        convertToEbcdicTable = new byte[256];
        bbEbcdic.get(convertToEbcdicTable);
        for (int i = 128; i < convertToEbcdicTable.length; ++i) {
            AsciiToEbcdicByteArrayConverter.convertToEbcdicTable[i] = 111;
        }
    }

    @Override
    protected String outputEncoding() {
        return EBCDIC;
    }
}

