/*
 * Decompiled with CFR 0.152.
 */
package com.thelastcheck.commons.base.utils;

import org.apache.commons.lang3.builder.Builder;

public class ToXmlBuilder
implements Builder<String> {
    private String elementName;
    private boolean useAttributes;
    private StringBuilder sb;

    public ToXmlBuilder(String elementName) {
        this(elementName, false, 256);
    }

    public ToXmlBuilder(String elementName, boolean useAttributes) {
        this(elementName, useAttributes, 256);
    }

    public ToXmlBuilder(String elementName, boolean useAttributes, int size) {
        this.elementName = elementName;
        this.useAttributes = useAttributes;
        this.sb = new StringBuilder(size);
        this.sb.append("<");
        this.sb.append(elementName);
        if (!useAttributes) {
            this.sb.append(">");
        }
    }

    public void append(String tagName, String value) {
        if (this.useAttributes) {
            this.sb.append(" ");
            this.sb.append(tagName);
            this.sb.append("=\"");
            this.sb.append(value);
            this.sb.append("\"");
        } else {
            this.sb.append("<");
            this.sb.append(tagName);
            this.sb.append(">");
            this.sb.append(value);
            this.sb.append("</");
            this.sb.append(tagName);
            this.sb.append(">");
        }
    }

    public String toString() {
        if (this.useAttributes) {
            this.sb.append("/>");
        } else {
            this.sb.append("</");
            this.sb.append(this.elementName);
            this.sb.append(">");
        }
        return this.sb.toString();
    }

    public String build() {
        return this.toString();
    }
}

