/*
 * Decompiled with CFR 0.152.
 */
package com.thelastcheck.commons.base.utils;

public class Timer {
    private static Object synch = new Object();
    private static int unnamedCounter;
    private String name;
    private long milliseconds;
    private long startTime;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timer() {
        Object object = synch;
        synchronized (object) {
        }
        this.setName("Timer " + ++unnamedCounter);
    }

    public Timer(String name) {
        this.setName(name);
    }

    public void reset() {
        this.milliseconds = 0L;
        this.startTime = 0L;
    }

    public void start() {
        this.startTime = System.currentTimeMillis();
    }

    public void stop() {
        if (this.startTime == 0L) {
            throw new IllegalStateException("Timer not started");
        }
        this.milliseconds += System.currentTimeMillis() - this.startTime;
        this.startTime = 0L;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String toString() {
        return String.valueOf(this.name) + " - elapsed time (ms): " + this.milliseconds;
    }

    public long getMilliseconds() {
        return this.milliseconds;
    }
}

