/*
 * Decompiled with CFR 0.152.
 */
package com.thelastcheck.commons.base.utils;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Point;
import java.awt.Toolkit;
import javax.swing.JFrame;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.OceanTheme;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwingUtils {
    private static Logger log = LoggerFactory.getLogger(SwingUtils.class);
    private static final String LOOKANDFEEL = "System";
    private static final String THEME = "Ocean";

    public static Dimension screenSize() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        log.debug("Width: " + dimension.width);
        log.debug("Height: " + dimension.height);
        return dimension;
    }

    public static int screenResolution() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        int resolution = toolkit.getScreenResolution();
        return resolution;
    }

    public static void updateScrollPane(JScrollPane pane, int hDiff, int vDiff) {
        JScrollBar hBar = pane.getHorizontalScrollBar();
        JScrollBar vBar = pane.getVerticalScrollBar();
        int hmax = hBar.getMaximum();
        int hmin = hBar.getMinimum();
        int hval = hBar.getValue();
        int hext = hBar.getVisibleAmount();
        int vmax = vBar.getMaximum();
        int vmin = vBar.getMinimum();
        int vval = vBar.getValue();
        int vext = vBar.getVisibleAmount();
        vval += vDiff;
        if ((hval += hDiff) < hmax - hext && hval > hmin) {
            hBar.setValue(hval);
        }
        if (vval < vmax - vext && vval > vmin) {
            vBar.setValue(vval);
        }
    }

    public static GridBagConstraints set_gbc(int row, int column, int height, int width, int fill) {
        GridBagConstraints gbc = new GridBagConstraints();
        SwingUtils.set_gbc(gbc, row, column, height, width, fill);
        return gbc;
    }

    public static GridBagConstraints set_gbc(GridBagConstraints gbc, int row, int column, int height, int width) {
        gbc.gridy = row;
        gbc.gridx = column;
        gbc.gridheight = height;
        gbc.gridwidth = width;
        return gbc;
    }

    public static GridBagConstraints set_gbc(GridBagConstraints gbc, int row, int column, int height, int width, int fill) {
        gbc.gridy = row;
        gbc.gridx = column;
        gbc.gridheight = height;
        gbc.gridwidth = width;
        gbc.fill = fill;
        return gbc;
    }

    public static void initLookAndFeel() {
        String lookAndFeel = null;
        if (LOOKANDFEEL != null) {
            if (LOOKANDFEEL.equals("Metal")) {
                lookAndFeel = UIManager.getCrossPlatformLookAndFeelClassName();
            } else if (LOOKANDFEEL.equals(LOOKANDFEEL)) {
                lookAndFeel = UIManager.getSystemLookAndFeelClassName();
            } else if (LOOKANDFEEL.equals("Motif")) {
                lookAndFeel = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
            } else if (LOOKANDFEEL.equals("GTK")) {
                lookAndFeel = "com.sun.java.swing.plaf.gtk.GTKLookAndFeel";
            } else {
                log.warn("Unexpected value of LOOKANDFEEL specified: System");
                lookAndFeel = UIManager.getCrossPlatformLookAndFeelClassName();
            }
            try {
                UIManager.setLookAndFeel(lookAndFeel);
                if (LOOKANDFEEL.equals("Metal")) {
                    if (THEME.equals("DefaultMetal")) {
                        MetalLookAndFeel.setCurrentTheme(new DefaultMetalTheme());
                    } else if (THEME.equals(THEME)) {
                        MetalLookAndFeel.setCurrentTheme(new OceanTheme());
                    } else {
                        MetalLookAndFeel.setCurrentTheme(new DefaultMetalTheme());
                    }
                    UIManager.setLookAndFeel(new MetalLookAndFeel());
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                log.warn("Couldn't find class for specified look and feel:" + lookAndFeel);
                log.warn("Did you include the L&F library in the class path?");
                log.warn("Using the default look and feel.");
            }
            catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                log.warn("Can't use the specified look and feel (" + lookAndFeel + ") on this platform.");
                log.warn("Using the default look and feel.");
            }
            catch (Exception e) {
                log.warn("Couldn't get specified look and feel (" + lookAndFeel + "), for some reason: ", (Throwable)e);
                log.warn("Using the default look and feel.");
            }
        }
    }

    public static Point centerPoint(int width, int height, JFrame frame) {
        Point point = null;
        Dimension frameSize = frame.getSize();
        Point framePoint = frame.getLocation();
        point = new Point(framePoint.x + frameSize.width / 2 - width / 2, framePoint.y + frameSize.height / 2 - height / 2);
        return point;
    }
}

