/*
 * Decompiled with CFR 0.152.
 */
package com.thelastcheck.commons.base.utils;

import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.ImageEncodeParam;
import com.sun.media.jai.codec.ImageEncoder;
import com.sun.media.jai.codec.TIFFDirectory;
import com.sun.media.jai.codec.TIFFEncodeParam;
import com.sun.media.jai.codec.TIFFField;
import java.awt.Image;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;

public class RenderedImageWrapper {
    public static final int TAG_YRESOLUTION = 283;
    public static final int TAG_XRESOLUTION = 282;
    public static final int TAG_RESOLUTION_UNIT = 296;
    public static final int TAG_PHOTOMETRIC_INTERPRETATION = 262;
    private RenderedImage image;
    private TIFFDirectory directory;
    private Map<Integer, TIFFField> fieldMap = new HashMap<Integer, TIFFField>();
    private boolean isTiff = false;

    private RenderedImageWrapper() {
    }

    public RenderedImageWrapper(RenderedImage image) {
        this.image = image;
        Object obj = image.getProperty("tiff_directory");
        if (obj != Image.UndefinedProperty) {
            this.isTiff = true;
            this.directory = (TIFFDirectory)obj;
            TIFFField[] fields = this.directory.getFields();
            int i = 0;
            while (i < fields.length) {
                TIFFField tiffField = fields[i];
                this.fieldMap.put(tiffField.getTag(), tiffField);
                ++i;
            }
        }
    }

    public TIFFField tiffField(int tag) {
        TIFFField field = null;
        if (this.isTiff && this.fieldMap.containsKey(tag)) {
            field = this.fieldMap.get(tag);
        }
        return field;
    }

    public boolean isTiff() {
        return this.isTiff;
    }

    public RenderedImage image() {
        return this.image;
    }

    public long resolution() {
        long[] values = this.resolutionValues(this.image);
        long res = values[0];
        return res;
    }

    public long[] resolutionValues(RenderedImage im) {
        TIFFField xresField = this.fieldMap.get(282);
        TIFFField yresField = this.fieldMap.get(283);
        long xres = this.getFieldValue(xresField);
        long yres = this.getFieldValue(yresField);
        long[] values = new long[]{xres, yres};
        return values;
    }

    private long getFieldValue(TIFFField field) {
        long value;
        if (field.getType() == 12) {
            value = (int)field.getAsDouble(0);
        } else if (field.getType() == 11) {
            value = (int)field.getAsFloat(0);
        } else if (field.getType() == 5) {
            long[] values = field.getAsRational(0);
            value = (int)((double)values[0] / (double)values[1]);
        } else {
            value = field.getType() == 4 ? (long)((int)field.getAsLong(0)) : (long)field.getAsInt(0);
        }
        return value;
    }

    public byte[] convertToTiff() throws IOException {
        long[][] rational;
        RenderedImage image = this.image;
        TIFFEncodeParam param = new TIFFEncodeParam();
        param.setCompression(4);
        param.setLittleEndian(true);
        param.setTileSize(image.getWidth(), image.getHeight());
        TIFFField xresField = this.tiffField(282);
        TIFFField yresField = this.tiffField(283);
        TIFFField photoMetricField = this.tiffField(262);
        char[] resUnitValue = new char[]{'\u0002'};
        TIFFField resUnitField = new TIFFField(296, 3, 1, (Object)resUnitValue);
        if (xresField == null) {
            rational = new long[][]{{240L, 1L}, new long[2]};
            xresField = new TIFFField(282, 5, 1, (Object)rational);
        }
        if (yresField == null) {
            rational = new long[][]{{240L, 1L}, new long[2]};
            yresField = new TIFFField(283, 5, 1, (Object)rational);
        }
        if (photoMetricField == null) {
            char[] value = new char[]{'\u0000'};
            photoMetricField = new TIFFField(262, 3, 1, (Object)value);
        }
        TIFFField[] extraFields = new TIFFField[]{photoMetricField, xresField, yresField, resUnitField};
        param.setExtraFields(extraFields);
        int size = image.getWidth() * image.getHeight() / 8 + 2048;
        ByteArrayOutputStream stream = new ByteArrayOutputStream(size);
        ImageEncoder enc = ImageCodec.createImageEncoder((String)"tiff", (OutputStream)stream, (ImageEncodeParam)param);
        enc.encode(image);
        byte[] ba = stream.toByteArray();
        return ba;
    }

    public RenderedImage rotateImage(int degree) {
        return RenderedImageWrapper.rotateImage(this.image, degree);
    }

    public static RenderedImage rotateImage(RenderedImage image, int degree) {
        float angle = (float)((double)degree * (Math.PI / 180));
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(image);
        float centerX = (float)image.getWidth() / 2.0f;
        float centerY = (float)image.getHeight() / 2.0f;
        pb.add(centerX);
        pb.add(centerY);
        pb.add(angle);
        pb.add(new InterpolationNearest());
        RenderedOp result = JAI.create((String)"Rotate", (ParameterBlock)pb, null);
        return result;
    }
}

