/*
 * Decompiled with CFR 0.152.
 */
package com.thelastcheck.commons.base.utils;

import com.sun.media.jai.codec.ByteArraySeekableStream;
import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.ImageDecoder;
import com.sun.media.jai.codec.SeekableStream;
import com.thelastcheck.commons.base.utils.RenderedImageWrapper;
import com.thelastcheck.commons.buffer.ByteArray;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.media.jai.BorderExtender;
import javax.media.jai.Histogram;
import javax.media.jai.InterpolationBicubic;
import javax.media.jai.JAI;
import javax.media.jai.KernelJAI;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.PlanarImage;
import javax.swing.ImageIcon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ImageUtils {
    private static Logger log = LoggerFactory.getLogger(ImageUtils.class);

    static {
        System.setProperty("com.sun.media.jai.disableMediaLib", "true");
    }

    public static RenderedImage convertToRenderedImage(byte[] data) throws IOException {
        RenderedImage im = null;
        ByteArraySeekableStream stream = new ByteArraySeekableStream(data);
        String[] names = ImageCodec.getDecoderNames((SeekableStream)stream);
        if (names.length > 0) {
            ImageDecoder dec = ImageCodec.createImageDecoder((String)names[0], (SeekableStream)stream, null);
            im = dec.decodeAsRenderedImage();
        }
        if (im == null) {
            ByteArray ba = new ByteArray(data);
            int len = ba.getLength() < 24 ? ba.getLength() : 24;
            log.warn("Unable to find codec for data: " + ba.readPns(0, len));
        }
        return im;
    }

    public static void saveImage(byte[] data, String fileName) throws IOException {
        File file = new File(fileName);
        ImageUtils.saveImage(data, file);
    }

    public static void saveImage(byte[] data, File file) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        fos.write(data);
        fos.close();
    }

    public static BufferedImage convertToBufferedImage(RenderedImage im) {
        BufferedImage image = PlanarImage.wrapRenderedImage((RenderedImage)im).getAsBufferedImage();
        return image;
    }

    public static BufferedImage convertToBufferedImage(byte[] data) throws IOException {
        RenderedImage im = ImageUtils.convertToRenderedImage(data);
        BufferedImage image = ImageUtils.convertToBufferedImage(im);
        return image;
    }

    public static BufferedImage scaleImage(RenderedImageWrapper wrapper, double scale) {
        BufferedImage bi = ImageUtils.convertToBufferedImage(wrapper.image());
        return ImageUtils.scaleImage(bi, scale);
    }

    public static BufferedImage scaleImage(BufferedImage bi, double scale) {
        BufferedImage biNew = new BufferedImage((int)((double)bi.getWidth() * scale), (int)((double)bi.getHeight() * scale), 1);
        AffineTransform at = AffineTransform.getScaleInstance(scale, scale);
        Graphics2D g = biNew.createGraphics();
        g.drawImage(bi, at, null);
        return biNew;
    }

    public static ImageIcon convertToImageIcon(BufferedImage bi) {
        ImageIcon ii = new ImageIcon(bi);
        return ii;
    }

    public static BufferedImage rotateImage(BufferedImage bi, int rotations) {
        int newWidth = bi.getWidth();
        int newHeight = bi.getHeight();
        int moveX = 0;
        int moveY = 0;
        if ((rotations %= 4) % 2 != 0) {
            newHeight = bi.getWidth();
            newWidth = bi.getHeight();
        }
        if (rotations > 1) {
            moveY = newHeight;
        }
        if (rotations > 0 && rotations < 3) {
            moveX = newWidth;
        }
        Graphics2D g2d = bi.createGraphics();
        AffineTransform af = new AffineTransform();
        af.concatenate(AffineTransform.getTranslateInstance(moveX, moveY));
        af.concatenate(AffineTransform.getRotateInstance((double)rotations * 0.5 * Math.PI));
        g2d.drawImage(bi, af, null);
        return bi;
    }

    public static ParameterBlock getParameterBlockForImage(RenderedImage image) {
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(image);
        return pb;
    }

    public static ParameterBlockJAI getParameterBlockJAIForImage(RenderedImage image, String op) {
        ParameterBlockJAI pb = new ParameterBlockJAI(op);
        pb.addSource((Object)image);
        return pb;
    }

    public static RenderedImage scale(PlanarImage image, float scale) {
        return ImageUtils.scale((RenderedImage)image, scale, 2);
    }

    public static RenderedImage scale(RenderedImage image, float scale, int interpolation) {
        ParameterBlock pb = ImageUtils.getParameterBlockForImage(image);
        pb.add(scale);
        pb.add(scale);
        pb.add(0.0f);
        pb.add(0.0f);
        pb.add(InterpolationBicubic.getInstance((int)interpolation));
        return JAI.create((String)"scale", (ParameterBlock)pb);
    }

    public static RenderedImage grayscale(RenderedImage image) {
        if (image.getData().getNumBands() == 1) {
            return image;
        }
        double[][] matrix1 = new double[][]{{0.3333333333333333, 0.3333333333333333, 0.3333333333333333, 0.0}};
        ParameterBlock pb1 = ImageUtils.getParameterBlockForImage(image);
        pb1.add(matrix1);
        return JAI.create((String)"bandcombine", (ParameterBlock)pb1, null);
    }

    public static RenderedImage invert(RenderedImage image) {
        return JAI.create((String)"invert", (ParameterBlock)ImageUtils.getParameterBlockForImage(image), null);
    }

    public static RenderedImage binarize(RenderedImage image) {
        if (image.getData().getNumBands() > 1) {
            image = ImageUtils.grayscale(image);
        }
        return ImageUtils.binarize(image, ImageUtils.getBinarizationThreshold(image));
    }

    public static RenderedImage binarize(RenderedImage image, double threshold) {
        if (image.getData().getNumBands() > 1) {
            image = ImageUtils.grayscale(image);
        }
        ParameterBlock pb = ImageUtils.getParameterBlockForImage(image);
        pb.add(threshold);
        return JAI.create((String)"binarize", (ParameterBlock)pb);
    }

    public static double getBinarizationThreshold(RenderedImage image) {
        ParameterBlock pb = ImageUtils.getParameterBlockForImage(image);
        pb.add(null);
        pb.add(1);
        pb.add(1);
        pb.add(new int[]{256});
        pb.add(new double[]{0.0});
        pb.add(new double[]{256.0});
        Histogram histogram = (Histogram)JAI.create((String)"histogram", (ParameterBlock)pb).getProperty("histogram");
        return histogram.getMinFuzzinessThreshold()[0];
    }

    public static RenderedImage crop(RenderedImage image, Rectangle2D rectangle) {
        return ImageUtils.crop(image, (float)rectangle.getX(), (float)rectangle.getY(), (float)rectangle.getWidth(), (float)rectangle.getHeight());
    }

    public static RenderedImage crop(RenderedImage image, float x, float y, float width, float height) {
        ParameterBlock pb = ImageUtils.getParameterBlockForImage(image);
        pb.add(x);
        pb.add(y);
        pb.add(width);
        pb.add(height);
        return JAI.create((String)"crop", (ParameterBlock)pb);
    }

    public static RenderedImage blur(RenderedImage image, int radius) {
        int klen = Math.max(radius, 2);
        int ksize = klen * klen;
        float f = 1.0f / (float)ksize;
        float[] kern = new float[ksize];
        int i = 0;
        while (i < ksize) {
            kern[i] = f;
            ++i;
        }
        KernelJAI blur = new KernelJAI(klen, klen, kern);
        ParameterBlockJAI param = ImageUtils.getParameterBlockJAIForImage(image, "Convolve");
        param.setParameter("kernel", (Object)blur);
        RenderingHints hint = new RenderingHints(JAI.KEY_BORDER_EXTENDER, BorderExtender.createInstance((int)1));
        return JAI.create((String)"Convolve", (ParameterBlock)param, (RenderingHints)hint);
    }
}

