/*
 * Decompiled with CFR 0.152.
 */
package com.thelastcheck.commons.base.utils;

import com.thelastcheck.commons.base.utils.FileName;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;

public class FileUtilities {
    public static void copyFile(File sourceFile, File destFile) throws IOException {
        if (!destFile.exists()) {
            destFile.createNewFile();
        }
        FileChannel source = null;
        AbstractInterruptibleChannel destination = null;
        try {
            source = new FileInputStream(sourceFile).getChannel();
            destination = new FileOutputStream(destFile).getChannel();
            ((FileChannel)destination).transferFrom(source, 0L, source.size());
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
    }

    public static String suffix(File file) {
        String fileName = file.getAbsolutePath();
        FileName fn = new FileName(fileName);
        return fn.getSuffix();
    }

    public static String renameFile(String fileName, String newSuffix) {
        return FileUtilities.renameFile(fileName, newSuffix, false);
    }

    public static File renameFile(File file, String newSuffix) {
        return FileUtilities.renameFile(file, newSuffix, false);
    }

    public static String renameFile(String fileName, String newSuffix, boolean append) {
        return FileUtilities.renameFile(new File(fileName), newSuffix, append).getAbsolutePath();
    }

    public static File renameFile(File file, String newSuffix, boolean append) {
        String fileName = file.getAbsolutePath();
        FileName fn = new FileName(fileName);
        fn = append ? fn.appendSuffix(newSuffix) : fn.replaceSuffix(newSuffix);
        String newFileName = fn.toString();
        if (fileName.equals(newFileName)) {
            return new File(newFileName);
        }
        File newFile = new File(newFileName);
        if (newFile.exists()) {
            newFile.delete();
        }
        file.renameTo(newFile);
        return new File(newFileName);
    }
}

