/*
 * Decompiled with CFR 0.152.
 */
package com.thelastcheck.commons.base.utils;

import com.thelastcheck.commons.base.utils.CheckDigitVerifier;

public class CheckDigitWeightedMod11Verifier
implements CheckDigitVerifier {
    private final int[] weights;

    public static CheckDigitVerifier from(int[] weights) {
        return new CheckDigitWeightedMod11Verifier(weights);
    }

    private CheckDigitWeightedMod11Verifier(int[] weights) {
        this.weights = weights;
    }

    @Override
    public boolean isValid(String id) {
        int totalWeight = 0;
        int wIndex = 0;
        byte[] digits = id.getBytes();
        int i = 0;
        while (i < digits.length) {
            byte digit = digits[i];
            if (!Character.isDigit(digit)) {
                return false;
            }
            digit = (byte)(digit - 48);
            int weightToUse = i == digits.length - 1 ? 1 : this.weights[wIndex];
            totalWeight += digit * weightToUse;
            if (++wIndex >= this.weights.length) {
                wIndex = 0;
            }
            ++i;
        }
        return totalWeight % 11 == 0;
    }
}

