/*
 * Decompiled with CFR 0.152.
 */
package com.thelastcheck.commons.base.utils;

import com.thelastcheck.commons.base.utils.CheckDigitLuhnMod10Verifier;
import com.thelastcheck.commons.base.utils.CheckDigitRoutingNumberVerifier;
import com.thelastcheck.commons.base.utils.CheckDigitVerifier;
import com.thelastcheck.commons.base.utils.CheckDigitWeightedMod11Verifier;

public abstract class CheckDigitVerifiers {
    public static CheckDigitVerifier getVerifier(Verifier verifierType) {
        if (verifierType == Verifier.WeightedMod11) {
            throw new IllegalArgumentException("Weighted Mod 11 requires weight values");
        }
        return CheckDigitVerifiers.getVerifier(verifierType, null);
    }

    public static CheckDigitVerifier getVerifier(Verifier verifierType, int[] weights) {
        if (verifierType == Verifier.RoutingNumber) {
            return CheckDigitRoutingNumberVerifier.getInstance();
        }
        if (verifierType == Verifier.LuhnMod10) {
            return CheckDigitLuhnMod10Verifier.getInstance();
        }
        if (verifierType == Verifier.WeightedMod11) {
            return CheckDigitWeightedMod11Verifier.from(weights);
        }
        return null;
    }

    public static enum Verifier {
        LuhnMod10,
        WeightedMod11,
        RoutingNumber;

    }
}

