/*
 * Decompiled with CFR 0.152.
 */
package com.thelastcheck.commons.base.utils;

import com.thelastcheck.commons.base.utils.CheckDigitVerifier;

public class CheckDigitRoutingNumberVerifier
implements CheckDigitVerifier {
    private static int[] weights = new int[]{3, 7, 1, 3, 7, 1, 3, 7, 1};
    private static CheckDigitVerifier instance = new CheckDigitRoutingNumberVerifier();

    public static CheckDigitVerifier getInstance() {
        return instance;
    }

    private CheckDigitRoutingNumberVerifier() {
    }

    @Override
    public boolean isValid(String routingNumber) {
        boolean valid = true;
        int sum = 0;
        int i = 0;
        while (i < 9) {
            char digit = routingNumber.charAt(i);
            if (Character.isDigit(digit)) {
                int digitValue = digit - 48;
                sum += (digitValue *= weights[i]);
            } else {
                valid = false;
                break;
            }
            ++i;
        }
        if (valid && sum % 10 != 0) {
            valid = false;
        }
        if (valid && (routingNumber.equals("000000000") || routingNumber.equals("999999999"))) {
            valid = false;
        }
        return valid;
    }
}

