/*
 * Decompiled with CFR 0.152.
 */
package com.thelastcheck.commons.base.utils;

import com.thelastcheck.commons.base.utils.CheckDigitVerifier;

public class CheckDigitLuhnMod10Verifier
implements CheckDigitVerifier {
    private static CheckDigitVerifier instance = new CheckDigitLuhnMod10Verifier();

    public static CheckDigitVerifier getInstance() {
        return instance;
    }

    private CheckDigitLuhnMod10Verifier() {
    }

    @Override
    public boolean isValid(String id) {
        int idSum = 0;
        int position = 0;
        int i = id.length() - 1;
        while (i >= 0) {
            int currentDigit;
            String idCurrentRightmostDigit = id.substring(i, i + 1);
            try {
                currentDigit = Integer.parseInt(idCurrentRightmostDigit);
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            if (position % 2 != 0 && (currentDigit *= 2) > 9) {
                currentDigit -= 9;
            }
            ++position;
            idSum += currentDigit;
            --i;
        }
        return idSum % 10 == 0;
    }
}

