/*
 * Decompiled with CFR 0.152.
 */
package com.thelastcheck.commons.base.security.viewer;

import com.thelastcheck.commons.base.security.Credentials;
import com.thelastcheck.commons.base.security.CredentialsReader;
import com.thelastcheck.commons.base.security.CredentialsWriter;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Date;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;

public class CredentialsViewer
extends Application {
    private static String[] commandLineArgs;
    private Text messageText;
    private TextField userName;
    private PasswordField password1;
    private PasswordField password2;
    private TextField filename;
    private TextField fileLocation;

    public static void main(String[] args) {
        commandLineArgs = args;
        CredentialsViewer.launch((String[])args);
    }

    public void start(Stage primaryStage) {
        primaryStage.setTitle("Setup Credentials File");
        GridPane grid = this.createGrid();
        int row = 0;
        row = this.addInputFields(grid, row);
        this.setDefaultValues();
        row = this.addButtons(grid, row);
        row = this.addMessageText(grid, row);
        Scene scene = new Scene((Parent)grid, 700.0, 275.0);
        primaryStage.setScene(scene);
        primaryStage.setOnCloseRequest(this.closeEventHandler());
        primaryStage.show();
    }

    private EventHandler<WindowEvent> closeEventHandler() {
        return new EventHandler<WindowEvent>(){

            public void handle(WindowEvent windowEvent) {
                Platform.exit();
            }
        };
    }

    private void setDefaultValues() {
        String defaultFileLocation = "../etc";
        if (commandLineArgs.length >= 2 && commandLineArgs[0].equals("-d")) {
            defaultFileLocation = commandLineArgs[1];
        }
        Path path = Paths.get(defaultFileLocation, new String[0]);
        path = path.normalize();
        this.fileLocation.setText(path.toString());
    }

    private int addMessageText(GridPane grid, int row) {
        this.messageText = new Text();
        grid.add((Node)this.messageText, 1, row++);
        return row;
    }

    private int addButtons(GridPane grid, int row) {
        Button exitButton = this.addExitButton();
        Button writeButton = this.addWriteButton();
        Button readButton = this.addReadButton();
        HBox hbBtn = new HBox(10.0);
        hbBtn.setAlignment(Pos.BOTTOM_RIGHT);
        hbBtn.getChildren().addAll((Object[])new Node[]{writeButton, readButton, exitButton});
        grid.add((Node)hbBtn, 1, row++);
        return row;
    }

    private Button addExitButton() {
        Button btn = new Button("Exit");
        btn.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                Platform.exit();
            }
        });
        return btn;
    }

    private Button addWriteButton() {
        Button btn = new Button("Write File");
        btn.setDefaultButton(true);
        btn.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                CredentialsViewer.this.messageText.setFill((Paint)Color.FIREBRICK);
                CredentialsViewer.this.messageText.setText("Write to file...");
                if (CredentialsViewer.this.isValidData()) {
                    CredentialsViewer.this.writeToFile();
                }
            }
        });
        return btn;
    }

    private Button addReadButton() {
        Button btn = new Button("Read File");
        btn.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                CredentialsViewer.this.messageText.setFill((Paint)Color.FIREBRICK);
                CredentialsViewer.this.readFromFile();
            }
        });
        return btn;
    }

    private void writeToFile() {
        String user = System.getProperty("user.name");
        String userdata = "File created by " + user + " on " + new Date();
        Credentials credentials = new Credentials(this.userName.getText().trim(), this.password1.getText().trim(), userdata);
        String filename = this.checkFileSuffix();
        File file = new File(this.fileLocation.getText().trim(), filename);
        CredentialsWriter writer = new CredentialsWriter(file);
        try {
            writer.write(credentials);
        }
        catch (Exception e) {
            this.messageText.setText("Error occurred: " + e.getLocalizedMessage());
            this.filename.requestFocus();
            return;
        }
        this.messageText.setText("Write complete. " + userdata);
        this.userName.requestFocus();
    }

    private String checkFileSuffix() {
        String filename = this.filename.getText().trim();
        if (!filename.endsWith(".credentials")) {
            filename = String.valueOf(filename) + ".credentials";
            this.filename.setText(filename);
        }
        return filename;
    }

    private void readFromFile() {
        String filename = this.checkFileSuffix();
        File file = new File(this.fileLocation.getText().trim(), filename);
        try {
            CredentialsReader reader = new CredentialsReader(file);
            Credentials credentials = reader.read();
            this.userName.setText(credentials.getUsername());
            this.password1.setText(credentials.getPassword());
            this.password2.setText(credentials.getPassword());
            this.messageText.setText(credentials.getUserData());
        }
        catch (Exception e) {
            this.messageText.setText("Error occurred: " + e.getLocalizedMessage());
            this.filename.requestFocus();
            return;
        }
        this.userName.requestFocus();
    }

    private boolean isValidData() {
        if (this.userName.getText().trim().length() < 1) {
            this.userName.requestFocus();
            this.messageText.setText("User name is required");
            return false;
        }
        if (this.password1.getText().trim().length() < 1) {
            this.password1.requestFocus();
            this.messageText.setText("Password is required");
            return false;
        }
        if (!this.password1.getText().trim().equals(this.password2.getText())) {
            this.password1.requestFocus();
            this.messageText.setText("Passwords are not the same");
            return false;
        }
        if (this.filename.getText().trim().length() < 1) {
            this.filename.requestFocus();
            this.messageText.setText("Filename is required");
            return false;
        }
        if (this.fileLocation.getText().trim().length() < 1) {
            this.fileLocation.requestFocus();
            this.messageText.setText("File location is required");
            return false;
        }
        File file = new File(this.fileLocation.getText().trim());
        if (!file.exists() || !file.isDirectory()) {
            this.fileLocation.requestFocus();
            this.messageText.setText("File location missing or is not a directory");
            return false;
        }
        return true;
    }

    private int addInputFields(GridPane grid, int row) {
        Text scenetitle = new Text("Credentials");
        scenetitle.setFont(Font.font((String)"Tahoma", (FontWeight)FontWeight.NORMAL, (double)20.0));
        grid.add((Node)scenetitle, 0, row++, 2, 1);
        grid.add((Node)new Label("User Name:"), 0, row);
        this.userName = new TextField();
        this.userName.setMaxWidth(200.0);
        grid.add((Node)this.userName, 1, row++);
        grid.add((Node)new Label("Password:"), 0, row);
        this.password1 = new PasswordField();
        this.password1.setMaxWidth(200.0);
        grid.add((Node)this.password1, 1, row++);
        grid.add((Node)new Label("Reenter Password:"), 0, row);
        this.password2 = new PasswordField();
        this.password2.setMaxWidth(200.0);
        grid.add((Node)this.password2, 1, row++);
        grid.add((Node)new Label("Filename:"), 0, row);
        this.filename = new TextField();
        this.filename.setMaxWidth(525.0);
        grid.add((Node)this.filename, 1, row++);
        grid.add((Node)new Label("File Location:"), 0, row);
        this.fileLocation = new TextField();
        this.fileLocation.setPrefWidth(525.0);
        grid.add((Node)this.fileLocation, 1, row++);
        return row;
    }

    private GridPane createGrid() {
        GridPane grid = new GridPane();
        grid.setAlignment(Pos.CENTER);
        grid.setHgap(10.0);
        grid.setVgap(10.0);
        grid.setPadding(new Insets(25.0, 25.0, 25.0, 25.0));
        return grid;
    }
}

