/*
 * Decompiled with CFR 0.152.
 */
package com.thelastcheck.commons.base.security;

import com.google.common.base.Preconditions;
import com.thelastcheck.commons.base.security.Credentials;
import com.thelastcheck.commons.base.security.CredentialsEncryptionException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ResourceBundle;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;

public class CredentialsEncrypter {
    private static final String BLOWFISH = "Blowfish";

    public byte[] encrypt(Credentials credentials) throws CredentialsEncryptionException {
        byte[] cipherValue;
        Preconditions.checkNotNull((Object)credentials);
        try {
            Cipher cipher = this.getCipher(1);
            cipherValue = cipher.doFinal(this.encode(credentials));
        }
        catch (Exception e) {
            throw new CredentialsEncryptionException(e);
        }
        return cipherValue;
    }

    public Credentials decrypt(byte[] cipherValue) throws CredentialsEncryptionException {
        Credentials credentials;
        Preconditions.checkNotNull((Object)cipherValue);
        try {
            Cipher cipher = this.getCipher(2);
            credentials = this.decode(cipher.doFinal(cipherValue));
        }
        catch (Exception e) {
            throw new CredentialsEncryptionException(e);
        }
        return credentials;
    }

    private Cipher getCipher(int encryptMode) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException {
        SecretKeySpec certificate = new SecretKeySpec(this.loadKey(), BLOWFISH);
        Cipher cipher = Cipher.getInstance(BLOWFISH);
        cipher.init(encryptMode, certificate);
        return cipher;
    }

    private byte[] encode(Credentials credentials) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream temp = new ObjectOutputStream(bout);
        temp.writeObject(credentials);
        temp.close();
        return bout.toByteArray();
    }

    private Credentials decode(byte[] bytes) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bin = new ByteArrayInputStream(bytes);
        ObjectInputStream oin = new ObjectInputStream(bin);
        return (Credentials)oin.readObject();
    }

    private byte[] loadKey() {
        ResourceBundle bundle = ResourceBundle.getBundle("com.thelastcheck.commons.base.security.EncryptBytes");
        Object key = bundle.getObject("key");
        if (key != null && key instanceof byte[]) {
            return (byte[])key;
        }
        throw new IllegalArgumentException("Missing key or byte[] in com.thelastcheck.commons.base.security.EncryptBytes to define the encryption bytes");
    }
}

