/*
 * Decompiled with CFR 0.152.
 */
package com.thelastcheck.commons.base.fields;

import com.thelastcheck.commons.base.utils.CheckDigitVerifier;
import com.thelastcheck.commons.base.utils.CheckDigitVerifiers;

public class RoutingNumber {
    private String routingNumber;
    private boolean canadian = false;
    private char checkDigit;
    private static int[] weights = new int[]{3, 7, 1, 3, 7, 1, 3, 7, 1};

    public RoutingNumber(String number) {
        this.routingNumber = this.normalizeSize(number, 9);
        this.routingNumber = this.normalizeDashes(this.routingNumber);
        if (this.hasCheckDigit(this.routingNumber)) {
            this.checkDigit = this.routingNumber.charAt(8);
            this.routingNumber = this.routingNumber.substring(0, 8);
        } else {
            this.checkDigit = (char)32;
            this.routingNumber = this.normalizeSize(this.routingNumber, 8);
        }
    }

    public RoutingNumber(String number, String checkDigit) {
        this.routingNumber = this.normalizeSize(number, 8);
        checkDigit = this.normalizeSize(checkDigit, 1);
        this.checkDigit = checkDigit.charAt(0);
    }

    public boolean isCanadian() {
        return this.canadian;
    }

    public char getCheckDigit() {
        return this.checkDigit;
    }

    public String getRoutingNumber() {
        return this.routingNumber;
    }

    private boolean hasCheckDigit(String number) {
        return number.length() > 8 && number.charAt(8) != ' ';
    }

    public boolean hasCheckDigit() {
        return this.checkDigit != ' ';
    }

    private String normalizeSize(String number, int digits) {
        if (number.length() == digits) {
            return number;
        }
        if (number.length() > digits) {
            return number.substring(0, digits);
        }
        number = String.valueOf(number) + "         ".substring(0, digits - number.length());
        return number;
    }

    private String normalizeDashes(String number) {
        if (number.contains("-")) {
            if (number.charAt(5) == '-') {
                this.canadian = true;
            }
            StringBuilder sb = new StringBuilder(9);
            char[] cArray = number.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                Character ch = Character.valueOf(cArray[n2]);
                if (ch.charValue() != '-') {
                    sb.append(ch);
                }
                ++n2;
            }
            number = sb.toString();
        }
        return number;
    }

    public void calculateAndSaveCheckDigit() {
        this.checkDigit = RoutingNumber.calculateCheckDigit(this.routingNumber).charAt(0);
    }

    public static String calculateCheckDigit(String routingNumber) {
        boolean valid = true;
        int sum = 0;
        int i = 0;
        while (i < 8) {
            char digit = routingNumber.charAt(i);
            if (Character.isDigit(digit)) {
                int digitValue = digit - 48;
                sum += (digitValue *= weights[i]);
            } else {
                valid = false;
                break;
            }
            ++i;
        }
        if (valid) {
            int checkDigit = sum % 10;
            if (checkDigit > 0) {
                checkDigit = 10 - checkDigit;
            }
            String s = "" + checkDigit;
            return s;
        }
        return " ";
    }

    public boolean isValid() {
        if (this.hasCheckDigit()) {
            CheckDigitVerifier verifier = CheckDigitVerifiers.getVerifier(CheckDigitVerifiers.Verifier.RoutingNumber);
            return verifier.isValid(this.toString());
        }
        return this.isValidNumber();
    }

    private boolean isValidNumber() {
        if (this.routingNumber.length() == 0) {
            return true;
        }
        char[] cArray = this.routingNumber.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (!Character.isDigit(c)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject instanceof RoutingNumber) {
            RoutingNumber aRoutingNumber = (RoutingNumber)anObject;
            if (this.routingNumber.equals(aRoutingNumber.routingNumber)) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.routingNumber) + this.checkDigit;
    }

    public static RoutingNumber valueOf(String routingNumber) {
        return new RoutingNumber(routingNumber);
    }
}

