/*
 * Decompiled with CFR 0.152.
 */
package com.thedeanda.lorem;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Lorem {
    private static Lorem instance = new Lorem();
    private List<String> words = new ArrayList<String>();
    private Random random = new Random();
    private List<String> maleNames;
    private List<String> femaleNames;
    private List<String> surnames;
    private List<String> firstNames;
    private List<String> stateAbbr;
    private List<String> stateFull;

    public static String getPhone() {
        return instance._getPhone();
    }

    public static String getFirstName() {
        return instance.getRandom(Lorem.instance.firstNames);
    }

    public static String getFirstNameMale() {
        return instance.getRandom(Lorem.instance.maleNames);
    }

    public static String getFirstNameFemale() {
        return instance.getRandom(Lorem.instance.femaleNames);
    }

    public static String getLastName() {
        return instance.getRandom(Lorem.instance.surnames);
    }

    public static String getName() {
        return Lorem.getFirstName() + " " + Lorem.getLastName();
    }

    public static String getNameMale() {
        return Lorem.getFirstNameMale() + " " + Lorem.getLastName();
    }

    public static String getNameFemale() {
        return Lorem.getFirstNameFemale() + " " + Lorem.getLastName();
    }

    public static String getTitle(int count) {
        return instance._getWords(count, count, true);
    }

    public static String getTitle(int min, int max) {
        return instance._getWords(min, max, true);
    }

    public static String getWords(int count) {
        return instance._getWords(count, count, false);
    }

    public static String getWords(int min, int max) {
        return instance._getWords(min, max, false);
    }

    public static String getHtmlParagraphs(int min, int max) {
        return instance._getHtmlParagraphs(min, max);
    }

    public static String getParagraphs(int min, int max) {
        return instance._getParagraphs(min, max);
    }

    public static String getStateAbbr() {
        return instance._getStateAbbr();
    }

    public static String getStateFull() {
        return instance._getStateFull();
    }

    public static String getZipCode() {
        return instance._getZipCode();
    }

    private Lorem() {
        this.readLorem();
        this.maleNames = this.readLines("male_names.txt");
        this.femaleNames = this.readLines("female_names.txt");
        this.surnames = this.readLines("surnames.txt");
        this.firstNames = new ArrayList<String>();
        this.firstNames.addAll(this.maleNames);
        this.firstNames.addAll(this.femaleNames);
        this.stateAbbr = this.readLines("state_abbr.txt");
        this.stateFull = this.readLines("state_full.txt");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readLorem() {
        StringBuilder lines = new StringBuilder();
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("lorem.txt")));
            while ((line = br.readLine()) != null) {
                lines.append(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        String[] w = lines.toString().split("\\s");
        HashSet<String> words = new HashSet<String>();
        for (String word : w) {
            word = word.replaceAll(",", "");
            word = word.replaceAll("\\.", "");
            word = word.toLowerCase();
            words.add(word);
        }
        this.words.addAll(words);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> readLines(String file) {
        ArrayList<String> ret = new ArrayList<String>();
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(file)));
            while ((line = br.readLine()) != null) {
                ret.add(line.trim());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return ret;
    }

    private int getCount(int min, int max) {
        if (min < 0) {
            min = 0;
        }
        if (max < min) {
            max = min;
        }
        int count = max != min ? this.random.nextInt(max - min) + min : min;
        return count;
    }

    private String _getHtmlParagraphs(int min, int max) {
        int count = this.getCount(min, max);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            sb.append("<p>");
            sb.append(this._getParagraphs(1, 1));
            sb.append("</p>");
        }
        return sb.toString().trim();
    }

    private String _getParagraphs(int min, int max) {
        int count = this.getCount(min, max);
        StringBuilder sb = new StringBuilder();
        for (int j = 0; j < count; ++j) {
            int sentences = this.random.nextInt(5) + 2;
            for (int i = 0; i < sentences; ++i) {
                String first = this._getWords(1, 1, false);
                first = first.substring(0, 1).toUpperCase() + first.substring(1);
                sb.append(first);
                sb.append(this._getWords(2, 20, false));
                sb.append(".  ");
            }
            sb.append("\n");
        }
        return sb.toString().trim();
    }

    private String _getWords(int min, int max, boolean title) {
        int count = this.getCount(min, max);
        return instance._getWords(count, title);
    }

    private String _getWords(int count, boolean title) {
        StringBuilder sb = new StringBuilder();
        int size = this.words.size();
        for (int wordCount = 0; wordCount < count; ++wordCount) {
            String word = this.words.get(this.random.nextInt(size));
            if (title && (wordCount == 0 || word.length() > 3)) {
                word = word.substring(0, 1).toUpperCase() + word.substring(1);
            }
            sb.append(word);
            sb.append(" ");
        }
        return sb.toString().trim();
    }

    private String getRandom(List<String> list) {
        int size = list.size();
        return list.get(this.random.nextInt(size));
    }

    private String _getPhone() {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append(this.random.nextInt(9) + 1);
        for (i = 0; i < 2; ++i) {
            sb.append(this.random.nextInt(10));
        }
        sb.append(") ");
        sb.append(this.random.nextInt(9) + 1);
        for (i = 0; i < 2; ++i) {
            sb.append(this.random.nextInt(10));
        }
        sb.append("-");
        for (i = 0; i < 4; ++i) {
            sb.append(this.random.nextInt(10));
        }
        return sb.toString();
    }

    private String _getStateAbbr() {
        return this.getRandom(this.stateAbbr);
    }

    private String _getStateFull() {
        return this.getRandom(this.stateFull);
    }

    private String _getZipCode() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 5; ++i) {
            sb.append(this.random.nextInt(10));
        }
        return sb.toString();
    }
}

