/*
 * Decompiled with CFR 0.152.
 */
package com.thecodeyard.ellipsizedtextview;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.support.v7.widget.AppCompatTextView;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.style.ForegroundColorSpan;
import android.util.AttributeSet;
import com.thecodeyard.ellipsizedtextview.R;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010\u001a\u001a\u00020\u0007H\u0002J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u0007H\u0014R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/thecodeyard/ellipsizedtextview/EllipsizedTextView;", "Landroid/support/v7/widget/AppCompatTextView;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "ellipsis", "", "getEllipsis", "()Ljava/lang/String;", "setEllipsis", "(Ljava/lang/String;)V", "ellipsisColor", "getEllipsisColor", "()I", "setEllipsisColor", "(I)V", "ellipsisSpannable", "Landroid/text/SpannableString;", "spannableStringBuilder", "Landroid/text/SpannableStringBuilder;", "getDefaultEllipsis", "", "getDefaultEllipsisColor", "onMeasure", "", "widthMeasureSpec", "heightMeasureSpec", "ellipsizedtextview_release"})
public final class EllipsizedTextView
extends AppCompatTextView {
    @NotNull
    private String ellipsis;
    private int ellipsisColor;
    private final SpannableString ellipsisSpannable;
    private final SpannableStringBuilder spannableStringBuilder;

    @NotNull
    public final String getEllipsis() {
        return this.ellipsis;
    }

    public final void setEllipsis(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.ellipsis = string;
    }

    public final int getEllipsisColor() {
        return this.ellipsisColor;
    }

    public final void setEllipsisColor(int n) {
        this.ellipsisColor = n;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        float availableScreenWidth = (float)this.getMeasuredWidth() - (float)this.getCompoundPaddingLeft() - (float)this.getCompoundPaddingRight();
        float availableTextWidth = availableScreenWidth * (float)this.getMaxLines();
        CharSequence ellipsizedText = TextUtils.ellipsize((CharSequence)this.getText(), (TextPaint)this.getPaint(), (float)availableTextWidth, (TextUtils.TruncateAt)this.getEllipsize());
        if (Intrinsics.areEqual((Object)((Object)ellipsizedText).toString(), (Object)((Object)this.getText()).toString()) ^ true) {
            availableTextWidth = (availableScreenWidth - this.getPaint().measureText(this.ellipsis)) * (float)this.getMaxLines();
            CharSequence charSequence = ellipsizedText = TextUtils.ellipsize((CharSequence)this.getText(), (TextPaint)this.getPaint(), (float)availableTextWidth, (TextUtils.TruncateAt)this.getEllipsize());
            Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"ellipsizedText");
            int defaultEllipsisStart = StringsKt.indexOf$default((CharSequence)charSequence, (char)this.getDefaultEllipsis(), (int)0, (boolean)false, (int)6, null);
            int defaultEllipsisEnd = defaultEllipsisStart + 1;
            this.spannableStringBuilder.clear();
            this.setText((CharSequence)this.spannableStringBuilder.append(ellipsizedText).replace(defaultEllipsisStart, defaultEllipsisEnd, (CharSequence)this.ellipsisSpannable));
        }
    }

    private final char getDefaultEllipsis() {
        return '\u2026';
    }

    private final int getDefaultEllipsisColor() {
        ColorStateList colorStateList = this.getTextColors();
        Intrinsics.checkExpressionValueIsNotNull((Object)colorStateList, (String)"textColors");
        return colorStateList.getDefaultColor();
    }

    @JvmOverloads
    public EllipsizedTextView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.ellipsis = String.valueOf(this.getDefaultEllipsis());
        this.ellipsisColor = this.getDefaultEllipsisColor();
        this.spannableStringBuilder = new SpannableStringBuilder();
        if (attrs != null) {
            TypedArray typedArray;
            TypedArray typedArray2 = typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.EllipsizedTextView, 0, 0);
            if (typedArray2 != null) {
                TypedArray typedArray3;
                TypedArray it = typedArray3 = typedArray2;
                String string = typedArray.getString(R.styleable.EllipsizedTextView_ellipsis);
                if (string == null) {
                    string = String.valueOf(this.getDefaultEllipsis());
                }
                this.ellipsis = string;
                this.ellipsisColor = typedArray.getColor(R.styleable.EllipsizedTextView_ellipsisColor, this.getDefaultEllipsisColor());
                typedArray.recycle();
            }
        }
        this.ellipsisSpannable = new SpannableString((CharSequence)this.ellipsis);
        this.ellipsisSpannable.setSpan((Object)new ForegroundColorSpan(this.ellipsisColor), 0, this.ellipsis.length(), 33);
    }

    @JvmOverloads
    public /* synthetic */ EllipsizedTextView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public EllipsizedTextView(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public EllipsizedTextView(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }
}

