/*
 * Decompiled with CFR 0.152.
 */
package com.theartofdev.edmodo.cropper;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.widget.Toast;
import com.theartofdev.edmodo.cropper.CropImage;
import com.theartofdev.edmodo.cropper.CropImageOptions;
import com.theartofdev.edmodo.cropper.CropImageView;
import com.theartofdev.edmodo.cropper.R;
import java.io.File;
import java.io.IOException;

public class CropImageActivity
extends AppCompatActivity
implements CropImageView.OnSetImageUriCompleteListener,
CropImageView.OnCropImageCompleteListener {
    private CropImageView mCropImageView;
    private Uri mCropImageUri;
    private CropImageOptions mOptions;

    @SuppressLint(value={"NewApi"})
    public void onCreate(Bundle savedInstanceState) {
        ActionBar actionBar;
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.crop_image_activity);
        this.mCropImageView = (CropImageView)this.findViewById(R.id.cropImageView);
        Bundle bundle = this.getIntent().getBundleExtra("CROP_IMAGE_EXTRA_BUNDLE");
        this.mCropImageUri = (Uri)bundle.getParcelable("CROP_IMAGE_EXTRA_SOURCE");
        this.mOptions = (CropImageOptions)bundle.getParcelable("CROP_IMAGE_EXTRA_OPTIONS");
        if (savedInstanceState == null) {
            if (this.mCropImageUri == null || this.mCropImageUri.equals((Object)Uri.EMPTY)) {
                if (CropImage.isExplicitCameraPermissionRequired((Context)this)) {
                    this.requestPermissions(new String[]{"android.permission.CAMERA"}, 2011);
                } else {
                    CropImage.startPickImageActivity((Activity)this);
                }
            } else if (CropImage.isReadExternalStoragePermissionsRequired((Context)this, this.mCropImageUri)) {
                this.requestPermissions(new String[]{"android.permission.READ_EXTERNAL_STORAGE"}, 201);
            } else {
                this.mCropImageView.setImageUriAsync(this.mCropImageUri);
            }
        }
        if ((actionBar = this.getSupportActionBar()) != null) {
            String title = this.mOptions.activityTitle != null && this.mOptions.activityTitle.length() > 0 ? this.mOptions.activityTitle : this.getResources().getString(R.string.crop_image_activity_title);
            actionBar.setTitle((CharSequence)title);
            actionBar.setDisplayHomeAsUpEnabled(true);
        }
    }

    protected void onStart() {
        super.onStart();
        this.mCropImageView.setOnSetImageUriCompleteListener(this);
        this.mCropImageView.setOnCropImageCompleteListener(this);
    }

    protected void onStop() {
        super.onStop();
        this.mCropImageView.setOnSetImageUriCompleteListener(null);
        this.mCropImageView.setOnCropImageCompleteListener(null);
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.crop_image_menu, menu2);
        if (!this.mOptions.allowRotation) {
            menu2.removeItem(R.id.crop_image_menu_rotate_left);
            menu2.removeItem(R.id.crop_image_menu_rotate_right);
        } else if (this.mOptions.allowCounterRotation) {
            menu2.findItem(R.id.crop_image_menu_rotate_left).setVisible(true);
        }
        if (!this.mOptions.allowFlipping) {
            menu2.removeItem(R.id.crop_image_menu_flip);
        }
        if (this.mOptions.cropMenuCropButtonTitle != null) {
            menu2.findItem(R.id.crop_image_menu_crop).setTitle(this.mOptions.cropMenuCropButtonTitle);
        }
        Drawable cropIcon = null;
        try {
            if (this.mOptions.cropMenuCropButtonIcon != 0) {
                cropIcon = ContextCompat.getDrawable((Context)this, (int)this.mOptions.cropMenuCropButtonIcon);
                menu2.findItem(R.id.crop_image_menu_crop).setIcon(cropIcon);
            }
        }
        catch (Exception e) {
            Log.w((String)"AIC", (String)"Failed to read menu crop drawable", (Throwable)e);
        }
        if (this.mOptions.activityMenuIconColor != 0) {
            this.updateMenuItemIconColor(menu2, R.id.crop_image_menu_rotate_left, this.mOptions.activityMenuIconColor);
            this.updateMenuItemIconColor(menu2, R.id.crop_image_menu_rotate_right, this.mOptions.activityMenuIconColor);
            this.updateMenuItemIconColor(menu2, R.id.crop_image_menu_flip, this.mOptions.activityMenuIconColor);
            if (cropIcon != null) {
                this.updateMenuItemIconColor(menu2, R.id.crop_image_menu_crop, this.mOptions.activityMenuIconColor);
            }
        }
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == R.id.crop_image_menu_crop) {
            this.cropImage();
            return true;
        }
        if (item.getItemId() == R.id.crop_image_menu_rotate_left) {
            this.rotateImage(-this.mOptions.rotationDegrees);
            return true;
        }
        if (item.getItemId() == R.id.crop_image_menu_rotate_right) {
            this.rotateImage(this.mOptions.rotationDegrees);
            return true;
        }
        if (item.getItemId() == R.id.crop_image_menu_flip_horizontally) {
            this.mCropImageView.flipImageHorizontally();
            return true;
        }
        if (item.getItemId() == R.id.crop_image_menu_flip_vertically) {
            this.mCropImageView.flipImageVertically();
            return true;
        }
        if (item.getItemId() == 16908332) {
            this.setResultCancel();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    public void onBackPressed() {
        super.onBackPressed();
        this.setResultCancel();
    }

    @SuppressLint(value={"NewApi"})
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 200) {
            if (resultCode == 0) {
                this.setResultCancel();
            }
            if (resultCode == -1) {
                this.mCropImageUri = CropImage.getPickImageResultUri((Context)this, data);
                if (CropImage.isReadExternalStoragePermissionsRequired((Context)this, this.mCropImageUri)) {
                    this.requestPermissions(new String[]{"android.permission.READ_EXTERNAL_STORAGE"}, 201);
                } else {
                    this.mCropImageView.setImageUriAsync(this.mCropImageUri);
                }
            }
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (requestCode == 201) {
            if (this.mCropImageUri != null && grantResults.length > 0 && grantResults[0] == 0) {
                this.mCropImageView.setImageUriAsync(this.mCropImageUri);
            } else {
                Toast.makeText((Context)this, (int)R.string.crop_image_activity_no_permissions, (int)1).show();
                this.setResultCancel();
            }
        }
        if (requestCode == 2011) {
            CropImage.startPickImageActivity((Activity)this);
        }
    }

    @Override
    public void onSetImageUriComplete(CropImageView view, Uri uri, Exception error) {
        if (error == null) {
            if (this.mOptions.initialCropWindowRectangle != null) {
                this.mCropImageView.setCropRect(this.mOptions.initialCropWindowRectangle);
            }
            if (this.mOptions.initialRotation > -1) {
                this.mCropImageView.setRotatedDegrees(this.mOptions.initialRotation);
            }
        } else {
            this.setResult(null, error, 1);
        }
    }

    @Override
    public void onCropImageComplete(CropImageView view, CropImageView.CropResult result) {
        this.setResult(result.getUri(), result.getError(), result.getSampleSize());
    }

    protected void cropImage() {
        if (this.mOptions.noOutputImage) {
            this.setResult(null, null, 1);
        } else {
            Uri outputUri = this.getOutputUri();
            this.mCropImageView.saveCroppedImageAsync(outputUri, this.mOptions.outputCompressFormat, this.mOptions.outputCompressQuality, this.mOptions.outputRequestWidth, this.mOptions.outputRequestHeight, this.mOptions.outputRequestSizeOptions);
        }
    }

    protected void rotateImage(int degrees) {
        this.mCropImageView.rotateImage(degrees);
    }

    protected Uri getOutputUri() {
        Uri outputUri = this.mOptions.outputUri;
        if (outputUri == null || outputUri.equals((Object)Uri.EMPTY)) {
            try {
                String ext = this.mOptions.outputCompressFormat == Bitmap.CompressFormat.JPEG ? ".jpg" : (this.mOptions.outputCompressFormat == Bitmap.CompressFormat.PNG ? ".png" : ".webp");
                outputUri = Uri.fromFile((File)File.createTempFile("cropped", ext, this.getCacheDir()));
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to create temp file for output image", e);
            }
        }
        return outputUri;
    }

    protected void setResult(Uri uri, Exception error, int sampleSize) {
        int resultCode = error == null ? -1 : 204;
        this.setResult(resultCode, this.getResultIntent(uri, error, sampleSize));
        this.finish();
    }

    protected void setResultCancel() {
        this.setResult(0);
        this.finish();
    }

    protected Intent getResultIntent(Uri uri, Exception error, int sampleSize) {
        CropImage.ActivityResult result = new CropImage.ActivityResult(this.mCropImageView.getImageUri(), uri, error, this.mCropImageView.getCropPoints(), this.mCropImageView.getCropRect(), this.mCropImageView.getRotatedDegrees(), this.mCropImageView.getWholeImageRect(), sampleSize);
        Intent intent = new Intent();
        intent.putExtras(this.getIntent());
        intent.putExtra("CROP_IMAGE_EXTRA_RESULT", (Parcelable)result);
        return intent;
    }

    private void updateMenuItemIconColor(Menu menu2, int itemId, int color) {
        Drawable menuItemIcon;
        MenuItem menuItem = menu2.findItem(itemId);
        if (menuItem != null && (menuItemIcon = menuItem.getIcon()) != null) {
            try {
                menuItemIcon.mutate();
                menuItemIcon.setColorFilter(color, PorterDuff.Mode.SRC_ATOP);
                menuItem.setIcon(menuItemIcon);
            }
            catch (Exception e) {
                Log.w((String)"AIC", (String)"Failed to update menu item color", (Throwable)e);
            }
        }
    }
}

