/*
 * Decompiled with CFR 0.152.
 */
package com.theartofdev.edmodo.cropper;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.media.ExifInterface;
import android.net.Uri;
import android.util.Pair;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;

final class BitmapUtils {
    static final Rect EMPTY_RECT = new Rect();
    static final RectF EMPTY_RECT_F = new RectF();
    static final RectF RECT = new RectF();
    static int mMaxTextureSize;
    static Pair<String, WeakReference<Bitmap>> mStateBitmap;

    BitmapUtils() {
    }

    public static RotateBitmapResult rotateBitmapByExif(Bitmap bitmap, Context context, Uri uri) {
        try {
            File file = BitmapUtils.getFileFromUri(context, uri);
            if (file.exists()) {
                ExifInterface ei = new ExifInterface(file.getAbsolutePath());
                return BitmapUtils.rotateBitmapByExif(bitmap, ei);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new RotateBitmapResult(bitmap, 0);
    }

    public static RotateBitmapResult rotateBitmapByExif(Bitmap bitmap, ExifInterface exif) {
        int degrees;
        int orientation = exif.getAttributeInt("Orientation", 1);
        switch (orientation) {
            case 6: {
                degrees = 90;
                break;
            }
            case 3: {
                degrees = 180;
                break;
            }
            case 8: {
                degrees = 270;
                break;
            }
            default: {
                degrees = 0;
            }
        }
        return new RotateBitmapResult(bitmap, degrees);
    }

    public static DecodeBitmapResult decodeSampledBitmap(Context context, Uri uri, int reqWidth, int reqHeight) {
        try {
            ContentResolver resolver = context.getContentResolver();
            BitmapFactory.Options options = BitmapUtils.decodeImageForOption(resolver, uri);
            options.inSampleSize = Math.max(BitmapUtils.calculateInSampleSizeByReqestedSize(options.outWidth, options.outHeight, reqWidth, reqHeight), BitmapUtils.calculateInSampleSizeByMaxTextureSize(options.outWidth, options.outHeight));
            Bitmap bitmap = BitmapUtils.decodeImage(resolver, uri, options);
            return new DecodeBitmapResult(bitmap, options.inSampleSize);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load sampled bitmap: " + uri + "\r\n" + e.getMessage(), e);
        }
    }

    public static Bitmap cropBitmap(Bitmap bitmap, float[] points, int degreesRotated, boolean fixAspectRatio, int aspectRatioX, int aspectRatioY) {
        Rect rect = BitmapUtils.getRectFromPoints(points, bitmap.getWidth(), bitmap.getHeight(), fixAspectRatio, aspectRatioX, aspectRatioY);
        Matrix matrix = new Matrix();
        matrix.setRotate((float)degreesRotated, (float)(bitmap.getWidth() / 2), (float)(bitmap.getHeight() / 2));
        Bitmap result = Bitmap.createBitmap((Bitmap)bitmap, (int)rect.left, (int)rect.top, (int)rect.width(), (int)rect.height(), (Matrix)matrix, (boolean)true);
        if (result == bitmap) {
            result = bitmap.copy(bitmap.getConfig(), false);
        }
        if (degreesRotated % 90 != 0) {
            result = BitmapUtils.cropForRotatedImage(result, points, rect, degreesRotated, fixAspectRatio, aspectRatioX, aspectRatioY);
        }
        return result;
    }

    public static Bitmap cropBitmap(Context context, Uri loadedImageUri, float[] points, int degreesRotated, int orgWidth, int orgHeight, boolean fixAspectRatio, int aspectRatioX, int aspectRatioY, int reqWidth, int reqHeight) {
        Rect rect = BitmapUtils.getRectFromPoints(points, orgWidth, orgHeight, fixAspectRatio, aspectRatioX, aspectRatioY);
        int width = reqWidth > 0 ? reqWidth : rect.width();
        int height = reqHeight > 0 ? reqHeight : rect.height();
        Bitmap result = null;
        try {
            result = BitmapUtils.decodeSampledBitmapRegion(context, loadedImageUri, rect, width, height);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (result != null) {
            result = BitmapUtils.rotateBitmapInt(result, degreesRotated);
            if (degreesRotated % 90 != 0) {
                result = BitmapUtils.cropForRotatedImage(result, points, rect, degreesRotated, fixAspectRatio, aspectRatioX, aspectRatioY);
            }
        } else {
            try {
                BitmapFactory.Options options = new BitmapFactory.Options();
                options.inSampleSize = BitmapUtils.calculateInSampleSizeByReqestedSize(rect.width(), rect.height(), reqWidth, reqHeight);
                Bitmap fullBitmap = BitmapUtils.decodeImage(context.getContentResolver(), loadedImageUri, options);
                if (fullBitmap != null) {
                    result = BitmapUtils.cropBitmap(fullBitmap, points, degreesRotated, fixAspectRatio, aspectRatioX, aspectRatioY);
                    fullBitmap.recycle();
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to load sampled bitmap: " + loadedImageUri + "\r\n" + e.getMessage(), e);
            }
        }
        return result;
    }

    public static Rect getRectFromPoints(float[] points, int imageWidth, int imageHeight, boolean fixAspectRatio, int aspectRatioX, int aspectRatioY) {
        int left = Math.round(Math.max(0.0f, Math.min(Math.min(Math.min(points[0], points[2]), points[4]), points[6])));
        int top = Math.round(Math.max(0.0f, Math.min(Math.min(Math.min(points[1], points[3]), points[5]), points[7])));
        int right = Math.round(Math.min((float)imageWidth, Math.max(Math.max(Math.max(points[0], points[2]), points[4]), points[6])));
        int bottom = Math.round(Math.min((float)imageHeight, Math.max(Math.max(Math.max(points[1], points[3]), points[5]), points[7])));
        Rect rect = new Rect(left, top, right, bottom);
        if (fixAspectRatio) {
            BitmapUtils.fixRectForAspectRatio(rect, aspectRatioX, aspectRatioY);
        }
        return rect;
    }

    public static void fixRectForAspectRatio(Rect rect, int aspectRatioX, int aspectRatioY) {
        if (aspectRatioX == aspectRatioY && rect.width() != rect.height()) {
            if (rect.height() > rect.width()) {
                rect.bottom -= rect.height() - rect.width();
            } else {
                rect.right -= rect.width() - rect.height();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeBitmapToUri(Context context, Bitmap bitmap, Uri uri, Bitmap.CompressFormat compressFormat, int compressQuality) throws FileNotFoundException {
        OutputStream outputStream = null;
        try {
            outputStream = context.getContentResolver().openOutputStream(uri);
            bitmap.compress(compressFormat, compressQuality, outputStream);
        }
        catch (Throwable throwable) {
            BitmapUtils.closeSafe(outputStream);
            throw throwable;
        }
        BitmapUtils.closeSafe(outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BitmapFactory.Options decodeImageForOption(ContentResolver resolver, Uri uri) throws FileNotFoundException {
        InputStream stream = null;
        try {
            stream = resolver.openInputStream(uri);
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeStream((InputStream)stream, (Rect)EMPTY_RECT, (BitmapFactory.Options)options);
            options.inJustDecodeBounds = false;
            BitmapFactory.Options options2 = options;
            return options2;
        }
        finally {
            BitmapUtils.closeSafe(stream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Bitmap decodeImage(ContentResolver resolver, Uri uri, BitmapFactory.Options options) throws FileNotFoundException {
        do {
            InputStream stream = null;
            try {
                stream = resolver.openInputStream(uri);
                Bitmap bitmap = BitmapFactory.decodeStream((InputStream)stream, (Rect)EMPTY_RECT, (BitmapFactory.Options)options);
                return bitmap;
            }
            catch (OutOfMemoryError e) {
                options.inSampleSize *= 2;
            }
            finally {
                BitmapUtils.closeSafe(stream);
            }
        } while (options.inSampleSize <= 512);
        throw new RuntimeException("Failed to decode image: " + uri);
    }

    /*
     * Exception decompiling
     */
    private static Bitmap decodeSampledBitmapRegion(Context context, Uri uri, Rect rect, int reqWidth, int reqHeight) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 7[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Bitmap cropForRotatedImage(Bitmap bitmap, float[] points, Rect rect, int degreesRotated, boolean fixAspectRatio, int aspectRatioX, int aspectRatioY) {
        if (degreesRotated % 90 != 0) {
            int adjLeft = 0;
            int adjTop = 0;
            int width = 0;
            int height = 0;
            double rads = Math.toRadians(degreesRotated);
            int compareTo = degreesRotated < 90 || degreesRotated > 180 && degreesRotated < 270 ? rect.left : rect.right;
            for (int i = 0; i < points.length; i += 2) {
                if ((int)points[i] != compareTo) continue;
                adjLeft = (int)Math.abs(Math.sin(rads) * (double)((float)rect.bottom - points[i + 1]));
                adjTop = (int)Math.abs(Math.cos(rads) * (double)(points[i + 1] - (float)rect.top));
                width = (int)Math.abs((double)(points[i + 1] - (float)rect.top) / Math.sin(rads));
                height = (int)Math.abs((double)((float)rect.bottom - points[i + 1]) / Math.cos(rads));
                break;
            }
            rect.set(adjLeft, adjTop, adjLeft + width, adjTop + height);
            if (fixAspectRatio) {
                BitmapUtils.fixRectForAspectRatio(rect, aspectRatioX, aspectRatioY);
            }
            Bitmap bitmapTmp = bitmap;
            bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)rect.left, (int)rect.top, (int)rect.width(), (int)rect.height());
            bitmapTmp.recycle();
        }
        return bitmap;
    }

    private static int calculateInSampleSizeByReqestedSize(int width, int height, int reqWidth, int reqHeight) {
        int inSampleSize = 1;
        if (height > reqHeight || width > reqWidth) {
            while (height / 2 / inSampleSize > reqHeight && width / 2 / inSampleSize > reqWidth) {
                inSampleSize *= 2;
            }
        }
        return inSampleSize;
    }

    private static int calculateInSampleSizeByMaxTextureSize(int width, int height) {
        int inSampleSize = 1;
        if (mMaxTextureSize == 0) {
            mMaxTextureSize = BitmapUtils.getMaxTextureSize();
        }
        if (mMaxTextureSize > 0) {
            while (height / inSampleSize > mMaxTextureSize || width / inSampleSize > mMaxTextureSize) {
                inSampleSize *= 2;
            }
        }
        return inSampleSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File getFileFromUri(Context context, Uri uri) {
        File file = new File(uri.getPath());
        if (file.exists()) {
            return file;
        }
        try (Cursor cursor = null;){
            String[] proj = new String[]{"_data"};
            cursor = context.getContentResolver().query(uri, proj, null, null, null);
            int column_index = cursor.getColumnIndexOrThrow("_data");
            cursor.moveToFirst();
            String realPath = cursor.getString(column_index);
            file = new File(realPath);
        }
        return file;
    }

    private static Bitmap rotateBitmapInt(Bitmap bitmap, int degrees) {
        if (degrees > 0) {
            Matrix matrix = new Matrix();
            matrix.setRotate((float)degrees);
            Bitmap newBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)false);
            if (newBitmap != bitmap) {
                bitmap.recycle();
            }
            return newBitmap;
        }
        return bitmap;
    }

    private static int getMaxTextureSize() {
        int IMAGE_MAX_BITMAP_DIMENSION = 2048;
        try {
            EGL10 egl = (EGL10)EGLContext.getEGL();
            EGLDisplay display = egl.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
            int[] version = new int[2];
            egl.eglInitialize(display, version);
            int[] totalConfigurations = new int[1];
            egl.eglGetConfigs(display, null, 0, totalConfigurations);
            EGLConfig[] configurationsList = new EGLConfig[totalConfigurations[0]];
            egl.eglGetConfigs(display, configurationsList, totalConfigurations[0], totalConfigurations);
            int[] textureSize = new int[1];
            int maximumTextureSize = 0;
            for (int i = 0; i < totalConfigurations[0]; ++i) {
                egl.eglGetConfigAttrib(display, configurationsList[i], 12332, textureSize);
                if (maximumTextureSize >= textureSize[0]) continue;
                maximumTextureSize = textureSize[0];
            }
            egl.eglTerminate(display);
            return Math.max(maximumTextureSize, 2048);
        }
        catch (Exception e) {
            return 2048;
        }
    }

    private static void closeSafe(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static final class RotateBitmapResult {
        public final Bitmap bitmap;
        public final int degrees;

        RotateBitmapResult(Bitmap bitmap, int degrees) {
            this.bitmap = bitmap;
            this.degrees = degrees;
        }
    }

    public static final class DecodeBitmapResult {
        public final Bitmap bitmap;
        public final int sampleSize;

        DecodeBitmapResult(Bitmap bitmap, int sampleSize) {
            this.sampleSize = sampleSize;
            this.bitmap = bitmap;
        }
    }
}

