/*
 * Decompiled with CFR 0.152.
 */
package com.theartofdev.edmodo.cropper;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.media.ExifInterface;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Pair;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ProgressBar;
import com.theartofdev.edmodo.cropper.BitmapCroppingWorkerTask;
import com.theartofdev.edmodo.cropper.BitmapLoadingWorkerTask;
import com.theartofdev.edmodo.cropper.BitmapUtils;
import com.theartofdev.edmodo.cropper.CropImageAnimation;
import com.theartofdev.edmodo.cropper.CropImageOptions;
import com.theartofdev.edmodo.cropper.CropOverlayView;
import com.theartofdev.edmodo.cropper.R;
import java.lang.ref.WeakReference;
import java.util.UUID;

public class CropImageView
extends FrameLayout {
    private final ImageView mImageView;
    private final CropOverlayView mCropOverlayView;
    private final Matrix mImageMatrix = new Matrix();
    private final Matrix mImageInverseMatrix = new Matrix();
    private final ProgressBar mProgressBar;
    private final RectF mImageRect = new RectF();
    private CropImageAnimation mAnimation;
    private Bitmap mBitmap;
    private int mDegreesRotated;
    private int mLayoutWidth;
    private int mLayoutHeight;
    private int mImageResource;
    private ScaleType mScaleType;
    private boolean mShowCropOverlay = true;
    private boolean mShowProgressBar = true;
    private boolean mAutoZoomEnabled = true;
    private int mMaxZoom;
    private WeakReference<OnSetImageUriCompleteListener> mOnSetImageUriCompleteListener;
    private WeakReference<OnGetCroppedImageCompleteListener> mOnGetCroppedImageCompleteListener;
    private WeakReference<OnSaveCroppedImageCompleteListener> mOnSaveCroppedImageCompleteListener;
    private Uri mLoadedImageUri;
    private int mLoadedSampleSize = 1;
    private float mZoom = 1.0f;
    private float mZoomOffsetX;
    private float mZoomOffsetY;
    private RectF mRestoreCropWindowRect;
    private WeakReference<BitmapLoadingWorkerTask> mBitmapLoadingWorkerTask;
    private WeakReference<BitmapCroppingWorkerTask> mBitmapCroppingWorkerTask;

    public CropImageView(Context context) {
        this(context, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CropImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        Intent intent;
        CropImageOptions options = null;
        Intent intent2 = intent = context instanceof Activity ? ((Activity)context).getIntent() : null;
        if (intent != null) {
            options = (CropImageOptions)intent.getParcelableExtra("CROP_IMAGE_EXTRA_OPTIONS");
        }
        if (options == null) {
            options = new CropImageOptions();
            if (attrs != null) {
                TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.CropImageView, 0, 0);
                try {
                    options.fixAspectRatio = ta.getBoolean(R.styleable.CropImageView_cropFixAspectRatio, options.fixAspectRatio);
                    options.aspectRatioX = ta.getInteger(R.styleable.CropImageView_cropAspectRatioX, options.aspectRatioX);
                    options.aspectRatioY = ta.getInteger(R.styleable.CropImageView_cropAspectRatioY, options.aspectRatioY);
                    options.scaleType = ScaleType.values()[ta.getInt(R.styleable.CropImageView_cropScaleType, options.scaleType.ordinal())];
                    options.autoZoomEnabled = ta.getBoolean(R.styleable.CropImageView_cropAutoZoomEnabled, options.autoZoomEnabled);
                    options.maxZoom = ta.getInteger(R.styleable.CropImageView_cropMaxZoom, options.maxZoom);
                    options.cropShape = CropShape.values()[ta.getInt(R.styleable.CropImageView_cropShape, options.cropShape.ordinal())];
                    options.guidelines = Guidelines.values()[ta.getInt(R.styleable.CropImageView_cropGuidelines, options.guidelines.ordinal())];
                    options.snapRadius = ta.getDimension(R.styleable.CropImageView_cropSnapRadius, options.snapRadius);
                    options.touchRadius = ta.getDimension(R.styleable.CropImageView_cropTouchRadius, options.touchRadius);
                    options.initialCropWindowPaddingRatio = ta.getFloat(R.styleable.CropImageView_cropInitialCropWindowPaddingRatio, options.initialCropWindowPaddingRatio);
                    options.borderLineThickness = ta.getDimension(R.styleable.CropImageView_cropBorderLineThickness, options.borderLineThickness);
                    options.borderLineColor = ta.getInteger(R.styleable.CropImageView_cropBorderLineColor, options.borderLineColor);
                    options.borderCornerThickness = ta.getDimension(R.styleable.CropImageView_cropBorderCornerThickness, options.borderCornerThickness);
                    options.borderCornerOffset = ta.getDimension(R.styleable.CropImageView_cropBorderCornerOffset, options.borderCornerOffset);
                    options.borderCornerLength = ta.getDimension(R.styleable.CropImageView_cropBorderCornerLength, options.borderCornerLength);
                    options.borderCornerColor = ta.getInteger(R.styleable.CropImageView_cropBorderCornerColor, options.borderCornerColor);
                    options.guidelinesThickness = ta.getDimension(R.styleable.CropImageView_cropGuidelinesThickness, options.guidelinesThickness);
                    options.guidelinesColor = ta.getInteger(R.styleable.CropImageView_cropGuidelinesColor, options.guidelinesColor);
                    options.backgroundColor = ta.getInteger(R.styleable.CropImageView_cropBackgroundColor, options.backgroundColor);
                    options.showCropOverlay = ta.getBoolean(R.styleable.CropImageView_cropShowCropOverlay, this.mShowCropOverlay);
                    options.showProgressBar = ta.getBoolean(R.styleable.CropImageView_cropShowProgressBar, this.mShowProgressBar);
                    options.borderCornerThickness = ta.getDimension(R.styleable.CropImageView_cropBorderCornerThickness, options.borderCornerThickness);
                    options.minCropWindowWidth = (int)ta.getDimension(R.styleable.CropImageView_cropMinCropWindowWidth, (float)options.minCropWindowWidth);
                    options.minCropWindowHeight = (int)ta.getDimension(R.styleable.CropImageView_cropMinCropWindowHeight, (float)options.minCropWindowHeight);
                    options.minCropResultWidth = (int)ta.getFloat(R.styleable.CropImageView_cropMinCropResultWidthPX, (float)options.minCropResultWidth);
                    options.minCropResultHeight = (int)ta.getFloat(R.styleable.CropImageView_cropMinCropResultHeightPX, (float)options.minCropResultHeight);
                    options.maxCropResultWidth = (int)ta.getFloat(R.styleable.CropImageView_cropMaxCropResultWidthPX, (float)options.maxCropResultWidth);
                    options.maxCropResultHeight = (int)ta.getFloat(R.styleable.CropImageView_cropMaxCropResultHeightPX, (float)options.maxCropResultHeight);
                }
                finally {
                    ta.recycle();
                }
            }
        }
        options.validate();
        this.mScaleType = options.scaleType;
        this.mAutoZoomEnabled = options.autoZoomEnabled;
        this.mMaxZoom = options.maxZoom;
        this.mShowCropOverlay = options.showCropOverlay;
        this.mShowProgressBar = options.showProgressBar;
        LayoutInflater inflater = LayoutInflater.from((Context)context);
        View v = inflater.inflate(R.layout.crop_image_view, (ViewGroup)this, true);
        this.mImageView = (ImageView)v.findViewById(R.id.ImageView_image);
        this.mImageView.setScaleType(ImageView.ScaleType.MATRIX);
        this.mCropOverlayView = (CropOverlayView)v.findViewById(R.id.CropOverlayView);
        this.mCropOverlayView.setCropWindowChangeListener(new CropOverlayView.CropWindowChangeListener(){

            @Override
            public void onCropWindowChanged(boolean inProgress) {
                CropImageView.this.handleCropWindowChanged(inProgress, true);
            }
        });
        this.mCropOverlayView.setInitialAttributeValues(options);
        this.mProgressBar = (ProgressBar)v.findViewById(R.id.CropProgressBar);
        this.setProgressBarVisibility();
    }

    public ScaleType getScaleType() {
        return this.mScaleType;
    }

    public void setScaleType(ScaleType scaleType) {
        if (scaleType != this.mScaleType) {
            this.mScaleType = scaleType;
            this.mZoom = 1.0f;
            this.mZoomOffsetY = 0.0f;
            this.mZoomOffsetX = 0.0f;
            this.mCropOverlayView.resetCropOverlayView();
            this.requestLayout();
        }
    }

    public CropShape getCropShape() {
        return this.mCropOverlayView.getCropShape();
    }

    public void setCropShape(CropShape cropShape) {
        this.mCropOverlayView.setCropShape(cropShape);
    }

    public boolean isAutoZoomEnabled() {
        return this.mAutoZoomEnabled;
    }

    public void setAutoZoomEnabled(boolean autoZoomEnabled) {
        if (this.mAutoZoomEnabled != autoZoomEnabled) {
            this.mAutoZoomEnabled = autoZoomEnabled;
            this.handleCropWindowChanged(false, false);
            this.mCropOverlayView.invalidate();
        }
    }

    public int getMaxZoom() {
        return this.mMaxZoom;
    }

    public void setMaxZoom(int maxZoom) {
        if (this.mMaxZoom != maxZoom && maxZoom > 0) {
            this.mMaxZoom = maxZoom;
            this.handleCropWindowChanged(false, false);
            this.mCropOverlayView.invalidate();
        }
    }

    public int getRotatedDegrees() {
        return this.mDegreesRotated;
    }

    public void setRotatedDegrees(int degrees) {
        if (this.mDegreesRotated != degrees) {
            this.rotateImage(degrees - this.mDegreesRotated);
        }
    }

    public boolean isFixAspectRatio() {
        return this.mCropOverlayView.isFixAspectRatio();
    }

    public void setFixedAspectRatio(boolean fixAspectRatio) {
        this.mCropOverlayView.setFixedAspectRatio(fixAspectRatio);
    }

    public Guidelines getGuidelines() {
        return this.mCropOverlayView.getGuidelines();
    }

    public void setGuidelines(Guidelines guidelines) {
        this.mCropOverlayView.setGuidelines(guidelines);
    }

    public Pair<Integer, Integer> getAspectRatio() {
        return new Pair((Object)this.mCropOverlayView.getAspectRatioX(), (Object)this.mCropOverlayView.getAspectRatioY());
    }

    public void setAspectRatio(int aspectRatioX, int aspectRatioY) {
        this.mCropOverlayView.setAspectRatioX(aspectRatioX);
        this.mCropOverlayView.setAspectRatioY(aspectRatioY);
    }

    public void setSnapRadius(float snapRadius) {
        if (snapRadius >= 0.0f) {
            this.mCropOverlayView.setSnapRadius(snapRadius);
        }
    }

    public boolean isShowProgressBar() {
        return this.mShowProgressBar;
    }

    public void setShowProgressBar(boolean showProgressBar) {
        if (this.mShowProgressBar != showProgressBar) {
            this.mShowProgressBar = showProgressBar;
            this.setProgressBarVisibility();
        }
    }

    public boolean isShowCropOverlay() {
        return this.mShowCropOverlay;
    }

    public void setShowCropOverlay(boolean showCropOverlay) {
        if (this.mShowCropOverlay != showCropOverlay) {
            this.mShowCropOverlay = showCropOverlay;
            this.setCropOverlayVisibility();
        }
    }

    public int getImageResource() {
        return this.mImageResource;
    }

    public Uri getImageUri() {
        return this.mLoadedImageUri;
    }

    public Rect getCropRect() {
        if (this.mBitmap != null) {
            float[] points = this.getCropPoints();
            int orgWidth = this.mBitmap.getWidth() * this.mLoadedSampleSize;
            int orgHeight = this.mBitmap.getHeight() * this.mLoadedSampleSize;
            return BitmapUtils.getRectFromPoints(points, orgWidth, orgHeight, this.mCropOverlayView.isFixAspectRatio(), this.mCropOverlayView.getAspectRatioX(), this.mCropOverlayView.getAspectRatioY());
        }
        return null;
    }

    public float[] getCropPoints() {
        RectF cropWindowRect = this.mCropOverlayView.getCropWindowRect();
        float[] points = new float[]{cropWindowRect.left, cropWindowRect.top, cropWindowRect.right, cropWindowRect.top, cropWindowRect.right, cropWindowRect.bottom, cropWindowRect.left, cropWindowRect.bottom};
        this.mImageMatrix.invert(this.mImageInverseMatrix);
        this.mImageInverseMatrix.mapPoints(points);
        int i = 0;
        while (i < points.length) {
            int n = i++;
            points[n] = points[n] * (float)this.mLoadedSampleSize;
        }
        return points;
    }

    public void setCropRect(Rect rect) {
        this.mCropOverlayView.setInitialCropWindowRect(rect);
    }

    public void resetCropRect() {
        this.mZoom = 1.0f;
        this.mZoomOffsetX = 0.0f;
        this.mZoomOffsetY = 0.0f;
        this.mDegreesRotated = 0;
        this.applyImageMatrix(this.getWidth(), this.getHeight(), false, false);
        this.mCropOverlayView.resetCropWindowRect();
    }

    public Bitmap getCroppedImage() {
        return this.getCroppedImage(0, 0);
    }

    public Bitmap getCroppedImage(int reqWidth, int reqHeight) {
        Bitmap croppedBitmap = null;
        if (this.mBitmap != null) {
            this.mImageView.clearAnimation();
            if (this.mLoadedImageUri != null && this.mLoadedSampleSize > 1) {
                int orgWidth = this.mBitmap.getWidth() * this.mLoadedSampleSize;
                int orgHeight = this.mBitmap.getHeight() * this.mLoadedSampleSize;
                croppedBitmap = BitmapUtils.cropBitmap(this.getContext(), this.mLoadedImageUri, this.getCropPoints(), this.mDegreesRotated, orgWidth, orgHeight, this.mCropOverlayView.isFixAspectRatio(), this.mCropOverlayView.getAspectRatioX(), this.mCropOverlayView.getAspectRatioY(), reqWidth, reqHeight);
            } else {
                croppedBitmap = BitmapUtils.cropBitmap(this.mBitmap, this.getCropPoints(), this.mDegreesRotated, this.mCropOverlayView.isFixAspectRatio(), this.mCropOverlayView.getAspectRatioX(), this.mCropOverlayView.getAspectRatioY());
            }
        }
        return croppedBitmap;
    }

    public void getCroppedImageAsync() {
        this.getCroppedImageAsync(0, 0);
    }

    public void getCroppedImageAsync(int reqWidth, int reqHeight) {
        if (this.mOnGetCroppedImageCompleteListener == null) {
            throw new IllegalArgumentException("OnGetCroppedImageCompleteListener is not set");
        }
        this.startCropWorkerTask(reqWidth, reqHeight, null, null, 0);
    }

    public void saveCroppedImageAsync(Uri saveUri) {
        this.saveCroppedImageAsync(saveUri, Bitmap.CompressFormat.JPEG, 90, 0, 0);
    }

    public void saveCroppedImageAsync(Uri saveUri, Bitmap.CompressFormat saveCompressFormat, int saveCompressQuality) {
        this.saveCroppedImageAsync(saveUri, saveCompressFormat, saveCompressQuality, 0, 0);
    }

    public void saveCroppedImageAsync(Uri saveUri, Bitmap.CompressFormat saveCompressFormat, int saveCompressQuality, int reqWidth, int reqHeight) {
        if (this.mOnSaveCroppedImageCompleteListener == null) {
            throw new IllegalArgumentException("mOnSaveCroppedImageCompleteListener is not set");
        }
        this.startCropWorkerTask(reqWidth, reqHeight, saveUri, saveCompressFormat, saveCompressQuality);
    }

    public void setOnSetImageUriCompleteListener(OnSetImageUriCompleteListener listener) {
        this.mOnSetImageUriCompleteListener = listener != null ? new WeakReference<OnSetImageUriCompleteListener>(listener) : null;
    }

    public void setOnGetCroppedImageCompleteListener(OnGetCroppedImageCompleteListener listener) {
        this.mOnGetCroppedImageCompleteListener = listener != null ? new WeakReference<OnGetCroppedImageCompleteListener>(listener) : null;
    }

    public void setOnSaveCroppedImageCompleteListener(OnSaveCroppedImageCompleteListener listener) {
        this.mOnSaveCroppedImageCompleteListener = listener != null ? new WeakReference<OnSaveCroppedImageCompleteListener>(listener) : null;
    }

    public void setImageBitmap(Bitmap bitmap) {
        this.mCropOverlayView.setInitialCropWindowRect(null);
        this.setBitmap(bitmap, true);
    }

    public void setImageBitmap(Bitmap bitmap, ExifInterface exif) {
        Bitmap setBitmap;
        if (bitmap != null && exif != null) {
            BitmapUtils.RotateBitmapResult result = BitmapUtils.rotateBitmapByExif(bitmap, exif);
            setBitmap = result.bitmap;
            this.mDegreesRotated = result.degrees;
        } else {
            setBitmap = bitmap;
        }
        this.mCropOverlayView.setInitialCropWindowRect(null);
        this.setBitmap(setBitmap, true);
    }

    public void setImageResource(int resId) {
        if (resId != 0) {
            this.mCropOverlayView.setInitialCropWindowRect(null);
            Bitmap bitmap = BitmapFactory.decodeResource((Resources)this.getResources(), (int)resId);
            this.setBitmap(bitmap, true);
            this.mImageResource = resId;
        }
    }

    public void setImageUriAsync(Uri uri) {
        if (uri != null) {
            BitmapLoadingWorkerTask currentTask;
            BitmapLoadingWorkerTask bitmapLoadingWorkerTask = currentTask = this.mBitmapLoadingWorkerTask != null ? (BitmapLoadingWorkerTask)((Object)this.mBitmapLoadingWorkerTask.get()) : null;
            if (currentTask != null) {
                currentTask.cancel(true);
            }
            this.clearImage(true);
            this.mCropOverlayView.setInitialCropWindowRect(null);
            this.mBitmapLoadingWorkerTask = new WeakReference<BitmapLoadingWorkerTask>(new BitmapLoadingWorkerTask(this, uri));
            ((BitmapLoadingWorkerTask)((Object)this.mBitmapLoadingWorkerTask.get())).execute(new Void[0]);
            this.setProgressBarVisibility();
        }
    }

    public void clearImage() {
        this.clearImage(true);
        this.mCropOverlayView.setInitialCropWindowRect(null);
    }

    public void rotateImage(int degrees) {
        if (this.mBitmap != null) {
            if (degrees % 90 == 0) {
                BitmapUtils.RECT.set(this.mCropOverlayView.getCropWindowRect());
                this.mImageMatrix.invert(this.mImageInverseMatrix);
                this.mImageInverseMatrix.mapRect(BitmapUtils.RECT);
                this.mZoom = 1.0f;
                this.mZoomOffsetX = 0.0f;
                this.mZoomOffsetY = 0.0f;
                this.mDegreesRotated += degrees;
                this.mDegreesRotated = this.mDegreesRotated >= 0 ? this.mDegreesRotated % 360 : this.mDegreesRotated % 360 + 360;
                this.applyImageMatrix(this.getWidth(), this.getHeight(), true, false);
                this.mImageMatrix.mapRect(BitmapUtils.RECT);
                this.mCropOverlayView.resetCropOverlayView();
                this.mCropOverlayView.setCropWindowRect(BitmapUtils.RECT);
                this.applyImageMatrix(this.getWidth(), this.getHeight(), true, false);
                this.handleCropWindowChanged(false, false);
            } else {
                this.mDegreesRotated += degrees;
                this.mDegreesRotated = this.mDegreesRotated >= 0 ? this.mDegreesRotated % 360 : this.mDegreesRotated % 360 + 360;
                this.mZoom = 1.0f;
                this.mZoomOffsetY = 0.0f;
                this.mZoomOffsetX = 0.0f;
                this.mCropOverlayView.resetCropOverlayView();
                this.applyImageMatrix(this.getWidth(), this.getHeight(), true, false);
            }
        }
    }

    void onSetImageUriAsyncComplete(BitmapLoadingWorkerTask.Result result) {
        OnSetImageUriCompleteListener listener;
        this.mBitmapLoadingWorkerTask = null;
        this.setProgressBarVisibility();
        if (result.error == null) {
            this.setBitmap(result.bitmap, true);
            this.mLoadedImageUri = result.uri;
            this.mLoadedSampleSize = result.loadSampleSize;
            this.mDegreesRotated = result.degreesRotated;
        }
        OnSetImageUriCompleteListener onSetImageUriCompleteListener = listener = this.mOnSetImageUriCompleteListener != null ? (OnSetImageUriCompleteListener)this.mOnSetImageUriCompleteListener.get() : null;
        if (listener != null) {
            listener.onSetImageUriComplete(this, result.uri, result.error);
        }
    }

    void onImageCroppingAsyncComplete(BitmapCroppingWorkerTask.Result result) {
        this.mBitmapCroppingWorkerTask = null;
        this.setProgressBarVisibility();
        if (result.isSave) {
            OnSaveCroppedImageCompleteListener listener;
            OnSaveCroppedImageCompleteListener onSaveCroppedImageCompleteListener = listener = this.mOnSaveCroppedImageCompleteListener != null ? (OnSaveCroppedImageCompleteListener)this.mOnSaveCroppedImageCompleteListener.get() : null;
            if (listener != null) {
                listener.onSaveCroppedImageComplete(this, result.uri, result.error);
            }
        } else {
            OnGetCroppedImageCompleteListener listener;
            OnGetCroppedImageCompleteListener onGetCroppedImageCompleteListener = listener = this.mOnGetCroppedImageCompleteListener != null ? (OnGetCroppedImageCompleteListener)this.mOnGetCroppedImageCompleteListener.get() : null;
            if (listener != null) {
                listener.onGetCroppedImageComplete(this, result.bitmap, result.error);
            }
        }
    }

    private void setBitmap(Bitmap bitmap, boolean clearFull) {
        if (this.mBitmap == null || !this.mBitmap.equals(bitmap)) {
            this.mImageView.clearAnimation();
            this.clearImage(clearFull);
            this.mBitmap = bitmap;
            this.mImageView.setImageBitmap(this.mBitmap);
            this.applyImageMatrix(this.getWidth(), this.getHeight(), true, false);
            if (this.mCropOverlayView != null) {
                this.mCropOverlayView.resetCropOverlayView();
                this.setCropOverlayVisibility();
            }
        }
    }

    private void clearImage(boolean full) {
        if (this.mBitmap != null && (this.mImageResource > 0 || this.mLoadedImageUri != null)) {
            this.mBitmap.recycle();
        }
        this.mBitmap = null;
        if (full) {
            this.mImageResource = 0;
            this.mLoadedImageUri = null;
            this.mLoadedSampleSize = 1;
            this.mDegreesRotated = 0;
            this.mZoom = 1.0f;
            this.mZoomOffsetX = 0.0f;
            this.mZoomOffsetY = 0.0f;
            this.mImageMatrix.reset();
            this.mImageView.setImageBitmap(null);
            this.setCropOverlayVisibility();
        }
    }

    public void startCropWorkerTask(int reqWidth, int reqHeight, Uri saveUri, Bitmap.CompressFormat saveCompressFormat, int saveCompressQuality) {
        BitmapCroppingWorkerTask currentTask;
        this.mImageView.clearAnimation();
        BitmapCroppingWorkerTask bitmapCroppingWorkerTask = currentTask = this.mBitmapCroppingWorkerTask != null ? (BitmapCroppingWorkerTask)((Object)this.mBitmapCroppingWorkerTask.get()) : null;
        if (currentTask != null) {
            currentTask.cancel(true);
        }
        int orgWidth = this.mBitmap.getWidth() * this.mLoadedSampleSize;
        int orgHeight = this.mBitmap.getHeight() * this.mLoadedSampleSize;
        this.mBitmapCroppingWorkerTask = this.mLoadedImageUri != null && this.mLoadedSampleSize > 1 ? new WeakReference<BitmapCroppingWorkerTask>(new BitmapCroppingWorkerTask(this, this.mLoadedImageUri, this.getCropPoints(), this.mDegreesRotated, orgWidth, orgHeight, this.mCropOverlayView.isFixAspectRatio(), this.mCropOverlayView.getAspectRatioX(), this.mCropOverlayView.getAspectRatioY(), reqWidth, reqHeight, saveUri, saveCompressFormat, saveCompressQuality)) : new WeakReference<BitmapCroppingWorkerTask>(new BitmapCroppingWorkerTask(this, this.mBitmap, this.getCropPoints(), this.mDegreesRotated, this.mCropOverlayView.isFixAspectRatio(), this.mCropOverlayView.getAspectRatioX(), this.mCropOverlayView.getAspectRatioY(), saveUri, saveCompressFormat, saveCompressQuality));
        ((BitmapCroppingWorkerTask)((Object)this.mBitmapCroppingWorkerTask.get())).execute(new Void[0]);
        this.setProgressBarVisibility();
    }

    public Parcelable onSaveInstanceState() {
        BitmapLoadingWorkerTask task;
        Bundle bundle = new Bundle();
        bundle.putParcelable("instanceState", super.onSaveInstanceState());
        bundle.putParcelable("LOADED_IMAGE_URI", (Parcelable)this.mLoadedImageUri);
        bundle.putInt("LOADED_IMAGE_RESOURCE", this.mImageResource);
        if (this.mLoadedImageUri == null && this.mImageResource < 1) {
            bundle.putParcelable("SET_BITMAP", (Parcelable)this.mBitmap);
        }
        if (this.mLoadedImageUri != null && this.mBitmap != null) {
            String key = UUID.randomUUID().toString();
            BitmapUtils.mStateBitmap = new Pair((Object)key, new WeakReference<Bitmap>(this.mBitmap));
            bundle.putString("LOADED_IMAGE_STATE_BITMAP_KEY", key);
        }
        if (this.mBitmapLoadingWorkerTask != null && (task = (BitmapLoadingWorkerTask)((Object)this.mBitmapLoadingWorkerTask.get())) != null) {
            bundle.putParcelable("LOADING_IMAGE_URI", (Parcelable)task.getUri());
        }
        bundle.putInt("LOADED_SAMPLE_SIZE", this.mLoadedSampleSize);
        bundle.putInt("DEGREES_ROTATED", this.mDegreesRotated);
        bundle.putParcelable("INITIAL_CROP_RECT", (Parcelable)this.mCropOverlayView.getInitialCropWindowRect());
        BitmapUtils.RECT.set(this.mCropOverlayView.getCropWindowRect());
        this.mImageMatrix.invert(this.mImageInverseMatrix);
        this.mImageInverseMatrix.mapRect(BitmapUtils.RECT);
        bundle.putParcelable("CROP_WINDOW_RECT", (Parcelable)BitmapUtils.RECT);
        bundle.putString("CROP_SHAPE", this.mCropOverlayView.getCropShape().name());
        bundle.putBoolean("CROP_AUTO_ZOOM_ENABLED", this.mAutoZoomEnabled);
        bundle.putInt("CROP_MAX_ZOOM", this.mMaxZoom);
        return bundle;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            Bitmap bitmap = null;
            Uri uri = (Uri)bundle.getParcelable("LOADED_IMAGE_URI");
            if (uri != null) {
                String key = bundle.getString("LOADED_IMAGE_STATE_BITMAP_KEY");
                if (key != null) {
                    Bitmap stateBitmap;
                    Bitmap bitmap2 = stateBitmap = BitmapUtils.mStateBitmap != null && ((String)BitmapUtils.mStateBitmap.first).equals(key) ? (Bitmap)((WeakReference)BitmapUtils.mStateBitmap.second).get() : null;
                    if (stateBitmap != null && !stateBitmap.isRecycled()) {
                        BitmapUtils.mStateBitmap = null;
                        this.setBitmap(stateBitmap, true);
                        this.mLoadedImageUri = uri;
                        this.mLoadedSampleSize = bundle.getInt("LOADED_SAMPLE_SIZE");
                    }
                }
                if (this.mLoadedImageUri == null) {
                    this.setImageUriAsync(uri);
                }
            } else {
                int resId = bundle.getInt("LOADED_IMAGE_RESOURCE");
                if (resId > 0) {
                    this.setImageResource(resId);
                } else {
                    bitmap = (Bitmap)bundle.getParcelable("SET_BITMAP");
                    if (bitmap != null) {
                        this.setBitmap(bitmap, true);
                    } else {
                        uri = (Uri)bundle.getParcelable("LOADING_IMAGE_URI");
                        if (uri != null) {
                            this.setImageUriAsync(uri);
                        }
                    }
                }
            }
            this.mDegreesRotated = bundle.getInt("DEGREES_ROTATED");
            this.mCropOverlayView.setInitialCropWindowRect((Rect)bundle.getParcelable("INITIAL_CROP_RECT"));
            this.mRestoreCropWindowRect = (RectF)bundle.getParcelable("CROP_WINDOW_RECT");
            this.mCropOverlayView.setCropShape(CropShape.valueOf(bundle.getString("CROP_SHAPE")));
            this.mAutoZoomEnabled = bundle.getBoolean("CROP_AUTO_ZOOM_ENABLED");
            this.mMaxZoom = bundle.getInt("CROP_MAX_ZOOM");
            super.onRestoreInstanceState(bundle.getParcelable("instanceState"));
        } else {
            super.onRestoreInstanceState(state);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (this.mBitmap != null) {
            int desiredHeight;
            int desiredWidth;
            if (heightSize == 0) {
                heightSize = this.mBitmap.getHeight();
            }
            double viewToBitmapWidthRatio = Double.POSITIVE_INFINITY;
            double viewToBitmapHeightRatio = Double.POSITIVE_INFINITY;
            if (widthSize < this.mBitmap.getWidth()) {
                viewToBitmapWidthRatio = (double)widthSize / (double)this.mBitmap.getWidth();
            }
            if (heightSize < this.mBitmap.getHeight()) {
                viewToBitmapHeightRatio = (double)heightSize / (double)this.mBitmap.getHeight();
            }
            if (viewToBitmapWidthRatio != Double.POSITIVE_INFINITY || viewToBitmapHeightRatio != Double.POSITIVE_INFINITY) {
                if (viewToBitmapWidthRatio <= viewToBitmapHeightRatio) {
                    desiredWidth = widthSize;
                    desiredHeight = (int)((double)this.mBitmap.getHeight() * viewToBitmapWidthRatio);
                } else {
                    desiredHeight = heightSize;
                    desiredWidth = (int)((double)this.mBitmap.getWidth() * viewToBitmapHeightRatio);
                }
            } else {
                desiredWidth = this.mBitmap.getWidth();
                desiredHeight = this.mBitmap.getHeight();
            }
            int width = CropImageView.getOnMeasureSpec(widthMode, widthSize, desiredWidth);
            int height = CropImageView.getOnMeasureSpec(heightMode, heightSize, desiredHeight);
            this.mLayoutWidth = width;
            this.mLayoutHeight = height;
            this.setMeasuredDimension(this.mLayoutWidth, this.mLayoutHeight);
        } else {
            this.setMeasuredDimension(widthSize, heightSize);
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        if (this.mLayoutWidth > 0 && this.mLayoutHeight > 0) {
            ViewGroup.LayoutParams origParams = this.getLayoutParams();
            origParams.width = this.mLayoutWidth;
            origParams.height = this.mLayoutHeight;
            this.setLayoutParams(origParams);
            if (this.mBitmap != null) {
                this.applyImageMatrix(r - l, b - t, false, false);
                if (this.mBitmap != null && this.mRestoreCropWindowRect != null) {
                    this.mImageMatrix.mapRect(this.mRestoreCropWindowRect);
                    this.mCropOverlayView.setCropWindowRect(this.mRestoreCropWindowRect);
                    this.mRestoreCropWindowRect = null;
                    this.handleCropWindowChanged(false, false);
                }
            } else {
                this.updateBitmapRect(BitmapUtils.EMPTY_RECT_F);
            }
        } else {
            this.updateBitmapRect(BitmapUtils.EMPTY_RECT_F);
        }
    }

    private void handleCropWindowChanged(boolean inProgress, boolean animate) {
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.mBitmap != null && width > 0 && height > 0) {
            RectF cropRect = this.mCropOverlayView.getCropWindowRect();
            if (inProgress) {
                if (cropRect.left < 0.0f || cropRect.top < 0.0f || cropRect.right > (float)width || cropRect.bottom > (float)height) {
                    this.applyImageMatrix(width, height, false, false);
                }
            } else if (this.mAutoZoomEnabled || this.mZoom > 1.0f) {
                float newZoom = 0.0f;
                if (this.mZoom < (float)this.mMaxZoom && cropRect.width() < (float)width * 0.5f && cropRect.height() < (float)height * 0.5f) {
                    newZoom = Math.min((float)this.mMaxZoom, Math.min((float)width / (cropRect.width() / this.mZoom / 0.64f), (float)height / (cropRect.height() / this.mZoom / 0.64f)));
                }
                if (this.mZoom > 1.0f && (cropRect.width() > (float)width * 0.65f || cropRect.height() > (float)height * 0.65f)) {
                    newZoom = Math.max(1.0f, Math.min((float)width / (cropRect.width() / this.mZoom / 0.51f), (float)height / (cropRect.height() / this.mZoom / 0.51f)));
                }
                if (!this.mAutoZoomEnabled) {
                    newZoom = 1.0f;
                }
                if (newZoom > 0.0f && newZoom != this.mZoom) {
                    if (animate) {
                        if (this.mAnimation == null) {
                            this.mAnimation = new CropImageAnimation(this.mImageView, this.mCropOverlayView);
                        }
                        this.mAnimation.setStartState(this.mImageRect, this.mImageMatrix);
                    }
                    this.updateCropRectByZoomChange(newZoom / this.mZoom);
                    this.mZoom = newZoom;
                    this.applyImageMatrix(width, height, true, animate);
                }
            }
        }
    }

    private void updateCropRectByZoomChange(float zoomChange) {
        RectF cropRect = this.mCropOverlayView.getCropWindowRect();
        float xCenterOffset = (float)(this.getWidth() / 2) - cropRect.centerX();
        float yCenterOffset = (float)(this.getHeight() / 2) - cropRect.centerY();
        cropRect.offset(xCenterOffset - xCenterOffset * zoomChange, yCenterOffset - yCenterOffset * zoomChange);
        cropRect.inset((cropRect.width() - cropRect.width() * zoomChange) / 2.0f, (cropRect.height() - cropRect.height() * zoomChange) / 2.0f);
        this.mCropOverlayView.setCropWindowRect(cropRect);
    }

    private void applyImageMatrix(float width, float height, boolean center, boolean animate) {
        if (this.mBitmap != null && width > 0.0f && height > 0.0f) {
            this.mImageMatrix.reset();
            this.mImageRect.set(0.0f, 0.0f, (float)this.mBitmap.getWidth(), (float)this.mBitmap.getHeight());
            this.mImageMatrix.postTranslate((width - this.mImageRect.width()) / 2.0f, (height - this.mImageRect.height()) / 2.0f);
            this.mapImageRectangleByImageMatrix(this.mImageRect);
            if (this.mDegreesRotated > 0) {
                this.mImageMatrix.postRotate((float)this.mDegreesRotated, this.mImageRect.centerX(), this.mImageRect.centerY());
                this.mapImageRectangleByImageMatrix(this.mImageRect);
            }
            float scale = Math.min(width / this.mImageRect.width(), height / this.mImageRect.height());
            if (this.mScaleType == ScaleType.FIT_CENTER || this.mScaleType == ScaleType.CENTER_INSIDE && scale < 1.0f || scale > 1.0f && this.mAutoZoomEnabled) {
                this.mImageMatrix.postScale(scale, scale, this.mImageRect.centerX(), this.mImageRect.centerY());
                this.mapImageRectangleByImageMatrix(this.mImageRect);
            }
            this.mImageMatrix.postScale(this.mZoom, this.mZoom, this.mImageRect.centerX(), this.mImageRect.centerY());
            this.mapImageRectangleByImageMatrix(this.mImageRect);
            RectF cropRect = this.mCropOverlayView.getCropWindowRect();
            cropRect.offset(-this.mZoomOffsetX * this.mZoom, -this.mZoomOffsetY * this.mZoom);
            if (center) {
                this.mZoomOffsetX = width > this.mImageRect.width() ? 0.0f : Math.max(Math.min(width / 2.0f - cropRect.centerX(), -this.mImageRect.left), (float)this.getWidth() - this.mImageRect.right) / this.mZoom;
                this.mZoomOffsetY = height > this.mImageRect.height() ? 0.0f : Math.max(Math.min(height / 2.0f - cropRect.centerY(), -this.mImageRect.top), (float)this.getHeight() - this.mImageRect.bottom) / this.mZoom;
            } else {
                this.mZoomOffsetX = Math.min(Math.max(this.mZoomOffsetX * this.mZoom, -cropRect.left), -cropRect.right + width) / this.mZoom;
                this.mZoomOffsetY = Math.min(Math.max(this.mZoomOffsetY * this.mZoom, -cropRect.top), -cropRect.bottom + height) / this.mZoom;
            }
            this.mImageMatrix.postTranslate(this.mZoomOffsetX * this.mZoom, this.mZoomOffsetY * this.mZoom);
            cropRect.offset(this.mZoomOffsetX * this.mZoom, this.mZoomOffsetY * this.mZoom);
            this.mCropOverlayView.setCropWindowRect(cropRect);
            this.mapImageRectangleByImageMatrix(this.mImageRect);
            if (animate) {
                this.mAnimation.setEndState(this.mImageRect, this.mImageMatrix);
                this.mImageView.startAnimation((Animation)this.mAnimation);
            } else {
                this.mImageView.setImageMatrix(this.mImageMatrix);
            }
            this.updateBitmapRect(this.mImageRect);
        }
    }

    private void mapImageRectangleByImageMatrix(RectF imgRect) {
        imgRect.set(0.0f, 0.0f, (float)this.mBitmap.getWidth(), (float)this.mBitmap.getHeight());
        this.mImageMatrix.mapRect(imgRect);
    }

    private static int getOnMeasureSpec(int measureSpecMode, int measureSpecSize, int desiredSize) {
        int spec = measureSpecMode == 0x40000000 ? measureSpecSize : (measureSpecMode == Integer.MIN_VALUE ? Math.min(desiredSize, measureSpecSize) : desiredSize);
        return spec;
    }

    private void setCropOverlayVisibility() {
        if (this.mCropOverlayView != null) {
            this.mCropOverlayView.setVisibility(this.mShowCropOverlay && this.mBitmap != null ? 0 : 4);
        }
    }

    private void setProgressBarVisibility() {
        boolean visible = this.mShowProgressBar && (this.mBitmap == null && this.mBitmapLoadingWorkerTask != null || this.mBitmapCroppingWorkerTask != null);
        this.mProgressBar.setVisibility(visible ? 0 : 4);
    }

    private void updateBitmapRect(RectF bitmapRect) {
        if (this.mBitmap != null && bitmapRect.width() > 0.0f && bitmapRect.height() > 0.0f) {
            float scaleFactorWidth = (float)(this.mBitmap.getWidth() * this.mLoadedSampleSize) / bitmapRect.width();
            float scaleFactorHeight = (float)(this.mBitmap.getHeight() * this.mLoadedSampleSize) / bitmapRect.height();
            this.mCropOverlayView.setCropWindowLimits(this.getWidth(), this.getHeight(), scaleFactorWidth, scaleFactorHeight);
        }
        this.mCropOverlayView.setBitmapRect(bitmapRect, this.getWidth(), this.getHeight());
    }

    public static interface OnSaveCroppedImageCompleteListener {
        public void onSaveCroppedImageComplete(CropImageView var1, Uri var2, Exception var3);
    }

    public static interface OnGetCroppedImageCompleteListener {
        public void onGetCroppedImageComplete(CropImageView var1, Bitmap var2, Exception var3);
    }

    public static interface OnSetImageUriCompleteListener {
        public void onSetImageUriComplete(CropImageView var1, Uri var2, Exception var3);
    }

    public static enum Guidelines {
        OFF,
        ON_TOUCH,
        ON;

    }

    public static enum ScaleType {
        FIT_CENTER,
        CENTER,
        CENTER_CROP,
        CENTER_INSIDE;

    }

    public static enum CropShape {
        RECTANGLE,
        OVAL;

    }
}

