/*
 * Decompiled with CFR 0.152.
 */
package com.theartofdev.edmodo.cropper;

import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.view.Menu;
import android.view.MenuItem;
import com.theartofdev.edmodo.cropper.CropImage;
import com.theartofdev.edmodo.cropper.CropImageOptions;
import com.theartofdev.edmodo.cropper.CropImageView;
import com.theartofdev.edmodo.cropper.R;
import java.io.File;
import java.io.IOException;

public class CropImageActivity
extends AppCompatActivity
implements CropImageView.OnSetImageUriCompleteListener,
CropImageView.OnSaveCroppedImageCompleteListener {
    private CropImageView mCropImageView;
    private CropImageOptions mOptions;

    public void onCreate(Bundle savedInstanceState) {
        ActionBar actionBar;
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.crop_image_activity);
        this.mCropImageView = (CropImageView)this.findViewById(R.id.cropImageView);
        Intent intent = this.getIntent();
        Uri source = (Uri)intent.getParcelableExtra("CROP_IMAGE_EXTRA_SOURCE");
        this.mOptions = (CropImageOptions)intent.getParcelableExtra("CROP_IMAGE_EXTRA_OPTIONS");
        if (savedInstanceState == null) {
            this.mCropImageView.setImageUriAsync(source);
        }
        if ((actionBar = this.getSupportActionBar()) != null) {
            actionBar.setTitle((CharSequence)this.mOptions.activityTitle);
            actionBar.setDisplayHomeAsUpEnabled(true);
        }
    }

    protected void onStart() {
        super.onStart();
        this.mCropImageView.setOnSetImageUriCompleteListener(this);
        this.mCropImageView.setOnSaveCroppedImageCompleteListener(this);
    }

    protected void onStop() {
        super.onStop();
        this.mCropImageView.setOnSetImageUriCompleteListener(null);
        this.mCropImageView.setOnSaveCroppedImageCompleteListener(null);
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.crop_image_menu, menu2);
        if (!this.mOptions.allowRotation) {
            menu2.removeItem(R.id.crop_image_menu_rotate);
        }
        if (this.mOptions.activityMenuIconColor != 0) {
            this.updateMenuItemIconColor(menu2, R.id.crop_image_menu_rotate, this.mOptions.activityMenuIconColor);
        }
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == R.id.crop_image_menu_crop) {
            this.cropImage();
            return true;
        }
        if (item.getItemId() == R.id.crop_image_menu_rotate) {
            this.rotateImage();
            return true;
        }
        if (item.getItemId() == 16908332) {
            this.setResultCancel();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    public void onBackPressed() {
        super.onBackPressed();
        this.setResultCancel();
    }

    @Override
    public void onSetImageUriComplete(CropImageView view, Uri uri, Exception error) {
        if (error == null) {
            if (this.mOptions.initialCropWindowRectangle != null) {
                this.mCropImageView.setCropRect(this.mOptions.initialCropWindowRectangle);
            }
            if (this.mOptions.initialRotation > -1) {
                this.mCropImageView.setRotatedDegrees(this.mOptions.initialRotation);
            }
        } else {
            this.setResult(null, error);
        }
    }

    @Override
    public void onSaveCroppedImageComplete(CropImageView view, Uri uri, Exception error) {
        this.setResult(uri, error);
    }

    protected void cropImage() {
        Uri outputUri = this.getOutputUri();
        this.mCropImageView.saveCroppedImageAsync(outputUri, this.mOptions.outputCompressFormat, this.mOptions.outputCompressQuality, this.mOptions.outputRequestWidth, this.mOptions.outputRequestHeight);
    }

    protected void rotateImage() {
        this.mCropImageView.rotateImage(90);
    }

    protected Uri getOutputUri() {
        Uri outputUri = this.mOptions.outputUri;
        if (outputUri.equals((Object)Uri.EMPTY)) {
            try {
                String ext = this.mOptions.outputCompressFormat == Bitmap.CompressFormat.JPEG ? ".jpg" : (this.mOptions.outputCompressFormat == Bitmap.CompressFormat.PNG ? ".png" : ".wepb");
                outputUri = Uri.fromFile((File)File.createTempFile("cropped", ext, this.getCacheDir()));
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to create temp file for output image", e);
            }
        }
        return outputUri;
    }

    protected void setResult(Uri uri, Exception error) {
        int resultCode = error == null ? -1 : 204;
        this.setResult(resultCode, this.getResultIntent(uri, error));
        this.finish();
    }

    protected void setResultCancel() {
        this.setResult(0);
        this.finish();
    }

    protected Intent getResultIntent(Uri uri, Exception error) {
        CropImage.ActivityResult result = new CropImage.ActivityResult(uri, error, this.mCropImageView.getCropPoints(), this.mCropImageView.getCropRect(), this.mCropImageView.getRotatedDegrees());
        Intent intent = new Intent();
        intent.putExtra("CROP_IMAGE_EXTRA_RESULT", (Parcelable)result);
        return intent;
    }

    private void updateMenuItemIconColor(Menu menu2, int itemId, int color) {
        Drawable menuItemIcon;
        MenuItem menuItem = menu2.findItem(itemId);
        if (menuItem != null && (menuItemIcon = menuItem.getIcon()) != null) {
            try {
                menuItemIcon.mutate();
                menuItemIcon.setColorFilter(color, PorterDuff.Mode.SRC_ATOP);
                menuItem.setIcon(menuItemIcon);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

