/*
 * Decompiled with CFR 0.152.
 */
package com.theartofdev.edmodo.cropper;

import android.app.Activity;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.net.Uri;
import android.os.Build;
import android.os.Parcelable;
import android.system.ErrnoException;
import android.system.OsConstants;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public final class CropImage {
    public static final int PICK_IMAGE_CHOOSER_REQUEST_CODE = 200;
    public static final int PICK_IMAGE_PERMISSIONS_REQUEST_CODE = 201;

    private CropImage() {
    }

    public static Bitmap toOvalBitmap(Bitmap bitmap) {
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        Bitmap output = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(output);
        int color = -12434878;
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        canvas.drawARGB(0, 0, 0, 0);
        paint.setColor(color);
        RectF rect = new RectF(0.0f, 0.0f, (float)width, (float)height);
        canvas.drawOval(rect, paint);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(bitmap, 0.0f, 0.0f, paint);
        bitmap.recycle();
        return output;
    }

    public static void startPickImageActivity(Activity activity) {
        activity.startActivityForResult(CropImage.getPickImageChooserIntent((Context)activity), 200);
    }

    public static Intent getPickImageChooserIntent(Context context) {
        Uri outputFileUri = CropImage.getCaptureImageOutputUri(context);
        ArrayList<Object> allIntents = new ArrayList<Object>();
        PackageManager packageManager = context.getPackageManager();
        Intent captureIntent = new Intent("android.media.action.IMAGE_CAPTURE");
        List listCam = packageManager.queryIntentActivities(captureIntent, 0);
        for (ResolveInfo res : listCam) {
            Intent intent = new Intent(captureIntent);
            intent.setComponent(new ComponentName(res.activityInfo.packageName, res.activityInfo.name));
            intent.setPackage(res.activityInfo.packageName);
            if (outputFileUri != null) {
                intent.putExtra("output", (Parcelable)outputFileUri);
            }
            allIntents.add(intent);
        }
        Intent galleryIntent = new Intent("android.intent.action.GET_CONTENT");
        galleryIntent.setType("image/*");
        List listGallery = packageManager.queryIntentActivities(galleryIntent, 0);
        for (Object res : listGallery) {
            Intent intent = new Intent(galleryIntent);
            intent.setComponent(new ComponentName(((ResolveInfo)res).activityInfo.packageName, ((ResolveInfo)res).activityInfo.name));
            intent.setPackage(((ResolveInfo)res).activityInfo.packageName);
            allIntents.add(intent);
        }
        Intent mainIntent = (Intent)allIntents.get(allIntents.size() - 1);
        for (Intent intent : allIntents) {
            if (!intent.getComponent().getClassName().equals("com.android.documentsui.DocumentsActivity")) continue;
            mainIntent = intent;
            break;
        }
        allIntents.remove(mainIntent);
        Intent chooserIntent = Intent.createChooser((Intent)mainIntent, (CharSequence)"Select source");
        chooserIntent.putExtra("android.intent.extra.INITIAL_INTENTS", allIntents.toArray(new Parcelable[allIntents.size()]));
        return chooserIntent;
    }

    public static Uri getCaptureImageOutputUri(Context context) {
        Uri outputFileUri = null;
        File getImage = context.getExternalCacheDir();
        if (getImage != null) {
            outputFileUri = Uri.fromFile((File)new File(getImage.getPath(), "pickImageResult.jpeg"));
        }
        return outputFileUri;
    }

    public static Uri getPickImageResultUri(Context context, Intent data) {
        boolean isCamera = true;
        if (data != null && data.getData() != null) {
            String action = data.getAction();
            isCamera = action != null && action.equals("android.media.action.IMAGE_CAPTURE");
        }
        return isCamera ? CropImage.getCaptureImageOutputUri(context) : data.getData();
    }

    public static boolean isReadExternalStoragePermissionsRequired(Context context, Uri uri) {
        return Build.VERSION.SDK_INT >= 23 && context.checkSelfPermission("android.permission.READ_EXTERNAL_STORAGE") != 0 && CropImage.isUriRequiresPermissions(context, uri);
    }

    public static boolean isUriRequiresPermissions(Context context, Uri uri) {
        try {
            ContentResolver resolver = context.getContentResolver();
            InputStream stream = resolver.openInputStream(uri);
            stream.close();
            return false;
        }
        catch (FileNotFoundException e) {
            if (e.getCause() instanceof ErrnoException && ((ErrnoException)e.getCause()).errno == OsConstants.EACCES) {
                return true;
            }
        }
        catch (SecurityException e) {
            return true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

