/*
 * Decompiled with CFR 0.152.
 */
package com.theartofdev.edmodo.cropper;

import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.AsyncTask;
import com.theartofdev.edmodo.cropper.BitmapUtils;
import com.theartofdev.edmodo.cropper.CropImageView;
import java.lang.ref.WeakReference;

final class BitmapCroppingWorkerTask
extends AsyncTask<Void, Void, Result> {
    private final WeakReference<CropImageView> mCropImageViewReference;
    private final Bitmap mBitmap;
    private final Uri mUri;
    private final Context mContext;
    private final float[] mCropPoints;
    private final int mDegreesRotated;
    private final int mOrgWidth;
    private final int mOrgHeight;
    private final boolean mFixAspectRatio;
    private final int mAspectRatioX;
    private final int mAspectRatioY;
    private final int mReqWidth;
    private final int mReqHeight;

    public BitmapCroppingWorkerTask(CropImageView cropImageView, Bitmap bitmap, float[] cropPoints, int degreesRotated, boolean fixAspectRatio, int aspectRatioX, int aspectRatioY) {
        this.mCropImageViewReference = new WeakReference<CropImageView>(cropImageView);
        this.mContext = cropImageView.getContext();
        this.mBitmap = bitmap;
        this.mCropPoints = cropPoints;
        this.mUri = null;
        this.mDegreesRotated = degreesRotated;
        this.mFixAspectRatio = fixAspectRatio;
        this.mAspectRatioX = aspectRatioX;
        this.mAspectRatioY = aspectRatioY;
        this.mOrgWidth = 0;
        this.mOrgHeight = 0;
        this.mReqWidth = 0;
        this.mReqHeight = 0;
    }

    public BitmapCroppingWorkerTask(CropImageView cropImageView, Uri uri, float[] cropPoints, int degreesRotated, int orgWidth, int orgHeight, boolean fixAspectRatio, int aspectRatioX, int aspectRatioY, int reqWidth, int reqHeight) {
        this.mCropImageViewReference = new WeakReference<CropImageView>(cropImageView);
        this.mContext = cropImageView.getContext();
        this.mUri = uri;
        this.mCropPoints = cropPoints;
        this.mDegreesRotated = degreesRotated;
        this.mFixAspectRatio = fixAspectRatio;
        this.mAspectRatioX = aspectRatioX;
        this.mAspectRatioY = aspectRatioY;
        this.mOrgWidth = orgWidth;
        this.mOrgHeight = orgHeight;
        this.mReqWidth = reqWidth;
        this.mReqHeight = reqHeight;
        this.mBitmap = null;
    }

    public Uri getUri() {
        return this.mUri;
    }

    protected Result doInBackground(Void ... params) {
        try {
            if (!this.isCancelled()) {
                Bitmap bitmap = null;
                if (this.mUri != null) {
                    bitmap = BitmapUtils.cropBitmap(this.mContext, this.mUri, this.mCropPoints, this.mDegreesRotated, this.mOrgWidth, this.mOrgHeight, this.mFixAspectRatio, this.mAspectRatioX, this.mAspectRatioY, this.mReqWidth, this.mReqHeight);
                } else if (this.mBitmap != null) {
                    bitmap = BitmapUtils.cropBitmap(this.mBitmap, this.mCropPoints, this.mDegreesRotated, this.mFixAspectRatio, this.mAspectRatioX, this.mAspectRatioY);
                }
                return new Result(bitmap);
            }
            return null;
        }
        catch (Exception e) {
            return new Result(e);
        }
    }

    protected void onPostExecute(Result result) {
        if (result != null) {
            CropImageView cropImageView;
            boolean completeCalled = false;
            if (!this.isCancelled() && (cropImageView = (CropImageView)((Object)this.mCropImageViewReference.get())) != null) {
                completeCalled = true;
                cropImageView.onGetImageCroppingAsyncComplete(result);
            }
            if (!completeCalled && result.bitmap != null) {
                result.bitmap.recycle();
            }
        }
    }

    public static final class Result {
        public final Bitmap bitmap;
        public final Exception error;

        Result(Bitmap bitmap) {
            this.bitmap = bitmap;
            this.error = null;
        }

        Result(Exception error) {
            this.bitmap = null;
            this.error = error;
        }
    }
}

