/*
 * Decompiled with CFR 0.152.
 */
package com.theartofdev.edmodo.cropper;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.media.ExifInterface;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Pair;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ProgressBar;
import com.theartofdev.edmodo.cropper.BitmapCroppingWorkerTask;
import com.theartofdev.edmodo.cropper.BitmapLoadingWorkerTask;
import com.theartofdev.edmodo.cropper.BitmapUtils;
import com.theartofdev.edmodo.cropper.CropDefaults;
import com.theartofdev.edmodo.cropper.CropOverlayView;
import com.theartofdev.edmodo.cropper.R;
import java.lang.ref.WeakReference;

public class CropImageView
extends FrameLayout {
    private final ImageView mImageView;
    private final CropOverlayView mCropOverlayView;
    private final ProgressBar mProgressBar;
    private Bitmap mBitmap;
    private int mDegreesRotated;
    private int mLayoutWidth;
    private int mLayoutHeight;
    private int mImageResource;
    private boolean mShowCropOverlay = true;
    private boolean mShowProgressBar = true;
    private WeakReference<OnSetImageUriCompleteListener> mOnSetImageUriCompleteListener;
    private WeakReference<OnGetCroppedImageCompleteListener> mOnGetCroppedImageCompleteListener;
    private Uri mLoadedImageUri;
    private int mLoadedSampleSize = 1;
    private WeakReference<BitmapLoadingWorkerTask> mBitmapLoadingWorkerTask;
    private WeakReference<BitmapCroppingWorkerTask> mBitmapCroppingWorkerTask;

    public CropImageView(Context context) {
        this(context, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CropImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        DisplayMetrics dm = this.getResources().getDisplayMetrics();
        boolean fixAspectRatio = false;
        int aspectRatioX = 1;
        int aspectRatioY = 1;
        ImageView.ScaleType scaleType = CropDefaults.VALID_SCALE_TYPES[0];
        CropShape cropShape = CropShape.RECTANGLE;
        Guidelines guidelines = Guidelines.ON_TOUCH;
        float snapRadius = TypedValue.applyDimension((int)1, (float)3.0f, (DisplayMetrics)dm);
        float touchRadius = TypedValue.applyDimension((int)1, (float)24.0f, (DisplayMetrics)dm);
        float initialCropWindowPaddingRatio = 0.1f;
        float borderLineThickness = TypedValue.applyDimension((int)1, (float)3.0f, (DisplayMetrics)dm);
        int borderLineColor = CropDefaults.DEFAULT_BORDER_LINE_COLOR;
        float borderCornerThickness = TypedValue.applyDimension((int)1, (float)2.0f, (DisplayMetrics)dm);
        float borderCornerOffset = TypedValue.applyDimension((int)1, (float)5.0f, (DisplayMetrics)dm);
        float borderCornerLength = TypedValue.applyDimension((int)1, (float)14.0f, (DisplayMetrics)dm);
        int borderCornerColor = -1;
        float guidelinesThickness = TypedValue.applyDimension((int)1, (float)1.0f, (DisplayMetrics)dm);
        int guidelinesColor = CropDefaults.DEFAULT_GUIDELINE_COLOR;
        int backgroundColor = CropDefaults.DEFAULT_BACKGROUND_COLOR;
        float minCropWindowWidth = TypedValue.applyDimension((int)1, (float)42.0f, (DisplayMetrics)dm);
        float minCropWindowHeight = TypedValue.applyDimension((int)1, (float)42.0f, (DisplayMetrics)dm);
        float minCropResultWidth = 80.0f;
        float minCropResultHeight = 80.0f;
        float maxCropResultWidth = 99999.0f;
        float maxCropResultHeight = 99999.0f;
        if (attrs != null) {
            TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.CropImageView, 0, 0);
            try {
                fixAspectRatio = ta.getBoolean(R.styleable.CropImageView_cropFixAspectRatio, false);
                aspectRatioX = ta.getInteger(R.styleable.CropImageView_cropAspectRatioX, 1);
                aspectRatioY = ta.getInteger(R.styleable.CropImageView_cropAspectRatioY, 1);
                scaleType = CropDefaults.VALID_SCALE_TYPES[ta.getInt(R.styleable.CropImageView_cropScaleType, 0)];
                cropShape = CropDefaults.VALID_CROP_SHAPES[ta.getInt(R.styleable.CropImageView_cropShape, 0)];
                guidelines = CropDefaults.VALID_GUIDELINES[ta.getInt(R.styleable.CropImageView_cropGuidelines, 1)];
                snapRadius = ta.getDimension(R.styleable.CropImageView_cropSnapRadius, snapRadius);
                touchRadius = ta.getDimension(R.styleable.CropImageView_cropTouchRadius, touchRadius);
                initialCropWindowPaddingRatio = ta.getFloat(R.styleable.CropImageView_cropInitialCropWindowPaddingRatio, initialCropWindowPaddingRatio);
                borderLineThickness = ta.getDimension(R.styleable.CropImageView_cropBorderLineThickness, borderLineThickness);
                borderLineColor = ta.getInteger(R.styleable.CropImageView_cropBorderLineColor, borderLineColor);
                borderCornerThickness = ta.getDimension(R.styleable.CropImageView_cropBorderCornerThickness, borderCornerThickness);
                borderCornerOffset = ta.getDimension(R.styleable.CropImageView_cropBorderCornerOffset, borderCornerOffset);
                borderCornerLength = ta.getDimension(R.styleable.CropImageView_cropBorderCornerLength, borderCornerLength);
                borderCornerColor = ta.getInteger(R.styleable.CropImageView_cropBorderCornerColor, borderCornerColor);
                guidelinesThickness = ta.getDimension(R.styleable.CropImageView_cropGuidelinesThickness, guidelinesThickness);
                guidelinesColor = ta.getInteger(R.styleable.CropImageView_cropGuidelinesColor, guidelinesColor);
                backgroundColor = ta.getInteger(R.styleable.CropImageView_cropBackgroundColor, backgroundColor);
                this.mShowCropOverlay = ta.getBoolean(R.styleable.CropImageView_cropShowCropOverlay, this.mShowCropOverlay);
                this.mShowProgressBar = ta.getBoolean(R.styleable.CropImageView_cropShowProgressBar, this.mShowProgressBar);
                borderCornerThickness = ta.getDimension(R.styleable.CropImageView_cropBorderCornerThickness, borderCornerThickness);
                minCropWindowWidth = ta.getDimension(R.styleable.CropImageView_cropMinCropWindowWidth, minCropWindowWidth);
                minCropWindowHeight = ta.getDimension(R.styleable.CropImageView_cropMinCropWindowHeight, minCropWindowHeight);
                minCropResultWidth = ta.getFloat(R.styleable.CropImageView_cropMinCropResultWidthPX, minCropResultWidth);
                minCropResultHeight = ta.getFloat(R.styleable.CropImageView_cropMinCropResultHeightPX, minCropResultHeight);
                maxCropResultWidth = ta.getFloat(R.styleable.CropImageView_cropMaxCropResultWidthPX, maxCropResultWidth);
                maxCropResultHeight = ta.getFloat(R.styleable.CropImageView_cropMaxCropResultHeightPX, maxCropResultHeight);
            }
            finally {
                ta.recycle();
            }
        }
        LayoutInflater inflater = LayoutInflater.from((Context)context);
        View v = inflater.inflate(R.layout.crop_image_view, (ViewGroup)this, true);
        this.mImageView = (ImageView)v.findViewById(R.id.ImageView_image);
        this.mImageView.setScaleType(scaleType);
        this.mCropOverlayView = (CropOverlayView)v.findViewById(R.id.CropOverlayView);
        this.mCropOverlayView.setInitialAttributeValues(cropShape, snapRadius, touchRadius, guidelines, fixAspectRatio, aspectRatioX, aspectRatioY, initialCropWindowPaddingRatio, borderLineThickness, borderLineColor, borderCornerThickness, borderCornerOffset, borderCornerLength, borderCornerColor, guidelinesThickness, guidelinesColor, backgroundColor, minCropWindowWidth, minCropWindowHeight, minCropResultWidth, minCropResultHeight, maxCropResultWidth, maxCropResultHeight);
        this.mProgressBar = (ProgressBar)v.findViewById(R.id.CropProgressBar);
        this.setProgressBarVisibility();
    }

    public ImageView.ScaleType getScaleType() {
        return this.mImageView.getScaleType();
    }

    public int getRotatedDegrees() {
        return this.mDegreesRotated;
    }

    public void setScaleType(ImageView.ScaleType scaleType) {
        if (scaleType != this.mImageView.getScaleType()) {
            this.mImageView.setScaleType(scaleType);
            this.mCropOverlayView.resetCropOverlayView();
        }
    }

    public CropShape getCropShape() {
        return this.mCropOverlayView.getCropShape();
    }

    public void setCropShape(CropShape cropShape) {
        this.mCropOverlayView.setCropShape(cropShape);
    }

    public boolean isFixAspectRatio() {
        return this.mCropOverlayView.isFixAspectRatio();
    }

    public void setFixedAspectRatio(boolean fixAspectRatio) {
        this.mCropOverlayView.setFixedAspectRatio(fixAspectRatio);
    }

    public Guidelines getGuidelines() {
        return this.mCropOverlayView.getGuidelines();
    }

    public void setGuidelines(Guidelines guidelines) {
        this.mCropOverlayView.setGuidelines(guidelines);
    }

    public Pair<Integer, Integer> getAspectRatio() {
        return new Pair((Object)this.mCropOverlayView.getAspectRatioX(), (Object)this.mCropOverlayView.getAspectRatioY());
    }

    public void setAspectRatio(int aspectRatioX, int aspectRatioY) {
        this.mCropOverlayView.setAspectRatioX(aspectRatioX);
        this.mCropOverlayView.setAspectRatioY(aspectRatioY);
    }

    public void setSnapRadius(float snapRadius) {
        if (snapRadius >= 0.0f) {
            this.mCropOverlayView.setSnapRadius(snapRadius);
        }
    }

    public boolean isShowProgressBar() {
        return this.mShowProgressBar;
    }

    public boolean isShowCropOverlay() {
        return this.mShowCropOverlay;
    }

    public void setShowCropOverlay(boolean showCropOverlay) {
        if (this.mShowCropOverlay != showCropOverlay) {
            this.mShowCropOverlay = showCropOverlay;
            this.setCropOverlayVisibility();
        }
    }

    public void setShowProgressBar(boolean showProgressBar) {
        if (this.mShowProgressBar != showProgressBar) {
            this.mShowProgressBar = showProgressBar;
            this.setProgressBarVisibility();
        }
    }

    public int getImageResource() {
        return this.mImageResource;
    }

    public Uri getImageUri() {
        return this.mLoadedImageUri;
    }

    public void setCropRect(Rect rect) {
        this.mCropOverlayView.setInitialCropWindowRect(rect);
    }

    public Rect getActualCropRect() {
        if (this.mBitmap != null) {
            Rect displayedImageRect = BitmapUtils.getBitmapRect(this.mBitmap, (View)this.mImageView, this.mImageView.getScaleType());
            Pair<Float, Float> scaleFactor = this.getScaleFactorWidth(displayedImageRect);
            RectF cropWindowRect = this.mCropOverlayView.getCropWindowRect();
            float displayedCropLeft = cropWindowRect.left - (float)displayedImageRect.left;
            float displayedCropTop = cropWindowRect.top - (float)displayedImageRect.top;
            float displayedCropWidth = cropWindowRect.width();
            float displayedCropHeight = cropWindowRect.height();
            float actualCropLeft = displayedCropLeft * ((Float)scaleFactor.first).floatValue();
            float actualCropTop = displayedCropTop * ((Float)scaleFactor.second).floatValue();
            float actualCropRight = actualCropLeft + displayedCropWidth * ((Float)scaleFactor.first).floatValue();
            float actualCropBottom = actualCropTop + displayedCropHeight * ((Float)scaleFactor.second).floatValue();
            actualCropLeft = Math.round(Math.max(0.0f, actualCropLeft) * (float)this.mLoadedSampleSize);
            actualCropTop = Math.round(Math.max(0.0f, actualCropTop) * (float)this.mLoadedSampleSize);
            actualCropRight = Math.round(Math.min((float)this.mBitmap.getWidth(), actualCropRight) * (float)this.mLoadedSampleSize);
            actualCropBottom = Math.round(Math.min((float)this.mBitmap.getHeight(), actualCropBottom) * (float)this.mLoadedSampleSize);
            if (this.mCropOverlayView.isFixAspectRatio() && this.mCropOverlayView.getAspectRatioX() == this.mCropOverlayView.getAspectRatioY() && actualCropBottom - actualCropTop != actualCropRight - actualCropLeft) {
                if (actualCropBottom - actualCropTop > actualCropRight - actualCropLeft) {
                    actualCropBottom -= 1.0f;
                } else {
                    actualCropRight -= 1.0f;
                }
            }
            return new Rect((int)actualCropLeft, (int)actualCropTop, (int)actualCropRight, (int)actualCropBottom);
        }
        return null;
    }

    public Rect getActualCropRectNoRotation() {
        if (this.mBitmap != null) {
            Rect rect = this.getActualCropRect();
            int rotateSide = this.mDegreesRotated / 90;
            int bitmapWidth = this.mBitmap.getWidth() * this.mLoadedSampleSize;
            int bitmapHeight = this.mBitmap.getHeight() * this.mLoadedSampleSize;
            if (rotateSide == 1) {
                rect.set(rect.top, bitmapWidth - rect.right, rect.bottom, bitmapWidth - rect.left);
            } else if (rotateSide == 2) {
                rect.set(bitmapWidth - rect.right, bitmapHeight - rect.bottom, bitmapWidth - rect.left, bitmapHeight - rect.top);
            } else if (rotateSide == 3) {
                rect.set(bitmapHeight - rect.bottom, rect.left, bitmapHeight - rect.top, rect.right);
            }
            rect.set(rect.left, rect.top, rect.right, rect.bottom);
            return rect;
        }
        return null;
    }

    public Bitmap getCroppedImage() {
        return this.getCroppedImage(0, 0);
    }

    public Bitmap getCroppedImage(int reqWidth, int reqHeight) {
        if (this.mBitmap != null) {
            if (this.mLoadedImageUri != null && this.mLoadedSampleSize > 1) {
                return BitmapUtils.cropBitmap(this.getContext(), this.mLoadedImageUri, this.getActualCropRectNoRotation(), this.mDegreesRotated, reqWidth, reqHeight);
            }
            return BitmapUtils.cropBitmap(this.mBitmap, this.getActualCropRect());
        }
        return null;
    }

    public Bitmap getCroppedOvalImage() {
        if (this.mBitmap != null) {
            Bitmap cropped = this.getCroppedImage();
            return BitmapUtils.toOvalBitmap(cropped);
        }
        return null;
    }

    public void getCroppedImageAsync() {
        this.getCroppedImageAsync(CropShape.RECTANGLE, 0, 0);
    }

    public void getCroppedImageAsync(CropShape cropShape) {
        this.getCroppedImageAsync(cropShape, 0, 0);
    }

    public void getCroppedImageAsync(CropShape cropShape, int reqWidth, int reqHeight) {
        BitmapCroppingWorkerTask currentTask;
        if (this.mOnGetCroppedImageCompleteListener == null) {
            throw new IllegalArgumentException("OnGetCroppedImageCompleteListener is not set");
        }
        BitmapCroppingWorkerTask bitmapCroppingWorkerTask = currentTask = this.mBitmapCroppingWorkerTask != null ? (BitmapCroppingWorkerTask)((Object)this.mBitmapCroppingWorkerTask.get()) : null;
        if (currentTask != null) {
            currentTask.cancel(true);
        }
        this.mBitmapCroppingWorkerTask = this.mLoadedImageUri != null && this.mLoadedSampleSize > 1 ? new WeakReference<BitmapCroppingWorkerTask>(new BitmapCroppingWorkerTask(this, this.mLoadedImageUri, this.getActualCropRectNoRotation(), cropShape, this.mDegreesRotated, reqWidth, reqHeight)) : new WeakReference<BitmapCroppingWorkerTask>(new BitmapCroppingWorkerTask(this, this.mBitmap, this.getActualCropRect(), cropShape));
        ((BitmapCroppingWorkerTask)((Object)this.mBitmapCroppingWorkerTask.get())).execute(new Void[0]);
        this.setProgressBarVisibility();
    }

    public void setOnSetImageUriCompleteListener(OnSetImageUriCompleteListener listener) {
        this.mOnSetImageUriCompleteListener = listener != null ? new WeakReference<OnSetImageUriCompleteListener>(listener) : null;
    }

    public void setOnGetCroppedImageCompleteListener(OnGetCroppedImageCompleteListener listener) {
        this.mOnGetCroppedImageCompleteListener = listener != null ? new WeakReference<OnGetCroppedImageCompleteListener>(listener) : null;
    }

    public void setImageBitmap(Bitmap bitmap) {
        this.mCropOverlayView.setInitialCropWindowRect(null);
        this.setBitmap(bitmap, true);
    }

    public void setImageBitmap(Bitmap bitmap, ExifInterface exif) {
        Bitmap setBitmap;
        if (bitmap != null && exif != null) {
            BitmapUtils.RotateBitmapResult result = BitmapUtils.rotateBitmapByExif(bitmap, exif);
            setBitmap = result.bitmap;
            this.mDegreesRotated = result.degrees;
        } else {
            setBitmap = bitmap;
        }
        this.mCropOverlayView.setInitialCropWindowRect(null);
        this.setBitmap(setBitmap, true);
    }

    public void setImageResource(int resId) {
        if (resId != 0) {
            this.mCropOverlayView.setInitialCropWindowRect(null);
            Bitmap bitmap = BitmapFactory.decodeResource((Resources)this.getResources(), (int)resId);
            this.setBitmap(bitmap, true);
            this.mImageResource = resId;
        }
    }

    @Deprecated
    public void setImageUri(Uri uri) {
        if (uri != null) {
            this.mCropOverlayView.setInitialCropWindowRect(null);
            DisplayMetrics metrics = this.getResources().getDisplayMetrics();
            double densityAdj = metrics.density > 1.0f ? (double)(1.0f / metrics.density) : 1.0;
            int width = (int)((double)metrics.widthPixels * densityAdj);
            int height = (int)((double)metrics.heightPixels * densityAdj);
            BitmapUtils.DecodeBitmapResult decodeResult = BitmapUtils.decodeSampledBitmap(this.getContext(), uri, width, height);
            BitmapUtils.RotateBitmapResult rotateResult = BitmapUtils.rotateBitmapByExif(this.getContext(), decodeResult.bitmap, uri);
            this.setBitmap(rotateResult.bitmap, true);
            this.mLoadedImageUri = uri;
            this.mLoadedSampleSize = decodeResult.sampleSize;
            this.mDegreesRotated = rotateResult.degrees;
        }
    }

    public void setImageUriAsync(Uri uri) {
        this.setImageUriAsync(uri, null);
    }

    public void clearImage() {
        this.clearImage(true);
        this.mCropOverlayView.setInitialCropWindowRect(null);
    }

    public void rotateImage(int degrees) {
        if (this.mBitmap != null) {
            Matrix matrix = new Matrix();
            matrix.postRotate((float)degrees);
            Bitmap bitmap = Bitmap.createBitmap((Bitmap)this.mBitmap, (int)0, (int)0, (int)this.mBitmap.getWidth(), (int)this.mBitmap.getHeight(), (Matrix)matrix, (boolean)true);
            this.setBitmap(bitmap, false);
            this.mDegreesRotated += degrees;
            this.mDegreesRotated %= 360;
        }
    }

    private void setImageUriAsync(Uri uri, Integer preSetRotation) {
        if (uri != null) {
            BitmapLoadingWorkerTask currentTask;
            BitmapLoadingWorkerTask bitmapLoadingWorkerTask = currentTask = this.mBitmapLoadingWorkerTask != null ? (BitmapLoadingWorkerTask)((Object)this.mBitmapLoadingWorkerTask.get()) : null;
            if (currentTask != null) {
                currentTask.cancel(true);
            }
            this.clearImage(true);
            this.mCropOverlayView.setInitialCropWindowRect(null);
            this.mBitmapLoadingWorkerTask = new WeakReference<BitmapLoadingWorkerTask>(new BitmapLoadingWorkerTask(this, uri, preSetRotation));
            ((BitmapLoadingWorkerTask)((Object)this.mBitmapLoadingWorkerTask.get())).execute(new Void[0]);
            this.setProgressBarVisibility();
        }
    }

    void onSetImageUriAsyncComplete(BitmapLoadingWorkerTask.Result result) {
        OnSetImageUriCompleteListener listener;
        this.mBitmapLoadingWorkerTask = null;
        this.setProgressBarVisibility();
        if (result.error == null) {
            this.setBitmap(result.bitmap, true);
            this.mLoadedImageUri = result.uri;
            this.mLoadedSampleSize = result.loadSampleSize;
            this.mDegreesRotated = result.degreesRotated;
        }
        OnSetImageUriCompleteListener onSetImageUriCompleteListener = listener = this.mOnSetImageUriCompleteListener != null ? (OnSetImageUriCompleteListener)this.mOnSetImageUriCompleteListener.get() : null;
        if (listener != null) {
            listener.onSetImageUriComplete(this, result.uri, result.error);
        }
    }

    void onGetImageCroppingAsyncComplete(BitmapCroppingWorkerTask.Result result) {
        OnGetCroppedImageCompleteListener listener;
        this.mBitmapCroppingWorkerTask = null;
        this.setProgressBarVisibility();
        OnGetCroppedImageCompleteListener onGetCroppedImageCompleteListener = listener = this.mOnGetCroppedImageCompleteListener != null ? (OnGetCroppedImageCompleteListener)this.mOnGetCroppedImageCompleteListener.get() : null;
        if (listener != null) {
            listener.onGetCroppedImageComplete(this, result.bitmap, result.error);
        }
    }

    private void setBitmap(Bitmap bitmap, boolean clearFull) {
        if (this.mBitmap == null || !this.mBitmap.equals(bitmap)) {
            this.clearImage(clearFull);
            this.mBitmap = bitmap;
            this.mImageView.setImageBitmap(this.mBitmap);
            if (this.mCropOverlayView != null) {
                this.mCropOverlayView.resetCropOverlayView();
                this.setCropOverlayVisibility();
            }
        }
    }

    private void clearImage(boolean full) {
        if (this.mBitmap != null && (this.mImageResource > 0 || this.mLoadedImageUri != null)) {
            this.mBitmap.recycle();
        }
        this.mBitmap = null;
        if (full) {
            this.mImageResource = 0;
            this.mLoadedImageUri = null;
            this.mLoadedSampleSize = 1;
            this.mDegreesRotated = 0;
            this.mImageView.setImageBitmap(null);
            this.setCropOverlayVisibility();
        }
    }

    public Parcelable onSaveInstanceState() {
        BitmapLoadingWorkerTask task;
        Bundle bundle = new Bundle();
        bundle.putParcelable("instanceState", super.onSaveInstanceState());
        bundle.putParcelable("LOADED_IMAGE_URI", (Parcelable)this.mLoadedImageUri);
        bundle.putInt("LOADED_IMAGE_RESOURCE", this.mImageResource);
        if (this.mLoadedImageUri == null && this.mImageResource < 1) {
            bundle.putParcelable("SET_BITMAP", (Parcelable)this.mBitmap);
        }
        if (this.mBitmapLoadingWorkerTask != null && (task = (BitmapLoadingWorkerTask)((Object)this.mBitmapLoadingWorkerTask.get())) != null) {
            bundle.putParcelable("LOADING_IMAGE_URI", (Parcelable)task.getUri());
        }
        bundle.putInt("DEGREES_ROTATED", this.mDegreesRotated);
        bundle.putParcelable("INITIAL_CROP_RECT", (Parcelable)this.mCropOverlayView.getInitialCropWindowRect());
        return bundle;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            Bitmap bitmap = null;
            Uri uri = (Uri)bundle.getParcelable("LOADED_IMAGE_URI");
            if (uri != null) {
                this.setImageUriAsync(uri, bundle.getInt("DEGREES_ROTATED"));
            } else {
                int resId = bundle.getInt("LOADED_IMAGE_RESOURCE");
                if (resId > 0) {
                    this.setImageResource(resId);
                } else {
                    bitmap = (Bitmap)bundle.getParcelable("SET_BITMAP");
                    if (bitmap != null) {
                        this.setBitmap(bitmap, true);
                    } else {
                        uri = (Uri)bundle.getParcelable("LOADING_IMAGE_URI");
                        if (uri != null) {
                            this.setImageUriAsync(uri);
                        }
                    }
                }
            }
            this.mDegreesRotated = bundle.getInt("DEGREES_ROTATED");
            if (this.mBitmap != null && bitmap == null) {
                int tmpRotated = this.mDegreesRotated;
                this.rotateImage(this.mDegreesRotated);
                this.mDegreesRotated = tmpRotated;
            }
            this.mCropOverlayView.setInitialCropWindowRect((Rect)bundle.getParcelable("INITIAL_CROP_RECT"));
            super.onRestoreInstanceState(bundle.getParcelable("instanceState"));
        } else {
            super.onRestoreInstanceState(state);
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        if (this.mBitmap != null) {
            Rect bitmapRect = BitmapUtils.getBitmapRect(this.mBitmap, (View)this, this.mImageView.getScaleType());
            this.updateBitmapRect(bitmapRect);
        } else {
            this.updateBitmapRect(CropDefaults.EMPTY_RECT);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (this.mBitmap != null) {
            int desiredHeight;
            int desiredWidth;
            if (heightSize == 0) {
                heightSize = this.mBitmap.getHeight();
            }
            double viewToBitmapWidthRatio = Double.POSITIVE_INFINITY;
            double viewToBitmapHeightRatio = Double.POSITIVE_INFINITY;
            if (widthSize < this.mBitmap.getWidth()) {
                viewToBitmapWidthRatio = (double)widthSize / (double)this.mBitmap.getWidth();
            }
            if (heightSize < this.mBitmap.getHeight()) {
                viewToBitmapHeightRatio = (double)heightSize / (double)this.mBitmap.getHeight();
            }
            if (viewToBitmapWidthRatio != Double.POSITIVE_INFINITY || viewToBitmapHeightRatio != Double.POSITIVE_INFINITY) {
                if (viewToBitmapWidthRatio <= viewToBitmapHeightRatio) {
                    desiredWidth = widthSize;
                    desiredHeight = (int)((double)this.mBitmap.getHeight() * viewToBitmapWidthRatio);
                } else {
                    desiredHeight = heightSize;
                    desiredWidth = (int)((double)this.mBitmap.getWidth() * viewToBitmapHeightRatio);
                }
            } else {
                desiredWidth = this.mBitmap.getWidth();
                desiredHeight = this.mBitmap.getHeight();
            }
            int width = CropImageView.getOnMeasureSpec(widthMode, widthSize, desiredWidth);
            int height = CropImageView.getOnMeasureSpec(heightMode, heightSize, desiredHeight);
            this.mLayoutWidth = width;
            this.mLayoutHeight = height;
            Rect bitmapRect = BitmapUtils.getBitmapRect(this.mBitmap.getWidth(), this.mBitmap.getHeight(), this.mLayoutWidth, this.mLayoutHeight, this.mImageView.getScaleType());
            this.updateBitmapRect(bitmapRect);
            this.setMeasuredDimension(this.mLayoutWidth, this.mLayoutHeight);
        } else {
            this.updateBitmapRect(CropDefaults.EMPTY_RECT);
            this.setMeasuredDimension(widthSize, heightSize);
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        if (this.mLayoutWidth > 0 && this.mLayoutHeight > 0) {
            ViewGroup.LayoutParams origParams = this.getLayoutParams();
            origParams.width = this.mLayoutWidth;
            origParams.height = this.mLayoutHeight;
            this.setLayoutParams(origParams);
        }
    }

    private static int getOnMeasureSpec(int measureSpecMode, int measureSpecSize, int desiredSize) {
        int spec = measureSpecMode == 0x40000000 ? measureSpecSize : (measureSpecMode == Integer.MIN_VALUE ? Math.min(desiredSize, measureSpecSize) : desiredSize);
        return spec;
    }

    private void setCropOverlayVisibility() {
        if (this.mCropOverlayView != null) {
            this.mCropOverlayView.setVisibility(this.mShowCropOverlay && this.mBitmap != null ? 0 : 4);
        }
    }

    private void setProgressBarVisibility() {
        boolean visible = this.mShowProgressBar && (this.mBitmap == null && this.mBitmapLoadingWorkerTask != null || this.mBitmapCroppingWorkerTask != null);
        this.mProgressBar.setVisibility(visible ? 0 : 4);
    }

    private void updateBitmapRect(Rect bitmapRect) {
        if (this.mBitmap != null && bitmapRect.width() > 0 && bitmapRect.height() > 0) {
            float scaleFactorWidth = (float)(this.mBitmap.getWidth() * this.mLoadedSampleSize) / (float)bitmapRect.width();
            float scaleFactorHeight = (float)(this.mBitmap.getHeight() * this.mLoadedSampleSize) / (float)bitmapRect.height();
            this.mCropOverlayView.setScaleFactor(scaleFactorWidth, scaleFactorHeight);
        }
        this.mCropOverlayView.setBitmapRect(bitmapRect);
    }

    private Pair<Float, Float> getScaleFactorWidth(Rect displayedImageRect) {
        float actualImageWidth = this.mBitmap.getWidth();
        float displayedImageWidth = displayedImageRect.width();
        float scaleFactorWidth = actualImageWidth / displayedImageWidth;
        float actualImageHeight = this.mBitmap.getHeight();
        float displayedImageHeight = displayedImageRect.height();
        float scaleFactorHeight = actualImageHeight / displayedImageHeight;
        return Pair.create((Object)Float.valueOf(scaleFactorWidth), (Object)Float.valueOf(scaleFactorHeight));
    }

    public static interface OnGetCroppedImageCompleteListener {
        public void onGetCroppedImageComplete(CropImageView var1, Bitmap var2, Exception var3);
    }

    public static interface OnSetImageUriCompleteListener {
        public void onSetImageUriComplete(CropImageView var1, Uri var2, Exception var3);
    }

    public static enum Guidelines {
        OFF,
        ON_TOUCH,
        ON;

    }

    public static enum CropShape {
        RECTANGLE,
        OVAL;

    }
}

